/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import ptolemy.actor.gui.Configuration;
import ptolemy.data.ArrayToken;
import ptolemy.data.RecordToken;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.attributes.VersionAttribute;
import ptolemy.kernel.util.StringAttribute;

public class GenerateCopyrights {
    public static String generateHTML(Configuration configuration) {
        HashMap copyrightsMap = new HashMap();
        GenerateCopyrights._addIfPresent(copyrightsMap, "com.jgoodies.forms.factories.DefaultComponentFactory", "com/jgoodies/jgoodies-copyright.htm");
        GenerateCopyrights._addIfPresent(copyrightsMap, "jni.GenericJNIActor", "jni/launcher/launcher-copyright.htm");
        GenerateCopyrights._addIfPresent(copyrightsMap, "org.mlc.swing.layout.LayoutConstraintsManager", "org/mlc/mlc-copyright.htm");
        GenerateCopyrights._addIfPresent(copyrightsMap, "caltrop.ptolemy.actors.CalInterpreter", "ptolemy/cal/saxon-copyright.htm");
        GenerateCopyrights._addIfPresent(copyrightsMap, "caltrop.ptolemy.actors.CalInterpreter", "ptolemy/cal/cup-copyright.htm");
        GenerateCopyrights._addIfPresent(copyrightsMap, "ptolemy.actor.lib.colt.ColtRandomSource", "ptolemy/actor/lib/colt/colt-copyright.htm");
        GenerateCopyrights._addIfPresent(copyrightsMap, "ptolemy.backtrack.eclipse.ast.TypeAnalyzer", "ptolemy/backtrack/eclipse/ast/eclipse-copyright.htm");
        GenerateCopyrights._addIfPresent(copyrightsMap, "ptolemy.backtrack.util.ClassFileLoader", "ptolemy/backtrack/util/gcj-copyright.html");
        GenerateCopyrights._addIfPresent(copyrightsMap, "ptolemy.actor.lib.io.comm.SerialComm", "ptolemy/actor/lib/io/comm/copyright.htm");
        GenerateCopyrights._addIfPresent(copyrightsMap, "ptolemy.actor.lib.jai.JAIImageToken", "ptolemy/actor/lib/jai/jai-copyright.htm");
        GenerateCopyrights._addIfPresent(copyrightsMap, "ptolemy.actor.lib.jmf.JMFImageToken", "ptolemy/actor/lib/jmf/jmf-copyright.htm");
        GenerateCopyrights._addIfPresent(copyrightsMap, "ptolemy.actor.lib.joystick.Joystick", "ptolemy/actor/lib/joystick/copyright.htm");
        GenerateCopyrights._addIfPresent(copyrightsMap, "ptolemy.actor.lib.python.PythonScript", "ptolemy/actor/lib/python/copyright.htm");
        GenerateCopyrights._addIfPresent(copyrightsMap, "ptolemy.actor.lib.x10.X10Interface", "ptolemy/actor/lib/x10/x10-copyright.htm");
        GenerateCopyrights._addIfPresent(copyrightsMap, "ptolemy.ptolemy.actor.ptalon.PtalonActor", "ptolemy/actor/ptalon/ptalon-copyright.html");
        GenerateCopyrights._addIfPresent(copyrightsMap, "ptolemy.copernicus.kernel.KernelMain", "ptolemy/copernicus/kernel/soot-copyright.html");
        GenerateCopyrights._addIfPresent(copyrightsMap, "ptolemy.domains.gr.lib.quicktime.MovieViewScreen2D", "ptolemy/domains/gr/lib/quicktime/quicktime-copyright.htm");
        GenerateCopyrights._addIfPresent(copyrightsMap, "ptolemy.domains.gr.kernel.GRActor", "ptolemy/domains/gr/lib/java3d-copyright.htm");
        GenerateCopyrights._addIfPresent(copyrightsMap, "ptolemy.domains.psdf.kernel.PSDFScheduler", "ptolemy/domains/psdf/mapss-copyright.htm");
        GenerateCopyrights._addIfPresent(copyrightsMap, "ptolemy.matlab.Expression", "ptolemy/matlab/copyright.htm");
        GenerateCopyrights._addIfPresent(copyrightsMap, "vendors.vr.Volume", "ptolemy/domains/gr/lib/vr/vr-copyright.htm");
        GenerateCopyrights._addIfPresent(copyrightsMap, "mescal.domains.mescalPE.kernel.parser", "mescal/configs/doc/cup-copyright.htm");
        GenerateCopyrights._addIfPresent(copyrightsMap, "org.satlive.jsat.objects.ExternalLiteral", "mescal/configs/doc/jsat-copyright.htm");
        try {
            Parameter applicationCopyrights = (Parameter)configuration.getAttribute("_applicationCopyrights", Parameter.class);
            if (applicationCopyrights != null) {
                ArrayToken copyrightTokens = (ArrayToken)applicationCopyrights.getToken();
                int i = 0;
                while (i < copyrightTokens.length()) {
                    StringToken actorToken = (StringToken)((RecordToken)copyrightTokens.getElement(i)).get("actor");
                    StringToken copyrightToken = (StringToken)((RecordToken)copyrightTokens.getElement(i)).get("copyright");
                    GenerateCopyrights._addIfPresent(copyrightsMap, actorToken.stringValue(), copyrightToken.stringValue());
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        StringBuffer htmlBuffer = new StringBuffer(GenerateCopyrights.generatePrimaryCopyrightHTML(configuration));
        Iterator copyrights = copyrightsMap.entrySet().iterator();
        if (copyrights.hasNext()) {
            htmlBuffer.append("<p>Below we list features and the corresponding copyright  of the package that is used.  If a feature is not listed below, then the " + GenerateCopyrights._getApplicationName(configuration) + " copyright is the " + "only copyright." + "<table>\n" + "  <tr><th>Feature</th>\n" + "      <th>Copyright of package used by the feature</th>\n" + "  </tr>\n");
            while (copyrights.hasNext()) {
                Map.Entry entry = copyrights.next();
                String copyrightURL = (String)entry.getKey();
                Set entitiesSet = (Set)entry.getValue();
                StringBuffer entityBuffer = new StringBuffer();
                Iterator entities = entitiesSet.iterator();
                while (entities.hasNext()) {
                    if (entityBuffer.length() > 0) {
                        entityBuffer.append(", ");
                    }
                    String entityClassName = (String)entities.next();
                    String docName = "doc.codeDoc." + entityClassName;
                    String codeDoc = GenerateCopyrights._findURL(String.valueOf(docName.replace('.', '/')) + ".html");
                    entityBuffer.append("<a href=\"" + codeDoc + "\">" + entityClassName + "</a>");
                }
                String foundCopyright = GenerateCopyrights._findURL(copyrightURL);
                htmlBuffer.append("<tr><td>" + entityBuffer + "</td>\n    <td> <a href=\"" + foundCopyright + "\"><code>" + GenerateCopyrights._canonicalizeURLToPTII(foundCopyright) + "</code></a></td>\n</tr>\n");
            }
            htmlBuffer.append("</table>\n</p>");
        }
        htmlBuffer.append("<p>Other information <a href=\"about:\">about</a>\nthis configuration.\n</body>\n</html>");
        return htmlBuffer.toString();
    }

    public static String generatePrimaryCopyrightHTML(Configuration configuration) {
        String defaultApplicationCopyright;
        String applicationCopyright = defaultApplicationCopyright = "ptolemy/configs/doc/copyright.htm";
        try {
            StringAttribute applicationCopyrightAttribute = (StringAttribute)configuration.getAttribute("_applicationCopyright", StringAttribute.class);
            if (applicationCopyrightAttribute != null) {
                applicationCopyright = applicationCopyrightAttribute.getExpression();
            }
        }
        catch (Exception exception) {}
        String applicationName = GenerateCopyrights._getApplicationName(configuration);
        String applicationCopyrightURL = GenerateCopyrights._findURL(applicationCopyright);
        String aelfredCopyright = GenerateCopyrights._findURL("com/microstar/xml/README.txt");
        String defaultCSS = GenerateCopyrights._findURL("doc/default.css");
        StringBuffer htmlBuffer = new StringBuffer();
        htmlBuffer.append("<html>\n<head>\n<title>Copyrights</title>\n<link href=\"" + defaultCSS + "\" rel=\"stylesheet\"" + "type=\"text/css\">\n" + "</head>\n<body>\n" + "<h1>" + applicationName + "</h1>\n" + "The primary copyright for the " + applicationName + " System can be\n" + "found in <a href=\"" + applicationCopyrightURL + "\"><code>" + GenerateCopyrights._canonicalizeURLToPTII(applicationCopyrightURL) + "</code></a>.\n" + "This configuration includes code that uses packages\n" + "with the following copyrights.\n");
        if (!applicationCopyright.equals(defaultApplicationCopyright)) {
            String ptolemyIICopyright = GenerateCopyrights._findURL(defaultApplicationCopyright);
            htmlBuffer.append("<p>" + applicationName + " uses Ptolemy II " + VersionAttribute.CURRENT_VERSION.getExpression() + ".\n" + "PtolemyII is covered by the copyright in\n " + "<a href=\"" + ptolemyIICopyright + "\"><code>" + GenerateCopyrights._canonicalizeURLToPTII(ptolemyIICopyright) + "</code></a>\n");
        }
        htmlBuffer.append("<p>" + applicationName + " uses AElfred as an XML Parser.\n" + "AElfred is covered by the copyright in\n " + "<a href=\"" + aelfredCopyright + "\"><code>" + GenerateCopyrights._canonicalizeURLToPTII(aelfredCopyright) + "</code></a>\n");
        return htmlBuffer.toString();
    }

    private static void _addIfPresent(Map copyrightsMap, String className, String copyrightPath) {
        try {
            Class.forName(className);
            HashSet<String> entitiesSet = (HashSet<String>)copyrightsMap.get(copyrightPath);
            if (entitiesSet == null) {
                entitiesSet = new HashSet<String>();
                entitiesSet.add(className);
                copyrightsMap.put(copyrightPath, entitiesSet);
            } else {
                entitiesSet.add(className);
            }
        }
        catch (Throwable throwable) {}
    }

    private static String _canonicalizeURLToPTII(String path) {
        if (!path.startsWith("jar:file")) {
            return path;
        }
        int index = path.lastIndexOf("!");
        if (index == -1) {
            return path;
        }
        return "$PTII" + path.substring(index + 1, path.length());
    }

    private static String _findURL(String localURL) {
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource(localURL);
            return url.toString();
        }
        catch (Exception exception) {
            StringBuffer majorVersionBuffer = new StringBuffer();
            Iterator tuples = VersionAttribute.CURRENT_VERSION.iterator();
            if (tuples.hasNext()) {
                majorVersionBuffer.append((String)tuples.next());
                if (tuples.hasNext()) {
                    majorVersionBuffer.append(".");
                    majorVersionBuffer.append((String)tuples.next());
                }
            }
            String majorVersion = majorVersionBuffer.toString();
            return "http://ptolemy.eecs.berkeley.edu/ptolemyII/ptII" + majorVersion + "/ptII" + majorVersion + "/" + localURL;
        }
    }

    private static String _getApplicationName(Configuration configuration) {
        String applicationName = "Ptolemy II";
        try {
            StringAttribute applicationNameAttribute = (StringAttribute)configuration.getAttribute("_applicationName", StringAttribute.class);
            if (applicationNameAttribute != null) {
                applicationName = applicationNameAttribute.getExpression();
            }
        }
        catch (Exception exception) {}
        return applicationName;
    }
}

