/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.docutils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.PatternRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.python.pydev.core.IPythonPartitions;
import org.python.pydev.core.docutils.PyPartitioner;
import org.python.pydev.core.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyPartitionScanner
extends RuleBasedPartitionScanner
implements IPythonPartitions {
    public PyPartitionScanner() {
        ArrayList<IPredicateRule> rules = new ArrayList<IPredicateRule>();
        this.addMultilineStringRule(rules);
        this.addSinglelineStringRule(rules);
        this.addReprRule(rules);
        this.addCommentRule(rules);
        this.setPredicateRules(rules.toArray(new IPredicateRule[0]));
    }

    private void addReprRule(List<IPredicateRule> rules) {
        rules.add((IPredicateRule)new SingleLineRule("`", "`", (IToken)new Token((Object)"__python_backquotes")));
    }

    private void addSinglelineStringRule(List<IPredicateRule> rules) {
        Token singleLineString1 = new Token((Object)"__python_singleline_string1");
        Token singleLineString2 = new Token((Object)"__python_singleline_string2");
        boolean breaksOnEOL = true;
        boolean breaksOnEOF = false;
        boolean escapeContinuesLine = true;
        rules.add((IPredicateRule)new PatternRule("'", "'", (IToken)singleLineString1, '\\', breaksOnEOL, breaksOnEOF, escapeContinuesLine));
        rules.add((IPredicateRule)new PatternRule("\"", "\"", (IToken)singleLineString2, '\\', breaksOnEOL, breaksOnEOF, escapeContinuesLine));
    }

    private void addMultilineStringRule(List<IPredicateRule> rules) {
        Token multiLineString1 = new Token((Object)"__python_multiline_string1");
        Token multiLineString2 = new Token((Object)"__python_multiline_string2");
        boolean breaksOnEOF = true;
        rules.add((IPredicateRule)new MultiLineRule("'''", "'''", (IToken)multiLineString1, '\\', breaksOnEOF));
        rules.add((IPredicateRule)new MultiLineRule("\"\"\"", "\"\"\"", (IToken)multiLineString2, '\\', breaksOnEOF));
    }

    private void addCommentRule(List<IPredicateRule> rules) {
        Token comment = new Token((Object)"__python_comment");
        rules.add((IPredicateRule)new EndOfLineRule("#", (IToken)comment));
    }

    public static String[] getTypes() {
        return IPythonPartitions.types;
    }

    public static IDocumentPartitioner checkPartitionScanner(IDocument document) {
        if (document == null) {
            return null;
        }
        IDocumentExtension3 docExtension = (IDocumentExtension3)document;
        IDocumentPartitioner partitioner = docExtension.getDocumentPartitioner("__PYTHON_PARTITION_TYPE");
        if (partitioner == null) {
            PyPartitionScanner.addPartitionScanner(document);
            partitioner = docExtension.getDocumentPartitioner("__PYTHON_PARTITION_TYPE");
        }
        if (!(partitioner instanceof PyPartitioner)) {
            Log.log("Partitioner should be subclass of PyPartitioner. It is " + partitioner.getClass());
        }
        return partitioner;
    }

    public static IDocumentPartitioner addPartitionScanner(IDocument document) {
        if (document != null) {
            IDocumentExtension3 docExtension = (IDocumentExtension3)document;
            IDocumentPartitioner curr = docExtension.getDocumentPartitioner("__PYTHON_PARTITION_TYPE");
            if (curr == null) {
                PyPartitioner partitioner = PyPartitionScanner.createPyPartitioner();
                partitioner.connect(document);
                docExtension.setDocumentPartitioner("__PYTHON_PARTITION_TYPE", (IDocumentPartitioner)partitioner);
                return partitioner;
            }
            return curr;
        }
        return null;
    }

    public static PyPartitioner createPyPartitioner() {
        return new PyPartitioner((IPartitionTokenScanner)new PyPartitionScanner(), PyPartitionScanner.getTypes());
    }
}

