/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.cache;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.cache.Cache;
import org.python.pydev.core.cache.CompleteIndexKey;
import org.python.pydev.core.cache.CompleteIndexValue;
import org.python.pydev.core.cache.SoftHashMapCache;
import org.python.pydev.core.callbacks.ICallback;
import org.python.pydev.core.docutils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DiskCache
implements Serializable {
    private static final long serialVersionUID = 4L;
    private static final boolean DEBUG = false;
    private transient Object lock = new Object();
    public static final int DISK_CACHE_IN_MEMORY = 100;
    private String folderToPersist;
    private Map<CompleteIndexKey, CompleteIndexKey> keys = new HashMap<CompleteIndexKey, CompleteIndexKey>();
    private transient Cache<CompleteIndexKey, CompleteIndexValue> cache;
    private String suffix;
    public transient ICallback<CompleteIndexValue, String> readFromFileMethod;
    public transient ICallback<String, CompleteIndexValue> toFileMethod;
    private transient Job scheduleRemoveStale = new JobRemoveStale();

    private void readObject(ObjectInputStream aStream) throws IOException, ClassNotFoundException {
        this.lock = new Object();
        aStream.defaultReadObject();
        this.keys = (Map)aStream.readObject();
        this.folderToPersist = (String)aStream.readObject();
        this.suffix = (String)aStream.readObject();
        this.cache = this.createCache();
        this.scheduleRemoveStale = new JobRemoveStale();
    }

    protected Cache<CompleteIndexKey, CompleteIndexValue> createCache() {
        return new SoftHashMapCache<CompleteIndexKey, CompleteIndexValue>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream aStream) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            aStream.defaultWriteObject();
            aStream.writeObject(this.keys);
            aStream.writeObject(this.folderToPersist);
            aStream.writeObject(this.suffix);
        }
    }

    public DiskCache(File folderToPersist, String suffix, ICallback<CompleteIndexValue, String> readFromFileMethod, ICallback<String, CompleteIndexValue> toFileMethod) {
        this.cache = this.createCache();
        this.folderToPersist = REF.getFileAbsolutePath(folderToPersist);
        this.suffix = suffix;
        this.readFromFileMethod = readFromFileMethod;
        this.toFileMethod = toFileMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tuple<List<Tuple<CompleteIndexKey, CompleteIndexValue>>, Collection<CompleteIndexKey>> getInMemoryInfo() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<Tuple<CompleteIndexKey, CompleteIndexValue>> ret0 = new ArrayList<Tuple<CompleteIndexKey, CompleteIndexValue>>();
            ArrayList<CompleteIndexKey> ret1 = new ArrayList<CompleteIndexKey>();
            for (CompleteIndexKey key : this.keys.values()) {
                CompleteIndexValue value = this.cache.getObj(key);
                if (value != null) {
                    ret0.add(new Tuple<CompleteIndexKey, CompleteIndexValue>(key, value));
                    continue;
                }
                ret1.add(key);
            }
            this.scheduleRemoveStale();
            return new Tuple<List<Tuple<CompleteIndexKey, CompleteIndexValue>>, Collection<CompleteIndexKey>>(ret0, ret1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompleteIndexValue getObj(CompleteIndexKey key) {
        Object object = this.lock;
        synchronized (object) {
            this.scheduleRemoveStale();
            CompleteIndexValue v = this.cache.getObj(key);
            if (v == null && this.keys.containsKey(key)) {
                File file = this.getFileForKey(key);
                if (file.exists()) {
                    String fileContents = REF.getFileContents(file);
                    v = this.readFromFileMethod.call(fileContents);
                }
                if (v == null) {
                    this.remove(key);
                    return null;
                }
                this.cache.add(key, v);
            }
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getFileForKey(CompleteIndexKey o) {
        Object object = this.lock;
        synchronized (object) {
            String name = o.key.name;
            String md5 = StringUtils.md5(name);
            name = String.valueOf(name) + "_" + md5.substring(0, 4);
            return new File(this.folderToPersist, String.valueOf(name) + this.suffix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(CompleteIndexKey key) {
        Object object = this.lock;
        synchronized (object) {
            this.scheduleRemoveStale();
            this.cache.remove(key);
            File fileForKey = this.getFileForKey(key);
            fileForKey.delete();
            this.keys.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(CompleteIndexKey key, CompleteIndexValue n) {
        Object object = this.lock;
        synchronized (object) {
            this.scheduleRemoveStale();
            if (n != null) {
                this.cache.add(key, n);
                File fileForKey = this.getFileForKey(key);
                REF.writeStrToFile(this.toFileMethod.call(n), fileForKey);
            }
            this.keys.put(key, key);
        }
    }

    protected void scheduleRemoveStale() {
        this.scheduleRemoveStale.schedule(1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            for (CompleteIndexKey key : this.keys.keySet()) {
                File fileForKey = this.getFileForKey(key);
                fileForKey.delete();
            }
            this.keys.clear();
            this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<CompleteIndexKey, CompleteIndexKey> keys() {
        Object object = this.lock;
        synchronized (object) {
            return new HashMap<CompleteIndexKey, CompleteIndexKey>(this.keys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFolderToPersist(String folderToPersist) {
        Object object = this.lock;
        synchronized (object) {
            File file = new File(folderToPersist);
            if (!file.exists()) {
                file.mkdirs();
            }
            this.folderToPersist = folderToPersist;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFolderToPersist() {
        Object object = this.lock;
        synchronized (object) {
            return this.folderToPersist;
        }
    }

    private class JobRemoveStale
    extends Job {
        public JobRemoveStale() {
            super("Clear stale references");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Object object = DiskCache.this.lock;
            synchronized (object) {
                if (DiskCache.this.cache != null) {
                    DiskCache.this.cache.removeStaleEntries();
                }
            }
            return Status.OK_STATUS;
        }
    }
}

