/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core;

import java.io.File;
import java.io.Serializable;
import org.python.pydev.core.docutils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModulesKey
implements Comparable<ModulesKey>,
Serializable {
    private static final long serialVersionUID = 2L;
    public String name;
    public File file;

    public ModulesKey(String name, File f) {
        this.name = name;
        this.file = f;
    }

    @Override
    public int compareTo(ModulesKey o) {
        return this.name.compareTo(o.name);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ModulesKey)) {
            return false;
        }
        ModulesKey m = (ModulesKey)o;
        return this.name.equals(m.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        if (this.file != null) {
            StringBuffer ret = new StringBuffer(this.name);
            ret.append(" - ");
            ret.append(this.file);
            return ret.toString();
        }
        return this.name;
    }

    public boolean hasPartStartingWith(String startingWithLowerCase) {
        ProcessCheckIfStartingWithPart onSplit = new ProcessCheckIfStartingWithPart(startingWithLowerCase);
        return !StringUtils.split(this.name.toLowerCase(), '.', onSplit);
    }

    private static final class ProcessCheckIfStartingWithPart
    implements StringUtils.ICallbackOnSplit {
        private final String startingWithLowerCase;

        private ProcessCheckIfStartingWithPart(String startingWithLowerCase) {
            this.startingWithLowerCase = startingWithLowerCase;
        }

        public boolean call(String mod) {
            if (mod.length() == 0) {
                return true;
            }
            return !mod.startsWith(this.startingWithLowerCase);
        }
    }
}

