/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.util.ptolemy;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class DateTimeParameter
extends StringParameter {
    private static final Logger logger = LoggerFactory.getLogger(DateTimeParameter.class);
    private static final DateFormat format1 = new SimpleDateFormat("dd MMM yyyy HH:mm:ss");
    private static final DateFormat format2 = new SimpleDateFormat("dd MMM yyyy");

    public DateTimeParameter(NamedObj namedObj, String string) throws IllegalActionException, NameDuplicationException {
        super(namedObj, string);
    }

    public void setDateValue(Date date) {
        if (date != null) {
            this.setExpression(format1.format(date));
        } else {
            this.setExpression("");
        }
    }

    public Date getDateValue() {
        try {
            return format1.parse(this.stringValue());
        }
        catch (IllegalActionException illegalActionException) {
            logger.error("", (Throwable)illegalActionException);
            return null;
        }
        catch (ParseException parseException) {
            try {
                return format2.parse(this.stringValue());
            }
            catch (IllegalActionException illegalActionException) {
                logger.error("", (Throwable)illegalActionException);
                return null;
            }
            catch (ParseException parseException2) {
                return null;
            }
        }
    }
}

