/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.util;

import java.util.Properties;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerUtils {
    private static final Logger logger = LoggerFactory.getLogger(SchedulerUtils.class);
    private static final String ORG_QUARTZ_SCHEDULER_INSTANCENAME = "org.quartz.scheduler.instanceName";
    private static final String PASSERELLE_QUARTZ_PROPERTIES = "passerelle-quartz.properties";
    private static Properties schedProps = new Properties();

    static {
        try {
            schedProps.load(SchedulerUtils.class.getClassLoader().getResourceAsStream(PASSERELLE_QUARTZ_PROPERTIES));
        }
        catch (Exception exception) {
            schedProps = null;
            logger.warn("Error reading scheduler cfg file passerelle-quartz.properties", (Throwable)exception);
        }
    }

    public static synchronized Scheduler getQuartzScheduler(String string) throws SchedulerException {
        Scheduler scheduler = null;
        if (schedProps == null) {
            throw new SchedulerException("Initialization of scheduler properties failed");
        }
        schedProps.setProperty(ORG_QUARTZ_SCHEDULER_INSTANCENAME, string);
        StdSchedulerFactory stdSchedulerFactory = new StdSchedulerFactory(schedProps);
        scheduler = stdSchedulerFactory.getScheduler();
        return scheduler;
    }
}

