/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.util;

import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.swing.filechooser.FileFilter;

public class ExtensionFileFilter
extends FileFilter {
    private Map filters = new HashMap();
    private String description = null;
    private String fullDescription = null;
    private boolean useExtensionsInDescription = true;

    public ExtensionFileFilter() {
    }

    public ExtensionFileFilter(String string) {
        this(string, null);
    }

    public ExtensionFileFilter(String string, String string2) {
        this(new String[]{string}, string2);
    }

    public ExtensionFileFilter(String[] stringArray) {
        this(stringArray, null);
    }

    public ExtensionFileFilter(String[] stringArray, String string) {
        this.filters = new Hashtable(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            this.addExtension(stringArray[n]);
            ++n;
        }
        this.setDescription(string);
    }

    @Override
    public boolean accept(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                return true;
            }
            String string = this.getExtension(file);
            if (string != null && this.filters.get(this.getExtension(file)) != null) {
                return true;
            }
        }
        return false;
    }

    public String getExtension(File file) {
        String string;
        int n;
        if (file != null && (n = (string = file.getName()).lastIndexOf(46)) > 0 && n < string.length() - 1) {
            return string.substring(n + 1).toLowerCase();
        }
        return null;
    }

    public void addExtension(String string) {
        if (this.filters == null) {
            this.filters = new Hashtable(5);
        }
        this.filters.put(string.toLowerCase(), this);
        this.fullDescription = null;
    }

    public void clearExtensions() {
        this.filters.clear();
    }

    @Override
    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                if (this.description != null) {
                    this.fullDescription = this.description;
                }
                this.fullDescription = String.valueOf(this.fullDescription) + " (";
                Iterator iterator = this.filters.keySet().iterator();
                if (iterator != null) {
                    this.fullDescription = String.valueOf(this.fullDescription) + "." + (String)iterator.next();
                    while (iterator.hasNext()) {
                        this.fullDescription = String.valueOf(this.fullDescription) + ", " + (String)iterator.next();
                    }
                }
                this.fullDescription = String.valueOf(this.fullDescription) + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public void setDescription(String string) {
        this.description = string;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean bl) {
        this.useExtensionsInDescription = bl;
        this.fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }

    public String toString() {
        return this.getDescription();
    }
}

