/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.util;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.domain.cap.Director;
import com.isencia.passerelle.ext.ExecutionTracer;
import com.isencia.passerelle.ext.impl.DefaultExecutionTracer;
import java.util.HashSet;
import java.util.Set;

public class ExecutionTracerService {
    private static Set<ExecutionTracer> defaultTracers = new HashSet<ExecutionTracer>();
    private static ExecutionTracer defaultTracer = new DefaultExecutionTracer();

    public static boolean registerTracer(ExecutionTracer executionTracer) {
        return defaultTracers.add(executionTracer);
    }

    public static boolean removeTracer(ExecutionTracer executionTracer) {
        return defaultTracers.remove(executionTracer);
    }

    public static void trace(Director director, String string) {
        Object object;
        try {
            object = (ExecutionTracer)director.getAttribute("_userTracer");
            object.trace(director, string);
        }
        catch (Throwable throwable) {}
        try {
            if (defaultTracers.isEmpty()) {
                object = (ExecutionTracer)director.getAttribute("_userTracerInIDE");
                if (object == null) {
                    object = defaultTracer;
                }
                object.trace(director, string);
            } else {
                for (ExecutionTracer executionTracer : defaultTracers) {
                    executionTracer.trace(director, string);
                }
            }
        }
        catch (Throwable throwable) {}
    }

    public static void trace(Actor actor, String string) {
        Object object;
        try {
            object = (ExecutionTracer)actor.getDirector().getAttribute("_userTracer");
            object.trace(actor, string);
        }
        catch (Throwable throwable) {}
        try {
            if (defaultTracers.isEmpty()) {
                object = (ExecutionTracer)actor.getDirector().getAttribute("_userTracerInIDE");
                if (object == null) {
                    object = defaultTracer;
                }
                object.trace(actor, string);
            } else {
                for (ExecutionTracer executionTracer : defaultTracers) {
                    executionTracer.trace(actor, string);
                }
            }
        }
        catch (Throwable throwable) {}
    }
}

