/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class EnvironmentUtils {
    private static final String DEFAULT_PASSERELLE_USERLIBRARY_PATH = "/UserLibrary.xml";
    private static final String PASSERELLE_USERLIB_PATH_ENV_VARIABLE = "com.isencia.passerelle.user.library";
    private static File userFolder;
    private static URL userLibraryURL;
    private static File lastSelectedDirectory;

    public static String getApplicationRootFolder() {
        String string = System.getProperty("com.isencia.home");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return System.getProperty("user.dir");
    }

    public static File getUserFolder() {
        if (userFolder == null) {
            URL uRL = EnvironmentUtils.getUserLibraryURL();
            File file = new File(uRL.getPath());
            userFolder = file.getParentFile();
        }
        return userFolder;
    }

    public static URL getUserLibraryURL() {
        File file;
        String string;
        if (userLibraryURL == null && (userLibraryURL = EnvironmentUtils.class.getResource(string = System.getProperty(PASSERELLE_USERLIB_PATH_ENV_VARIABLE, DEFAULT_PASSERELLE_USERLIBRARY_PATH))) == null && (file = new File(String.valueOf(EnvironmentUtils.getApplicationRootFolder()) + "/user", string)).exists()) {
            try {
                userLibraryURL = file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
        return userLibraryURL;
    }

    public static File getLastSelectedDirectory() {
        return lastSelectedDirectory;
    }

    public static void setLastSelectedDirectory(File file) {
        lastSelectedDirectory = file;
    }

    public static File getUserRelevantDirectory() {
        String string;
        File file = EnvironmentUtils.getLastSelectedDirectory();
        if (file == null && (string = System.getProperty("user.home")) != null) {
            file = new File(string);
        }
        return file;
    }
}

