/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.statistics;

import com.isencia.passerelle.statistics.NamedStatistics;
import com.isencia.passerelle.statistics.StatisticsService;
import com.isencia.passerelle.statistics.StatisticsServiceDummyImpl;
import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

class StatisticsServiceImpl
extends StatisticsServiceDummyImpl
implements StatisticsService {
    private MBeanServer svr;
    private Set<ObjectName> registeredNames = new HashSet<ObjectName>();

    protected StatisticsServiceImpl() {
        try {
            this.svr = ManagementFactory.getPlatformMBeanServer();
            this.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getServerName() {
        return "TestSvr";
    }

    @Override
    public void registerStatistics(NamedStatistics namedStatistics) {
        try {
            ObjectName objectName = new ObjectName(String.valueOf(this.getServerName()) + ":name=" + namedStatistics.getName());
            this.registerMBean(namedStatistics, objectName);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void registerMBean(Object object, ObjectName objectName) throws MBeanRegistrationException, NotCompliantMBeanException {
        try {
            if (this.svr.isRegistered(objectName)) {
                try {
                    this.svr.unregisterMBean(objectName);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {}
            }
            this.svr.registerMBean(object, objectName);
            this.registeredNames.add(objectName);
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {}
    }

    @Override
    public synchronized void start() {
    }

    @Override
    public synchronized void stop() {
    }

    @Override
    public void reset() {
        this.stop();
        for (ObjectName objectName : this.registeredNames) {
            try {
                this.svr.unregisterMBean(objectName);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

