/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.statistics;

import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.statistics.EventStatistics;
import com.isencia.passerelle.statistics.InsufficientDataException;
import com.isencia.passerelle.statistics.NamedStatistics;
import com.isencia.passerelle.statistics.PortStatisticsMBean;

public class PortStatistics
implements PortStatisticsMBean,
NamedStatistics {
    private Port port;
    private EventStatistics receiptStatistics;
    private EventStatistics sendingStatistics;

    public PortStatistics(Port port) {
        this.port = port;
        this.receiptStatistics = new EventStatistics();
        this.sendingStatistics = new EventStatistics();
    }

    public void acceptReceivedMessage(ManagedMessage managedMessage) {
        this.receiptStatistics.acceptEvent(managedMessage);
    }

    public void acceptSentMessage(ManagedMessage managedMessage) {
        this.sendingStatistics.acceptEvent(managedMessage);
    }

    public Port getPort() {
        return this.port;
    }

    public EventStatistics getReceiptStatistics() {
        return this.receiptStatistics;
    }

    public EventStatistics getSendingStatistics() {
        return this.sendingStatistics;
    }

    @Override
    public long getNrSentMessages() {
        return this.sendingStatistics.getNrEvents();
    }

    @Override
    public long getAvgIntervalSentMessages() {
        try {
            return this.sendingStatistics.getAvgInterval();
        }
        catch (InsufficientDataException insufficientDataException) {
            return 0L;
        }
    }

    @Override
    public long getNrReceivedMessages() {
        return this.receiptStatistics.getNrEvents();
    }

    @Override
    public long getAvgIntervalReceivedMessages() {
        try {
            return this.receiptStatistics.getAvgInterval();
        }
        catch (InsufficientDataException insufficientDataException) {
            return 0L;
        }
    }

    @Override
    public void reset() {
        this.receiptStatistics.reset();
        this.sendingStatistics.reset();
    }

    @Override
    public String getName() {
        return this.getPort().getFullName();
    }
}

