/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.statistics;

import com.isencia.passerelle.statistics.InsufficientDataException;
import com.isencia.passerelle.statistics.StatisticalLongData;
import java.util.Date;

final class EventStatistics {
    private Date lastTime = new Date();
    private StatisticalLongData statData = new StatisticalLongData();

    EventStatistics() {
    }

    public void acceptEvent(Object object) {
        Date date = new Date();
        this.statData.acceptData(date.getTime() - this.lastTime.getTime());
        this.lastTime = date;
    }

    void reset() {
        this.lastTime = new Date();
        this.statData.reset();
    }

    public long getAvgInterval() throws InsufficientDataException {
        return this.statData.getAvgData();
    }

    public Date getLastTime() {
        return this.lastTime;
    }

    public long getMaxInterval() throws InsufficientDataException {
        return this.statData.getMaxData();
    }

    public long getMinInterval() throws InsufficientDataException {
        return this.statData.getMinData();
    }

    public boolean isWaitingForSufficientData() {
        return this.statData.isWaitingForSufficientData();
    }

    public long getNrEvents() {
        return this.statData.getCount();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[EventStatistics:");
        stringBuffer.append(" lastTime: ");
        stringBuffer.append(this.lastTime);
        stringBuffer.append(this.statData);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

