/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.statistics;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.statistics.ActorStatisticsMBean;
import com.isencia.passerelle.statistics.CycleStatistics;
import com.isencia.passerelle.statistics.InsufficientDataException;
import com.isencia.passerelle.statistics.NamedStatistics;

public class ActorStatistics
implements ActorStatisticsMBean,
NamedStatistics {
    private Actor actor;
    private CycleStatistics cycleStatistics = new CycleStatistics();

    public ActorStatistics(Actor actor) {
        this.actor = actor;
    }

    public void beginCycle() {
        this.cycleStatistics.acceptCycleBegin();
    }

    public void endCycle() {
        this.cycleStatistics.acceptCycleEnd();
    }

    public Actor getActor() {
        return this.actor;
    }

    @Override
    public long getNrCycles() {
        return this.cycleStatistics.getNrCycles();
    }

    @Override
    public void reset() {
        this.cycleStatistics.reset();
    }

    @Override
    public String getName() {
        return this.getActor().getFullName();
    }

    @Override
    public long getAvgCycleTime() {
        try {
            return this.cycleStatistics.getAvgProcessingTime();
        }
        catch (InsufficientDataException insufficientDataException) {
            return 0L;
        }
    }

    @Override
    public long getAvgIdleTime() {
        try {
            return this.cycleStatistics.getAvgIdleTime();
        }
        catch (InsufficientDataException insufficientDataException) {
            return 0L;
        }
    }

    @Override
    public long getMinCycleTime() {
        try {
            return this.cycleStatistics.getMinProcessingTime();
        }
        catch (InsufficientDataException insufficientDataException) {
            return 0L;
        }
    }

    @Override
    public long getMinIdleTime() {
        try {
            return this.cycleStatistics.getMinIdleTime();
        }
        catch (InsufficientDataException insufficientDataException) {
            return 0L;
        }
    }

    @Override
    public long getMaxCycleTime() {
        try {
            return this.cycleStatistics.getMaxProcessingTime();
        }
        catch (InsufficientDataException insufficientDataException) {
            return 0L;
        }
    }

    @Override
    public long getMaxIdleTime() {
        try {
            return this.cycleStatistics.getMaxIdleTime();
        }
        catch (InsufficientDataException insufficientDataException) {
            return 0L;
        }
    }
}

