/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.model;

import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.domain.ProcessThread;
import com.isencia.passerelle.engine.activator.Activator;
import com.isencia.passerelle.ext.ErrorCollector;
import com.isencia.passerelle.ext.ExecutionControlStrategy;
import com.isencia.passerelle.ext.impl.SuspendResumeExecutionControlStrategy;
import com.isencia.passerelle.model.ExecutionTraceRecord;
import com.isencia.passerelle.model.Flow;
import com.isencia.passerelle.model.FlowAlreadyExecutingException;
import com.isencia.passerelle.model.FlowHandle;
import com.isencia.passerelle.model.FlowNotExecutingException;
import com.isencia.passerelle.model.util.MoMLParser;
import com.isencia.passerelle.model.util.RESTFacade;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.ExecutionListener;
import ptolemy.actor.Manager;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.util.IllegalActionException;

public class FlowManager {
    private final Logger logger = LoggerFactory.getLogger(FlowManager.class);
    private final Map<FlowHandle, com.isencia.passerelle.core.Manager> flowExecutions = new HashMap<FlowHandle, com.isencia.passerelle.core.Manager>();
    private final Map<FlowHandle, ExecutionListener> flowExecutionListeners = new HashMap<FlowHandle, ExecutionListener>();
    private final List<Flow> remoteFlowExecutionsList = new ArrayList<Flow>();
    private static RESTFacade restFacade;

    public static void applyParameterSettings(Flow flow, Map<String, String> map) throws PasserelleException {
        FlowManager.applyParameterSettings(flow, map, null);
    }

    public static void applyParameterSettings(Flow flow, Map<String, String> map, Map<String, Object> map2) throws PasserelleException {
        block6: for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            String[] stringArray = string.split("[\\.]");
            Flow flow2 = flow;
            if (flow2 instanceof CompositeActor && !flow2.attributeList().isEmpty()) {
                try {
                    Parameter parameter = (Parameter)flow2.getAttribute(stringArray[stringArray.length - 1], Parameter.class);
                    if (parameter != null) {
                        parameter.setExpression(string2);
                        parameter.setPersistent(true);
                    }
                }
                catch (IllegalActionException illegalActionException) {
                    illegalActionException.printStackTrace();
                }
            }
            int n = 0;
            while (n < stringArray.length - 1) {
                block15: {
                    Director director;
                    if (!(flow2 instanceof CompositeActor)) continue block6;
                    ComponentEntity componentEntity = ((CompositeActor)flow2).getEntity(stringArray[n]);
                    if (componentEntity == null) {
                        try {
                            director = ((CompositeActor)flow2).getDirector();
                            if (director == null) break block15;
                            Parameter parameter = (Parameter)director.getAttribute(stringArray[stringArray.length - 1], Parameter.class);
                            if (parameter != null) {
                                parameter.setExpression(string2);
                                parameter.setPersistent(true);
                                break block15;
                            }
                            throw new PasserelleException("Inconsistent Parameters", (Object)flow, null);
                        }
                        catch (IllegalActionException illegalActionException) {}
                    } else if ((flow2 = ((CompositeActor)flow2).getEntity(stringArray[n])) != null) {
                        try {
                            director = (Parameter)flow2.getAttribute(stringArray[stringArray.length - 1], Parameter.class);
                            if (director != null) {
                                director.setExpression(string2);
                                director.setPersistent(true);
                            }
                        }
                        catch (IllegalActionException illegalActionException) {
                            illegalActionException.printStackTrace();
                        }
                    }
                }
                ++n;
            }
        }
    }

    private static Flow buildFlowFromHandle(FlowHandle flowHandle) throws Exception {
        Flow flow = FlowManager.readMoml(new StringReader(flowHandle.getMoml()));
        flow.setHandle(flowHandle);
        return flow;
    }

    public static Collection<FlowHandle> getFlowsFromResourceLocation(URL uRL) throws PasserelleException {
        if (uRL == null) {
            return null;
        }
        ArrayList<FlowHandle> arrayList = null;
        String string = uRL.getProtocol();
        if ("http".equals(string) || "https".equals(string)) {
            if (restFacade == null) {
                FlowManager.initRESTFacade();
            }
            arrayList = restFacade.getAllRemoteFlowHandles(uRL);
        } else if ("file".equals(string)) {
            arrayList = new ArrayList<FlowHandle>();
            try {
                File file = new File(uRL.toURI());
                if (file != null && file.exists()) {
                    File[] fileArray;
                    FilenameFilter filenameFilter = new FilenameFilter(){

                        @Override
                        public boolean accept(File file, String string) {
                            return string.endsWith(".moml");
                        }
                    };
                    File[] fileArray2 = fileArray = file.listFiles(filenameFilter);
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file2 = fileArray2[n2];
                        FlowHandle flowHandle = new FlowHandle(null, file2.getName(), file2.toURL());
                        arrayList.add(flowHandle);
                        ++n2;
                    }
                }
            }
            catch (Exception exception) {
                throw new PasserelleException("Error reading flows from " + uRL, null, exception);
            }
        }
        return arrayList != null ? arrayList : new ArrayList<FlowHandle>();
    }

    public static List<ExecutionTraceRecord> getRemoteExecutionTraces(FlowHandle flowHandle) throws IllegalStateException, IllegalArgumentException, PasserelleException, Exception {
        if (flowHandle.isRemote()) {
            if (restFacade == null) {
                FlowManager.initRESTFacade();
            }
            return restFacade.getRemoteExecutionTraces(flowHandle);
        }
        throw new IllegalArgumentException("Flow is not managed remotely");
    }

    private static void initRESTFacade() {
        restFacade = new RESTFacade(10000, 10000);
    }

    public static Flow readMoml(Reader reader) throws Exception {
        ClassLoader classLoader = null;
        try {
            classLoader = Activator.class.getClassLoader();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            classLoader = FlowManager.class.getClassLoader();
        }
        return FlowManager.readMoml(reader, classLoader);
    }

    public static Flow readMoml(Reader reader, ClassLoader classLoader) throws Exception {
        MoMLParser moMLParser = new MoMLParser(null, classLoader);
        Flow flow = (Flow)moMLParser.parse(null, reader);
        FlowHandle flowHandle = new FlowHandle(0L, flow.getFullName(), null);
        flow.setHandle(flowHandle);
        return flow;
    }

    public static Flow readMoml(URL uRL) throws Exception {
        ClassLoader classLoader = null;
        try {
            classLoader = Activator.class.getClassLoader();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            classLoader = FlowManager.class.getClassLoader();
        }
        return FlowManager.readMoml(uRL, classLoader);
    }

    public static Flow readMoml(URL uRL, ClassLoader classLoader) throws Exception {
        if (uRL == null) {
            return null;
        }
        String string = uRL.getProtocol();
        if ("file".equals(string) || "jar".equals(string) || "bundleresource".equals(string)) {
            MoMLParser moMLParser = new MoMLParser(null, classLoader);
            MoMLParser.purgeModelRecord(uRL);
            Flow flow = (Flow)moMLParser.parse(null, uRL);
            FlowHandle flowHandle = new FlowHandle(0L, flow.getFullName(), uRL);
            flow.setHandle(flowHandle);
            return flow;
        }
        if ("http".equals(string) || "https".equals(string)) {
            if (restFacade == null) {
                FlowManager.initRESTFacade();
            }
            FlowHandle flowHandle = restFacade.getRemoteFlowHandle(uRL);
            return FlowManager.buildFlowFromHandle(flowHandle);
        }
        throw new IllegalArgumentException("Unsupported URL protocol " + string);
    }

    public static Flow save(Flow flow, URL uRL) throws IOException, PasserelleException, Exception {
        if (!flow.getHandle().isRemote()) {
            FlowManager.writeMoml(flow, new BufferedWriter(new FileWriter(uRL.getFile())));
            return flow;
        }
        if (restFacade == null) {
            FlowManager.initRESTFacade();
        }
        FlowHandle flowHandle = restFacade.updateRemoteFlow(flow);
        return FlowManager.buildFlowFromHandle(flowHandle);
    }

    public static Flow saveMomlParameterUpdates(Flow flow, Map<String, String> map) throws Exception {
        FlowManager.applyParameterSettings(flow, map);
        if (flow.getHandle().isRemote()) {
            if (restFacade == null) {
                FlowManager.initRESTFacade();
            }
            FlowHandle flowHandle = restFacade.updateRemoteFlow(flow.getHandle(), map);
            return FlowManager.buildFlowFromHandle(flowHandle);
        }
        if (flow.getHandle().getAuthorativeResourceLocation() != null) {
            OutputStreamWriter outputStreamWriter = null;
            try {
                File file = new File(flow.getHandle().getAuthorativeResourceLocation().toURI());
                outputStreamWriter = new FileWriter(file);
                FlowManager.writeMoml(flow, outputStreamWriter);
            }
            catch (Throwable throwable) {
                if (outputStreamWriter != null) {
                    try {
                        outputStreamWriter.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
        return flow;
    }

    public static void writeMoml(Flow flow, Writer writer) throws IOException {
        String string = flow.exportMoML();
        writer.append(string);
        writer.flush();
    }

    public void execute(Flow flow, Map<String, String> map) throws Exception {
        if (flow.getHandle().isRemote()) {
            this.executeOnServer(flow, map);
        } else {
            this.executeLocally(flow, map);
        }
    }

    public void execute(Flow flow, Map<String, String> map, ExecutionListener executionListener) throws Exception {
        if (flow.getHandle().isRemote()) {
            this.executeOnServer(flow, map);
            flow.setExecutionListener(executionListener);
        } else {
            this.executeLocally(flow, map, executionListener);
        }
    }

    public void executeBlockingErrorLocally(Flow flow, Map<String, String> map) throws FlowAlreadyExecutingException, PasserelleException {
        FlowHandle flowHandle = flow.getHandle();
        if (flowHandle == null) {
            throw new PasserelleException("Invalid flow : missing FlowHandle", (Object)flow, null);
        }
        this.checkFlowAlreadyExecuting(flow);
        if (map != null) {
            FlowManager.applyParameterSettings(flow, map);
        }
        ModelExecutionListener modelExecutionListener = new ModelExecutionListener(flow);
        try {
            try {
                com.isencia.passerelle.core.Manager manager = new com.isencia.passerelle.core.Manager(flow.workspace(), flow.getName());
                flow.setManager(manager);
                this.flowExecutions.put(flowHandle, manager);
                com.isencia.passerelle.domain.cap.Director director = (com.isencia.passerelle.domain.cap.Director)flow.getDirector();
                director.removeAllErrorCollectors();
                director.addErrorCollector(modelExecutionListener);
                manager.addExecutionListener(modelExecutionListener);
                manager.execute();
            }
            catch (IllegalActionException illegalActionException) {
                throw new FlowAlreadyExecutingException("", (Object)flow, illegalActionException);
            }
            catch (Exception exception) {
                throw new PasserelleException("Error executing flow", (Object)flow, exception);
            }
        }
        finally {
            this.executionFinished(flow);
        }
        try {
            modelExecutionListener.illegalActionExceptionOccured();
        }
        catch (IllegalActionException illegalActionException) {
            throw new PasserelleException("Execution Error", (Object)flow, illegalActionException);
        }
        modelExecutionListener.passerelleExceptionOccured();
        try {
            modelExecutionListener.otherExceptionOccured();
        }
        catch (Throwable throwable) {
            throw new PasserelleException("UNKNOWN Execution Error", (Object)flow, throwable);
        }
    }

    public void executeBlockingLocally(Flow flow, Map<String, String> map) throws FlowAlreadyExecutingException, PasserelleException {
        FlowHandle flowHandle = flow.getHandle();
        if (flowHandle == null) {
            throw new PasserelleException("Invalid flow : missing FlowHandle", (Object)flow, null);
        }
        this.checkFlowAlreadyExecuting(flow);
        if (map != null) {
            FlowManager.applyParameterSettings(flow, map);
        }
        try {
            try {
                com.isencia.passerelle.core.Manager manager = new com.isencia.passerelle.core.Manager(flow.workspace(), flow.getName());
                flow.setManager(manager);
                this.flowExecutions.put(flowHandle, manager);
                manager.execute();
            }
            catch (IllegalActionException illegalActionException) {
                throw new FlowAlreadyExecutingException("", (Object)flow, illegalActionException);
            }
            catch (Exception exception) {
                throw new PasserelleException("Error executing flow", (Object)flow, exception);
            }
        }
        finally {
            this.executionFinished(flow);
        }
    }

    public void executeBlockingLocally(Flow flow, Map<String, String> map, ExecutionListener executionListener) throws FlowAlreadyExecutingException, PasserelleException {
        FlowHandle flowHandle = flow.getHandle();
        if (flowHandle == null) {
            throw new PasserelleException("Invalid flow : missing FlowHandle", (Object)flow, null);
        }
        this.checkFlowAlreadyExecuting(flow);
        if (map != null) {
            FlowManager.applyParameterSettings(flow, map);
        }
        try {
            try {
                com.isencia.passerelle.core.Manager manager = new com.isencia.passerelle.core.Manager(flow.workspace(), flow.getName());
                flow.setManager(manager);
                this.flowExecutions.put(flowHandle, manager);
                manager.addExecutionListener(executionListener);
                manager.run();
            }
            catch (Exception exception) {
                throw new PasserelleException("Error executing flow", (Object)flow, exception);
            }
        }
        finally {
            this.executionFinished(flow);
        }
    }

    private void executeLocally(Flow flow, Map<String, String> map) throws PasserelleException {
        FlowHandle flowHandle = flow.getHandle();
        if (flowHandle == null) {
            throw new PasserelleException("Invalid flow : missing FlowHandle", (Object)flow, null);
        }
        this.checkFlowAlreadyExecuting(flow);
        if (map != null) {
            FlowManager.applyParameterSettings(flow, map);
        }
        try {
            FlowManager flowManager = this;
            flowManager.getClass();
            ModelExecutionListener modelExecutionListener = flowManager.new ModelExecutionListener(flow);
            this.flowExecutionListeners.put(flowHandle, modelExecutionListener);
            com.isencia.passerelle.core.Manager manager = new com.isencia.passerelle.core.Manager(flow.workspace(), flow.getName());
            manager.addExecutionListener(modelExecutionListener);
            flow.setManager(manager);
            this.flowExecutions.put(flowHandle, manager);
            manager.startRun();
        }
        catch (IllegalActionException illegalActionException) {
            throw new FlowAlreadyExecutingException("", (Object)flow, illegalActionException);
        }
    }

    private void executeLocally(Flow flow, Map<String, String> map, ExecutionListener executionListener) throws FlowAlreadyExecutingException, PasserelleException {
        FlowHandle flowHandle = flow.getHandle();
        if (flowHandle == null) {
            throw new PasserelleException("Invalid flow : missing FlowHandle", (Object)flow, null);
        }
        this.checkFlowAlreadyExecuting(flow);
        if (map != null) {
            FlowManager.applyParameterSettings(flow, map);
        }
        try {
            FlowManager flowManager = this;
            flowManager.getClass();
            ModelExecutionListener modelExecutionListener = flowManager.new ModelExecutionListener(flow);
            this.flowExecutionListeners.put(flowHandle, modelExecutionListener);
            com.isencia.passerelle.core.Manager manager = new com.isencia.passerelle.core.Manager(flow.workspace(), flow.getName());
            manager.addExecutionListener(modelExecutionListener);
            manager.addExecutionListener(executionListener);
            flow.setManager(manager);
            this.flowExecutions.put(flowHandle, manager);
            manager.startRun();
        }
        catch (IllegalActionException illegalActionException) {
            throw new FlowAlreadyExecutingException("", (Object)flow, illegalActionException);
        }
    }

    protected void checkFlowAlreadyExecuting(Flow flow) throws FlowAlreadyExecutingException {
        com.isencia.passerelle.core.Manager manager = this.flowExecutions.get(flow.getHandle());
        if (manager != null) {
            if (com.isencia.passerelle.core.Manager.IDLE.equals(manager.getState())) {
                this.executionFinished(flow);
            } else {
                throw new FlowAlreadyExecutingException("", (Object)flow, null);
            }
        }
    }

    private Flow executeOnServer(Flow flow, Map<String, String> map) throws Exception {
        if (restFacade == null) {
            FlowManager.initRESTFacade();
        }
        if (this.remoteFlowExecutionsList.contains((Object)flow)) {
            throw new FlowAlreadyExecutingException("", (Object)flow, null);
        }
        FlowHandle flowHandle = flow.getHandle();
        if (map != null && !map.isEmpty()) {
            flowHandle = restFacade.updateRemoteFlow(flow.getHandle(), map);
        }
        FlowHandle flowHandle2 = restFacade.startFlowRemotely(flowHandle);
        this.remoteFlowExecutionsList.add(flow);
        flow.setHandle(flowHandle2);
        return flow;
    }

    private synchronized void executionFinished(Flow flow) {
        this.flowExecutionListeners.remove(flow.getHandle());
        if (flow.getHandle().isRemote()) {
            this.remoteFlowExecutionsList.remove((Object)flow);
        } else {
            com.isencia.passerelle.core.Manager manager = this.flowExecutions.get(flow.getHandle());
            if (manager != null) {
                this.flowExecutions.remove(flow.getHandle());
                try {
                    flow.setManager(null);
                }
                catch (IllegalActionException illegalActionException) {}
            }
        }
    }

    public Collection<FlowHandle> getExecutingFlows(URL uRL) throws PasserelleException {
        if (uRL != null && uRL.getProtocol().startsWith("http")) {
            if (restFacade == null) {
                FlowManager.initRESTFacade();
            }
            return restFacade.getAllRemoteExecutingFlowHandles(uRL);
        }
        Set<FlowHandle> set = this.flowExecutions.keySet();
        return Collections.unmodifiableCollection(set);
    }

    public Manager.State getLocalExecutionState(Flow flow) throws FlowNotExecutingException {
        if (flow.getHandle().isRemote()) {
            throw new IllegalArgumentException("Flow is not managed locally");
        }
        com.isencia.passerelle.core.Manager manager = this.flowExecutions.get(flow.getHandle());
        if (manager == null) {
            throw new FlowNotExecutingException("", (Object)flow, null);
        }
        return manager.getState();
    }

    public List<Flow> getRemoteFlowExecutionsList() {
        return this.remoteFlowExecutionsList;
    }

    public synchronized Flow stopExecution(Flow flow) throws IllegalStateException, IllegalArgumentException, PasserelleException, Exception {
        return this.stopExecution(flow, -1L);
    }

    public synchronized Flow stopExecution(Flow flow, long l) throws IllegalStateException, IllegalArgumentException, PasserelleException, Exception {
        this.logger.info("Stopping {}", (Object)flow.getName());
        FlowHandle flowHandle = flow.getHandle();
        if (flowHandle == null) {
            throw new PasserelleException("Invalid flow : missing FlowHandle", (Object)flow, null);
        }
        if (flowHandle.isRemote()) {
            if (!this.remoteFlowExecutionsList.contains((Object)flow)) {
                throw new FlowNotExecutingException("", (Object)flow, null);
            }
            if (restFacade == null) {
                FlowManager.initRESTFacade();
            }
            FlowHandle flowHandle2 = restFacade.stopFlowRemotely(flowHandle);
            return FlowManager.buildFlowFromHandle(flowHandle2);
        }
        com.isencia.passerelle.core.Manager manager = this.flowExecutions.get(flowHandle);
        if (manager == null) {
            throw new FlowNotExecutingException("", (Object)flow, null);
        }
        manager.stop();
        long l2 = 0L;
        boolean bl = false;
        while (!manager.getState().equals(com.isencia.passerelle.core.Manager.IDLE) && !bl) {
            try {
                Thread.sleep(100L);
                bl = l > 0L && l < (l2 += 100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.logger.info("{} stopped to state {}", (Object)flow.getName(), (Object)manager.getState());
        try {
            Collection<ProcessThread> collection = ((com.isencia.passerelle.domain.cap.Director)flow.getDirector()).getThreads();
            if (!collection.isEmpty()) {
                this.logger.warn("Failed to do a clean stop of {}", (Object)flow.getName());
                for (ProcessThread processThread : collection) {
                    this.logger.warn("{} - pending thread {}", (Object)flow.getName(), (Object)processThread.toString());
                }
            }
        }
        catch (Exception exception) {}
        this.executionFinished(flow);
        return flow;
    }

    public synchronized Flow pauseExecution(Flow flow) throws IllegalStateException, IllegalArgumentException, PasserelleException, Exception {
        FlowHandle flowHandle = flow.getHandle();
        if (flowHandle == null) {
            throw new PasserelleException("Invalid flow : missing FlowHandle", (Object)flow, null);
        }
        if (flowHandle.isRemote()) {
            throw new IllegalArgumentException("Suspend not yet supported for remote execution");
        }
        com.isencia.passerelle.core.Manager manager = this.flowExecutions.get(flowHandle);
        if (manager == null) {
            throw new FlowNotExecutingException("Flow is not executing", (Object)flow, null);
        }
        manager.pause();
        return flow;
    }

    public synchronized Flow resumeExecution(Flow flow) throws IllegalStateException, IllegalArgumentException, PasserelleException, Exception {
        FlowHandle flowHandle = flow.getHandle();
        if (flowHandle == null) {
            throw new PasserelleException("Invalid flow : missing FlowHandle", (Object)flow, null);
        }
        if (flowHandle.isRemote()) {
            throw new IllegalArgumentException("Flow is not managed locally");
        }
        com.isencia.passerelle.core.Manager manager = this.flowExecutions.get(flowHandle);
        if (manager == null) {
            throw new FlowNotExecutingException("Flow is not executing", (Object)flow, null);
        }
        manager.resume();
        try {
            ExecutionControlStrategy executionControlStrategy = ((com.isencia.passerelle.domain.cap.Director)flow.getDirector()).getExecutionControlStrategy();
            if (executionControlStrategy instanceof SuspendResumeExecutionControlStrategy) {
                ((SuspendResumeExecutionControlStrategy)executionControlStrategy).resume();
            }
        }
        catch (ClassCastException classCastException) {
            this.logger.error("Received resume event, but model not configured correctly", (Throwable)classCastException);
        }
        return flow;
    }

    protected class ModelExecutionListener
    implements ExecutionListener,
    ErrorCollector {
        private Throwable throwable;
        private final Flow flow;

        ModelExecutionListener(Flow flow) {
            this.flow = flow;
        }

        @Override
        public void acceptError(PasserelleException passerelleException) {
            this.executionError(null, passerelleException);
        }

        public void executionError(Manager manager, Throwable throwable) {
            this.throwable = throwable;
            FlowManager.this.logger.error("Error during model execution", throwable);
        }

        public void executionFinished(Manager manager) {
            FlowManager.this.executionFinished(this.flow);
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public void illegalActionExceptionOccured() throws IllegalActionException {
            Throwable throwable;
            if (this.throwable != null && (throwable = this.throwable) instanceof IllegalActionException) {
                this.throwable = null;
                throw (IllegalActionException)throwable;
            }
        }

        public void managerStateChanged(Manager manager) {
        }

        public void otherExceptionOccured() throws Throwable {
            Throwable throwable;
            if (this.throwable != null && !((throwable = this.throwable) instanceof IllegalActionException) && !(throwable instanceof PasserelleException)) {
                this.throwable = null;
                throw throwable;
            }
        }

        public void passerelleExceptionOccured() throws PasserelleException {
            Throwable throwable;
            if (this.throwable != null && (throwable = this.throwable) instanceof PasserelleException) {
                this.throwable = null;
                throw (PasserelleException)throwable;
            }
        }
    }
}

