/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.model;

import com.isencia.passerelle.model.FlowHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import ptolemy.actor.Actor;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.ExecutionListener;
import ptolemy.actor.IOPort;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.ComponentPort;
import ptolemy.kernel.ComponentRelation;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Workspace;

public class Flow
extends TypedCompositeActor {
    private URL authorativeResourceLocation;
    private FlowHandle handle;
    private ExecutionListener executionListener;
    private boolean loadedFaultless = true;

    public void reportLoadingError(Throwable throwable) {
        if (throwable != null) {
            this.loadedFaultless = false;
        }
    }

    public boolean isLoadedFaultless() {
        return this.loadedFaultless;
    }

    public ExecutionListener getExecutionListener() {
        return this.executionListener;
    }

    public void setExecutionListener(ExecutionListener executionListener) {
        this.executionListener = executionListener;
    }

    public Flow(String string, URL uRL) throws IllegalActionException, NameDuplicationException {
        super(new Workspace(string));
        this.setName(string);
        this.authorativeResourceLocation = uRL;
        this.handle = new FlowHandle(0L, string, uRL);
    }

    public Flow(Workspace workspace, URL uRL) {
        super(workspace);
        this.authorativeResourceLocation = uRL;
        this.handle = new FlowHandle(0L, null, uRL);
    }

    public void setName(String string) throws IllegalActionException, NameDuplicationException {
        super.setName(string);
        if (this.handle != null) {
            this.handle.setName(string);
        }
    }

    public URL getAuthorativeResourceLocation() {
        return this.authorativeResourceLocation;
    }

    public FlowHandle getHandle() {
        return this.handle;
    }

    public void setHandle(FlowHandle flowHandle) {
        this.handle = flowHandle;
        this.setAuthorativeResourceLocation(flowHandle.getAuthorativeResourceLocation());
    }

    void setAuthorativeResourceLocation(URL uRL) {
        this.authorativeResourceLocation = uRL;
    }

    public Flow(Flow flow, String string) throws IllegalActionException, NameDuplicationException {
        super((CompositeEntity)flow, string);
    }

    public void connect(Actor actor, Actor actor2) {
        IOPort iOPort = (IOPort)((ComponentEntity)actor).getPort("output");
        IOPort iOPort2 = (IOPort)((ComponentEntity)actor2).getPort("input");
        try {
            super.connect((ComponentPort)iOPort, (ComponentPort)iOPort2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void connect(IOPort iOPort, IOPort iOPort2) {
        try {
            super.connect((ComponentPort)iOPort, (ComponentPort)iOPort2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void disconnect(Actor actor, Actor actor2) {
        List list = ((ComponentEntity)actor).portList();
        List list2 = ((ComponentEntity)actor2).portList();
        for (IOPort iOPort : list) {
            for (IOPort iOPort2 : list2) {
                try {
                    this.disconnect(iOPort, iOPort2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public void disconnect(IOPort iOPort, IOPort iOPort2) {
        List list = iOPort.linkedRelationList();
        for (Relation relation : list) {
            if (iOPort2.isLinked(relation)) {
                iOPort2.unlink(relation);
                iOPort.unlink(relation);
            }
            if (relation.linkedPorts().hasMoreElements()) continue;
            try {
                ((ComponentRelation)relation).setContainer(null);
            }
            catch (Exception exception) {}
        }
    }

    public Actor addActor(Class<? extends Actor> clazz, String string) throws NameDuplicationException, Exception {
        Object[] objectArray = new Object[]{this, string};
        Actor actor = null;
        Constructor<?>[] constructorArray = clazz.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> constructor = constructorArray[n2];
            Class<?>[] classArray = constructor.getParameterTypes();
            if (classArray.length == objectArray.length) {
                boolean bl = true;
                int n3 = 0;
                while (n3 < classArray.length) {
                    if (!classArray[n3].isInstance(objectArray[n3])) {
                        bl = false;
                        break;
                    }
                    ++n3;
                }
                if (bl) {
                    try {
                        actor = (Actor)constructor.newInstance(objectArray);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        if (invocationTargetException.getCause() instanceof NameDuplicationException) {
                            throw (NameDuplicationException)invocationTargetException.getCause();
                        }
                        throw invocationTargetException;
                    }
                    catch (Exception exception) {
                        throw exception;
                    }
                }
            }
            ++n2;
        }
        return actor;
    }

    public Collection<Parameter> getAllParameters() {
        return this.getAllParameters((CompositeActor)this);
    }

    private Collection<Parameter> getAllParameters(CompositeActor compositeActor) {
        HashSet<Parameter> hashSet = new HashSet<Parameter>();
        List list = compositeActor.entityList();
        Director director = compositeActor.getDirector();
        if (director != null) {
            hashSet.addAll(director.attributeList(Parameter.class));
        }
        hashSet.addAll(compositeActor.attributeList(Parameter.class));
        for (Entity entity : list) {
            hashSet.addAll(entity.attributeList(Parameter.class));
            if (!(entity instanceof CompositeActor)) continue;
            hashSet.addAll(this.getAllParameters((CompositeActor)entity));
        }
        return hashSet;
    }

    public String uniqueName(String string) {
        int n;
        if (string == null) {
            string = "null";
        }
        String string2 = string = Flow._stripNumericSuffix(string);
        try {
            n = this.getPrototypeList().size();
            if (n > 0) {
                string = String.valueOf(string) + "_" + n + "_";
            }
        }
        catch (IllegalActionException illegalActionException) {
            throw new InternalErrorException((Throwable)illegalActionException);
        }
        n = 2;
        while (this.getAttribute(string2) != null || this.getPort(string2) != null || this.getEntity(string2) != null || this.getRelation(string2) != null) {
            string2 = String.valueOf(string) + "_" + n++;
        }
        return string2;
    }

    protected static String _stripNumericSuffix(String string) {
        int n = string.length();
        char[] cArray = string.toCharArray();
        boolean bl = false;
        int n2 = n - 1;
        while (n2 >= 0) {
            char c = cArray[n2];
            if (Character.isDigit(c)) {
                --n;
            } else {
                if (c != '_' || n >= string.length()) break;
                bl = true;
                --n;
                break;
            }
            --n2;
        }
        if (bl) {
            char[] cArray2 = new char[n];
            System.arraycopy(cArray, 0, cArray2, 0, n);
            return new String(cArray2);
        }
        return string;
    }
}

