/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.message.xml;

import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageException;
import com.isencia.passerelle.message.xml.MessageBuilder;
import java.io.IOException;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlMessageHelper {
    private static Logger logger = LoggerFactory.getLogger(XmlMessageHelper.class);

    public static ManagedMessage getMessageFromXML(String string) throws MessageException {
        return MessageBuilder.buildFromXML(string);
    }

    public static ManagedMessage fillMessageContentFromXML(ManagedMessage managedMessage, String string) throws MessageException {
        return MessageBuilder.fillFromXML(managedMessage, string);
    }

    public static String getXMLFromMessage(ManagedMessage managedMessage) throws MessageException {
        return MessageBuilder.buildToXML(managedMessage);
    }

    public static String getXMLFromMessageContent(Multipart multipart) throws MessageException {
        if (multipart == null) {
            return null;
        }
        try {
            return MessageBuilder.buildToXML(multipart);
        }
        catch (IOException iOException) {
            throw new MessageException(PasserelleException.Severity.NON_FATAL, "", multipart, iOException);
        }
        catch (MessagingException messagingException) {
            throw new MessageException(PasserelleException.Severity.NON_FATAL, "", multipart, messagingException);
        }
    }
}

