/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.message.type;

import com.isencia.passerelle.message.MessageException;
import com.isencia.passerelle.message.type.ConverterBase;
import java.lang.reflect.Constructor;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.util.IllegalActionException;

public class IntegerConverter
extends ConverterBase {
    @Override
    protected boolean areTypesCompatible(Class clazz, Type type) {
        boolean bl = BaseType.INT.equals((Object)type);
        if (clazz != null) {
            bl = bl && (String.class.equals((Object)clazz) || Boolean.class.equals((Object)clazz) || Number.class.isAssignableFrom(clazz));
        }
        return bl;
    }

    @Override
    protected boolean areTypesCompatible(Type type, Class clazz) {
        return BaseType.INT.equals((Object)type);
    }

    @Override
    protected Token convertContentToToken(Object object, Type type) throws UnsupportedOperationException, MessageException {
        IntToken intToken;
        if (object == null) {
            intToken = new IntToken();
        } else if (Integer.class.isInstance(object)) {
            intToken = new IntToken(((Integer)object).intValue());
        } else {
            try {
                intToken = new IntToken(object.toString());
            }
            catch (IllegalActionException illegalActionException) {
                throw new UnsupportedOperationException();
            }
        }
        return intToken;
    }

    @Override
    protected Object convertTokenToContent(Token token, Class clazz) throws MessageException {
        if (clazz != null && !Integer.class.equals((Object)clazz)) {
            try {
                Constructor constructor = clazz.getConstructor(String.class);
                return constructor.newInstance(Integer.toString(((IntToken)token).intValue()));
            }
            catch (Exception exception) {
                throw new UnsupportedOperationException();
            }
        }
        try {
            return new Integer(((IntToken)token).intValue());
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    protected boolean areTypesCompatible(Class clazz, Class clazz2) {
        return clazz2 == null || Integer.class.isAssignableFrom(clazz2);
    }

    @Override
    protected Object convertContentToType(Object object, Class clazz) throws UnsupportedOperationException, MessageException {
        if (clazz != null && !Integer.class.equals((Object)clazz)) {
            try {
                Constructor constructor = clazz.getConstructor(String.class);
                return constructor.newInstance(object.toString());
            }
            catch (Exception exception) {
                throw new UnsupportedOperationException();
            }
        }
        try {
            return new Integer(Integer.parseInt(object.toString()));
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException();
        }
    }
}

