/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.message.type;

import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.core.PasserelleToken;
import com.isencia.passerelle.core.PasserelleType;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageException;
import com.isencia.passerelle.message.MessageFactory;
import com.isencia.passerelle.message.type.TypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.Token;
import ptolemy.data.type.Type;

public abstract class ConverterBase
implements TypeConverter {
    static Logger logger = LoggerFactory.getLogger(ConverterBase.class);

    @Override
    public Token convertPasserelleTokenToPtolemyToken(PasserelleToken passerelleToken, Type type) throws UnsupportedOperationException, PasserelleException {
        if (passerelleToken == null) {
            return null;
        }
        try {
            if (PasserelleType.PASSERELLE_MSG_TYPE.equals((Object)type)) {
                return passerelleToken;
            }
            if (this.areTypesCompatible(passerelleToken.getMessageContentType(), type)) {
                Token token = null;
                try {
                    ManagedMessage managedMessage = passerelleToken.getMessage();
                    token = this.convertContentToToken(managedMessage.getBodyContent(), type);
                }
                catch (MessageException messageException) {
                    throw new PasserelleException("", (Object)passerelleToken, messageException);
                }
                return token;
            }
            throw new UnsupportedOperationException();
        }
        catch (NullPointerException nullPointerException) {
            return passerelleToken;
        }
    }

    @Override
    public PasserelleToken convertPtolemyTokenToPasserelleToken(Token token, Class clazz) throws UnsupportedOperationException, PasserelleException {
        if (token == null) {
            return null;
        }
        if (PasserelleToken.class.isInstance(token)) {
            return this.convertPasserelleMessageContent((PasserelleToken)token, clazz);
        }
        if (this.areTypesCompatible(token.getType(), clazz)) {
            PasserelleToken passerelleToken = null;
            try {
                Object object = this.convertTokenToContent(token, clazz);
                ManagedMessage managedMessage = MessageFactory.getInstance().createMessage();
                if (String.class.isInstance(object)) {
                    managedMessage.setBodyContentPlainText((String)object);
                } else {
                    managedMessage.setBodyContent(object, "application/java");
                }
                passerelleToken = new PasserelleToken(managedMessage);
            }
            catch (MessageException messageException) {
                logger.error("", (Throwable)messageException);
            }
            return passerelleToken;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public PasserelleToken convertPasserelleMessageContent(PasserelleToken passerelleToken, Class clazz) throws UnsupportedOperationException, PasserelleException {
        if (passerelleToken == null || passerelleToken.getMessage() == null || passerelleToken.getMessage().getBodyContent() == null) {
            return passerelleToken;
        }
        if (this.areTypesCompatible(passerelleToken.getMessageContentType(), clazz)) {
            PasserelleToken passerelleToken2 = passerelleToken;
            try {
                Object object = passerelleToken.getMessage().getBodyContent();
                if (object != null && !object.getClass().equals(clazz)) {
                    object = this.convertContentToType(object, clazz);
                    ManagedMessage managedMessage = MessageFactory.getInstance().copyMessage(passerelleToken.getMessage());
                    if (String.class.isInstance(object)) {
                        managedMessage.setBodyContentPlainText((String)object);
                    } else {
                        managedMessage.setBodyContent(object, "application/java");
                    }
                    passerelleToken2 = new PasserelleToken(managedMessage);
                }
            }
            catch (MessageException messageException) {
                logger.error("", (Throwable)messageException);
            }
            return passerelleToken2;
        }
        throw new UnsupportedOperationException();
    }

    protected abstract boolean areTypesCompatible(Class var1, Type var2);

    protected abstract boolean areTypesCompatible(Type var1, Class var2);

    protected abstract boolean areTypesCompatible(Class var1, Class var2);

    protected abstract Token convertContentToToken(Object var1, Type var2) throws UnsupportedOperationException, MessageException;

    protected abstract Object convertTokenToContent(Token var1, Class var2) throws MessageException;

    protected abstract Object convertContentToType(Object var1, Class var2) throws UnsupportedOperationException, MessageException;
}

