/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.message.type;

import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.message.MessageException;
import com.isencia.passerelle.message.type.ConverterBase;
import java.lang.reflect.Constructor;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.apache.commons.math.complex.Complex;
import org.apache.commons.math.complex.ComplexFormat;
import ptolemy.data.ComplexToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;

public class ComplexConverter
extends ConverterBase {
    private ComplexFormat iFormat = new ComplexFormat(NumberFormat.getInstance(Locale.ENGLISH));
    private ComplexFormat jFormat = new ComplexFormat("j", NumberFormat.getInstance(Locale.ENGLISH));

    @Override
    protected boolean areTypesCompatible(Class clazz, Type type) {
        boolean bl = BaseType.COMPLEX.equals((Object)type);
        if (clazz != null) {
            bl = bl && (ptolemy.math.Complex.class.equals((Object)clazz) || Complex.class.equals((Object)clazz) || String.class.equals((Object)clazz) || Boolean.class.equals((Object)clazz) || Number.class.isAssignableFrom(clazz));
        }
        return bl;
    }

    @Override
    protected boolean areTypesCompatible(Type type, Class clazz) {
        return BaseType.COMPLEX.equals((Object)type);
    }

    @Override
    protected Token convertContentToToken(Object object, Type type) throws UnsupportedOperationException, MessageException {
        ComplexToken complexToken;
        if (object == null) {
            complexToken = new ComplexToken();
        } else if (ptolemy.math.Complex.class.isInstance(object)) {
            ptolemy.math.Complex complex = (ptolemy.math.Complex)object;
            double d = complex.real;
            double d2 = complex.imag;
            complexToken = new ComplexToken(new ptolemy.math.Complex(d, d2));
        } else {
            String string = object.toString();
            try {
                Complex complex = null;
                try {
                    complex = this.iFormat.parse(string);
                }
                catch (ParseException parseException) {
                    complex = this.jFormat.parse(string);
                }
                complexToken = new ComplexToken(new ptolemy.math.Complex(complex.getReal(), complex.getImaginary()));
            }
            catch (ParseException parseException) {
                throw new MessageException(PasserelleException.Severity.NON_FATAL, "", object, parseException);
            }
        }
        return complexToken;
    }

    @Override
    protected Object convertTokenToContent(Token token, Class clazz) throws MessageException {
        ptolemy.math.Complex complex = ((ComplexToken)token).complexValue();
        if (clazz != null && !ptolemy.math.Complex.class.equals((Object)clazz)) {
            if (String.class.equals((Object)clazz)) {
                return complex.toString();
            }
            try {
                Constructor constructor = clazz.getConstructor(String.class);
                return constructor.newInstance(Double.toString(complex.real));
            }
            catch (Exception exception) {
                throw new UnsupportedOperationException();
            }
        }
        try {
            double d = complex.real;
            double d2 = complex.imag;
            return new ptolemy.math.Complex(d, d2);
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    protected boolean areTypesCompatible(Class clazz, Class clazz2) {
        return clazz2 == null || ptolemy.math.Complex.class.isAssignableFrom(clazz2);
    }

    @Override
    protected Object convertContentToType(Object object, Class clazz) throws UnsupportedOperationException, MessageException {
        if (clazz != null && !ptolemy.math.Complex.class.equals((Object)clazz)) {
            try {
                Constructor constructor = clazz.getConstructor(String.class);
                return constructor.newInstance(object.toString());
            }
            catch (Exception exception) {
                throw new UnsupportedOperationException();
            }
        }
        String string = object.toString();
        try {
            Complex complex = null;
            try {
                complex = this.iFormat.parse(string);
            }
            catch (ParseException parseException) {
                complex = this.jFormat.parse(string);
            }
            return new ptolemy.math.Complex(complex.getReal(), complex.getImaginary());
        }
        catch (ParseException parseException) {
            throw new MessageException(PasserelleException.Severity.NON_FATAL, "", object, parseException);
        }
    }
}

