/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.message.type;

import com.isencia.passerelle.message.MessageException;
import com.isencia.passerelle.message.type.ConverterBase;
import com.isencia.util.StringConvertor;
import java.lang.reflect.Constructor;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;

public class BooleanConverter
extends ConverterBase {
    @Override
    protected boolean areTypesCompatible(Class clazz, Type type) {
        boolean bl = BaseType.BOOLEAN.equals((Object)type);
        if (clazz != null) {
            bl = bl && (String.class.equals((Object)clazz) || Boolean.class.equals((Object)clazz) || Number.class.isAssignableFrom(clazz));
        }
        return bl;
    }

    @Override
    protected boolean areTypesCompatible(Type type, Class clazz) {
        return BaseType.BOOLEAN.equals((Object)type);
    }

    @Override
    protected Token convertContentToToken(Object object, Type type) throws UnsupportedOperationException, MessageException {
        BooleanToken booleanToken = object == null ? new BooleanToken() : (Boolean.class.isInstance(object) ? new BooleanToken(((Boolean)object).booleanValue()) : new BooleanToken(StringConvertor.stringToBoolean((String)object.toString()).booleanValue()));
        return booleanToken;
    }

    @Override
    protected Object convertTokenToContent(Token token, Class clazz) throws MessageException {
        if (clazz != null && !Boolean.class.equals((Object)clazz)) {
            try {
                Constructor constructor = clazz.getConstructor(String.class);
                return constructor.newInstance(Boolean.toString(((BooleanToken)token).booleanValue()));
            }
            catch (Exception exception) {
                throw new UnsupportedOperationException();
            }
        }
        try {
            return new Boolean(((BooleanToken)token).booleanValue());
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    protected boolean areTypesCompatible(Class clazz, Class clazz2) {
        return clazz2 == null || Boolean.class.isAssignableFrom(clazz2);
    }

    @Override
    protected Object convertContentToType(Object object, Class clazz) throws UnsupportedOperationException, MessageException {
        if (clazz != null && !Boolean.class.equals((Object)clazz)) {
            try {
                Constructor constructor = clazz.getConstructor(String.class);
                return constructor.newInstance(object.toString());
            }
            catch (Exception exception) {
                throw new UnsupportedOperationException();
            }
        }
        try {
            return new Boolean(StringConvertor.stringToBoolean((String)object.toString()));
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException();
        }
    }
}

