/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.message.type;

import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.message.MessageException;
import com.isencia.passerelle.message.type.ConverterBase;
import com.isencia.passerelle.message.type.TypeConversionChain;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import ptolemy.data.ArrayToken;
import ptolemy.data.Token;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.Type;

public class ArrayConverter
extends ConverterBase {
    private static final String lineSeparator = System.getProperty("line.separator");

    @Override
    protected boolean areTypesCompatible(Class clazz, Type type) {
        boolean bl = type instanceof ArrayType;
        if (bl) {
            // empty if block
        }
        return bl;
    }

    @Override
    protected boolean areTypesCompatible(Type type, Class clazz) {
        return type instanceof ArrayType && (clazz == null || String.class.equals((Object)clazz) || clazz.isArray());
    }

    @Override
    protected Token convertContentToToken(Object object, Type type) throws UnsupportedOperationException, MessageException {
        Type type2;
        ArrayType arrayType = (ArrayType)type;
        Type type3 = type2 = arrayType != null ? arrayType.getElementType() : null;
        if (object == null) {
            try {
                return new ArrayToken(new Token[]{TypeConversionChain.getInstance().convertContentToToken(null, type2)});
            }
            catch (MessageException messageException) {
                throw messageException;
            }
            catch (Exception exception) {
                throw new MessageException(PasserelleException.Severity.NON_FATAL, "", object, exception);
            }
        }
        if (object.getClass().isArray()) {
            try {
                Object[] objectArray = (Object[])object;
                ArrayList<Token> arrayList = new ArrayList<Token>();
                int n = 0;
                while (n < objectArray.length) {
                    Object object2 = objectArray[n];
                    Token token = TypeConversionChain.getInstance().convertContentToToken(object2, type2);
                    arrayList.add(token);
                    ++n;
                }
                return new ArrayToken(arrayList.toArray(new Token[0]));
            }
            catch (MessageException messageException) {
                throw messageException;
            }
            catch (Exception exception) {
                throw new MessageException(PasserelleException.Severity.NON_FATAL, "", object, exception);
            }
        }
        if (Collection.class.isInstance(object)) {
            try {
                Collection collection = (Collection)object;
                ArrayList<Token> arrayList = new ArrayList<Token>();
                for (Object e : collection) {
                    Token token = TypeConversionChain.getInstance().convertContentToToken(e, type2);
                    arrayList.add(token);
                }
                return new ArrayToken(arrayList.toArray(new Token[0]));
            }
            catch (MessageException messageException) {
                throw messageException;
            }
            catch (Exception exception) {
                throw new MessageException(PasserelleException.Severity.NON_FATAL, "", object, exception);
            }
        }
        String string = object.toString();
        ArrayList<Token> arrayList = new ArrayList<Token>();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                Token token = TypeConversionChain.getInstance().convertContentToToken(string2, type2);
                arrayList.add(token);
            }
            return new ArrayToken(arrayList.toArray(new Token[0]));
        }
        catch (MessageException messageException) {
            throw messageException;
        }
        catch (Exception exception) {
            throw new MessageException(PasserelleException.Severity.NON_FATAL, "", object, exception);
        }
    }

    @Override
    protected Object convertTokenToContent(Token token, Class clazz) throws MessageException {
        if (token == null) {
            return null;
        }
        ArrayToken arrayToken = (ArrayToken)token;
        if (arrayToken.length() == 0) {
            return null;
        }
        if (clazz != null && !clazz.isArray()) {
            if (Collection.class.isAssignableFrom(clazz)) {
                try {
                    Collection collection = (Collection)clazz.newInstance();
                    int n = 0;
                    while (n < arrayToken.length()) {
                        Token token2 = arrayToken.getElement(n);
                        Object object = TypeConversionChain.getInstance().convertTokenToContent(token2, clazz.getComponentType());
                        collection.add(object);
                        ++n;
                    }
                    return collection;
                }
                catch (MessageException messageException) {
                    throw messageException;
                }
                catch (Exception exception) {
                    throw new MessageException(PasserelleException.Severity.NON_FATAL, "", token, exception);
                }
            }
            if (String.class.isAssignableFrom(clazz)) {
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (n < arrayToken.length()) {
                    Token token3 = arrayToken.getElement(n);
                    stringBuffer.append(token3.toString());
                    stringBuffer.append(lineSeparator);
                    ++n;
                }
                return stringBuffer.toString();
            }
            Token token4 = arrayToken.getElement(0);
            return TypeConversionChain.getInstance().convertTokenToContent(token4, clazz);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < arrayToken.length()) {
            Token token5 = arrayToken.getElement(n);
            Object object = TypeConversionChain.getInstance().convertTokenToContent(token5, clazz.getComponentType());
            arrayList.add(object);
            ++n;
        }
        return arrayList.toArray();
    }

    @Override
    protected boolean areTypesCompatible(Class clazz, Class clazz2) {
        return clazz2 == null || clazz2.isArray();
    }

    @Override
    protected Object convertContentToType(Object object, Class clazz) throws UnsupportedOperationException, MessageException {
        throw new UnsupportedOperationException();
    }
}

