/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.message.internal.sequence;

import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.internal.sequence.MessageTrace;
import com.isencia.passerelle.message.internal.sequence.Traceable;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class SequenceTrace
implements Traceable {
    private Long sequenceID;
    private Boolean handled = null;
    private Boolean complete = null;
    private Map messageTraces = new HashMap();
    private Map messagesBySeqPos = new TreeMap();

    public SequenceTrace(Long l) {
        if (l == null) {
            throw new IllegalArgumentException();
        }
        this.sequenceID = l;
    }

    @Override
    public synchronized boolean isHandled() {
        if (Boolean.TRUE.equals(this.handled)) {
            return true;
        }
        boolean bl = true;
        long l = 0L;
        ManagedMessage managedMessage2 = null;
        MessageTrace messageTrace = null;
        for (ManagedMessage managedMessage2 : this.messagesBySeqPos.values()) {
            messageTrace = (MessageTrace)this.messageTraces.get(managedMessage2.getID());
            if (messageTrace == null || !messageTrace.isHandled() || managedMessage2.getSequencePosition() == null || managedMessage2.getSequencePosition() != l) {
                bl = false;
                break;
            }
            ++l;
        }
        if (bl && managedMessage2 != null && messageTrace != null) {
            boolean bl2 = bl = managedMessage2.isSequenceEnd() && messageTrace.isHandled();
            if (bl) {
                this.complete = Boolean.TRUE;
                this.handled = Boolean.TRUE;
            }
        }
        return bl;
    }

    public synchronized boolean isComplete() {
        if (Boolean.TRUE.equals(this.complete)) {
            return true;
        }
        boolean bl = true;
        long l = 0L;
        ManagedMessage managedMessage2 = null;
        for (ManagedMessage managedMessage2 : this.messagesBySeqPos.values()) {
            if (managedMessage2.getSequencePosition() == null || managedMessage2.getSequencePosition() != l) {
                bl = false;
                break;
            }
            ++l;
        }
        if (bl && managedMessage2 != null && (bl = managedMessage2.isSequenceEnd())) {
            this.complete = Boolean.TRUE;
        }
        return bl;
    }

    public synchronized Long getSequenceID() {
        return this.sequenceID;
    }

    public synchronized void addMessage(ManagedMessage managedMessage) {
        if (managedMessage == null) {
            throw new IllegalArgumentException("Null msg not allowed");
        }
        if (!this.sequenceID.equals(managedMessage.getSequenceID())) {
            throw new IllegalArgumentException("Message " + managedMessage.getID() + " with seqID " + managedMessage.getSequenceID() + "does not belong in sequence " + this.sequenceID);
        }
        if (this.complete != null && this.complete.booleanValue()) {
            throw new IllegalStateException("sequence " + this.sequenceID + " already complete");
        }
        this.handled = Boolean.FALSE;
        this.messageTraces.put(managedMessage.getID(), new MessageTrace(managedMessage));
        this.messagesBySeqPos.put(managedMessage.getSequencePosition(), managedMessage);
    }

    public synchronized void messageHandled(ManagedMessage managedMessage) {
        if (managedMessage == null) {
            throw new IllegalArgumentException("Null msg not allowed");
        }
        if (!this.sequenceID.equals(managedMessage.getSequenceID())) {
            throw new IllegalArgumentException("Message " + managedMessage.getID() + " with seqID " + managedMessage.getSequenceID() + "does not belong in sequence " + this.sequenceID);
        }
        if (this.handled != null && this.handled.booleanValue()) {
            throw new IllegalStateException("sequence " + this.sequenceID + " already handled completely");
        }
        MessageTrace messageTrace = (MessageTrace)this.messageTraces.get(managedMessage.getID());
        if (messageTrace != null) {
            messageTrace.setHandled();
        } else {
            messageTrace = new MessageTrace(managedMessage);
            messageTrace.setHandled();
            this.messageTraces.put(managedMessage.getID(), messageTrace);
        }
    }

    public synchronized ManagedMessage[] getMessagesInSequence() {
        return this.messagesBySeqPos.values().toArray(new ManagedMessage[0]);
    }

    public synchronized void clear() {
        this.messagesBySeqPos.clear();
        this.messageTraces.clear();
        this.handled = null;
        this.complete = null;
    }
}

