/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.message.interceptor;

import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageException;
import com.isencia.passerelle.message.interceptor.IMessageCreator;
import com.isencia.passerelle.message.interceptor.ManagedMessageConverter;
import com.isencia.passerelle.message.internal.SettableMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLToMessageConverter
extends ManagedMessageConverter {
    private static final Logger logger = LoggerFactory.getLogger(XMLToMessageConverter.class);

    public XMLToMessageConverter(IMessageCreator iMessageCreator) {
        super(iMessageCreator);
    }

    public Object accept(Object object) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("Accepting ~" + object + "~");
        }
        ManagedMessage managedMessage = null;
        if (object != null) {
            managedMessage = this.createMessage();
            try {
                SettableMessage settableMessage = (SettableMessage)managedMessage;
                settableMessage.setBodyContent((String)object, "text/xml");
                settableMessage.saveChanges();
            }
            catch (ClassCastException classCastException) {
                throw new MessageException(PasserelleException.Severity.NON_FATAL, "", managedMessage, classCastException);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("exit :" + managedMessage);
        }
        return managedMessage;
    }

    @Override
    public ManagedMessageConverter cloneConverter(IMessageCreator iMessageCreator) {
        return new XMLToMessageConverter(iMessageCreator);
    }
}

