/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.message.interceptor;

import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageException;
import com.isencia.passerelle.message.interceptor.IMessageCreator;
import com.isencia.passerelle.message.interceptor.ManagedMessageConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextToMessageConverter
extends ManagedMessageConverter {
    private static final Logger logger = LoggerFactory.getLogger(TextToMessageConverter.class);

    public TextToMessageConverter(IMessageCreator iMessageCreator) {
        super(iMessageCreator);
    }

    public Object accept(Object object) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("Accepting ~" + object + "~");
        }
        ManagedMessage managedMessage = null;
        if (object != null) {
            managedMessage = this.createMessage();
            try {
                managedMessage.setBodyContentPlainText((String)object);
            }
            catch (MessageException messageException) {
                logger.error(messageException.getMessage());
                managedMessage = null;
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("exit :" + managedMessage);
        }
        return managedMessage;
    }

    @Override
    public ManagedMessageConverter cloneConverter(IMessageCreator iMessageCreator) {
        return new TextToMessageConverter(iMessageCreator);
    }
}

