/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.message;

import com.isencia.passerelle.core.PasserelleException;
import com.isencia.util.StringConvertor;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.apache.commons.math.complex.Complex;
import org.apache.commons.math.complex.ComplexFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.BooleanToken;
import ptolemy.data.ComplexToken;
import ptolemy.data.ObjectToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.kernel.util.IllegalActionException;

public class TokenHelper {
    private static Logger logger = LoggerFactory.getLogger(TokenHelper.class);
    private static final ComplexFormat iFormat = new ComplexFormat(NumberFormat.getInstance(Locale.ENGLISH));
    private static final ComplexFormat jFormat = new ComplexFormat("j", NumberFormat.getInstance(Locale.ENGLISH));

    public static String getStringFromToken(Token token) throws PasserelleException {
        if (logger.isTraceEnabled()) {
            logger.trace(token.toString());
        }
        String string = null;
        if (token != null) {
            try {
                if (token instanceof ObjectToken) {
                    Object object = ((ObjectToken)token).getValue();
                    if (object instanceof String) {
                        string = (String)object;
                    } else if (object != null) {
                        string = object.toString();
                    }
                } else {
                    string = token instanceof StringToken ? ((StringToken)token).stringValue() : token.toString();
                }
            }
            catch (Exception exception) {
                throw new PasserelleException("Error building String from token", token, exception);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("exit :" + string);
        }
        return string;
    }

    public static Integer getIntegerFromToken(Token token) throws PasserelleException {
        Integer n;
        block17: {
            if (logger.isTraceEnabled()) {
                logger.trace(token.toString());
            }
            n = null;
            if (token != null) {
                try {
                    if (token instanceof ObjectToken) {
                        Object object = ((ObjectToken)token).getValue();
                        if (object instanceof Integer) {
                            n = (Integer)object;
                            break block17;
                        }
                        if (object == null) break block17;
                        try {
                            n = Integer.valueOf(object.toString());
                            break block17;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new PasserelleException("Invalid Integer format", token, numberFormatException);
                        }
                    }
                    if (token instanceof StringToken) {
                        String string = ((StringToken)token).stringValue();
                        if (string == null) break block17;
                        try {
                            n = Integer.valueOf(string);
                            break block17;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new PasserelleException("Invalid Integer format", token, numberFormatException);
                        }
                    }
                    if (token instanceof ScalarToken) {
                        try {
                            n = new Integer(((ScalarToken)token).intValue());
                            break block17;
                        }
                        catch (IllegalActionException illegalActionException) {
                            try {
                                n = new Integer((int)Math.round(((ScalarToken)token).doubleValue()));
                                break block17;
                            }
                            catch (IllegalActionException illegalActionException2) {
                                throw new PasserelleException("Invalid token for obtaining Integer value", token, illegalActionException2);
                            }
                        }
                    }
                    throw new PasserelleException("Invalid token for obtaining Integer value", token, null);
                }
                catch (Exception exception) {
                    throw new PasserelleException("Error building Integer from token", token, exception);
                }
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("exit :" + n);
        }
        return n;
    }

    public static Short getShortFromToken(Token token) throws PasserelleException {
        Short s;
        block17: {
            if (logger.isTraceEnabled()) {
                logger.trace(token.toString());
            }
            s = null;
            if (token != null) {
                try {
                    if (token instanceof ObjectToken) {
                        Object object = ((ObjectToken)token).getValue();
                        if (object instanceof Short) {
                            s = (Short)object;
                            break block17;
                        }
                        if (object == null) break block17;
                        try {
                            s = Short.valueOf(object.toString());
                            break block17;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new PasserelleException("Invalid Short format", token, numberFormatException);
                        }
                    }
                    if (token instanceof StringToken) {
                        String string = ((StringToken)token).stringValue();
                        if (string == null) break block17;
                        try {
                            s = Short.valueOf(string);
                            break block17;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new PasserelleException("Invalid Short format", token, numberFormatException);
                        }
                    }
                    if (token instanceof ScalarToken) {
                        try {
                            s = new Short((short)((ScalarToken)token).intValue());
                            break block17;
                        }
                        catch (IllegalActionException illegalActionException) {
                            try {
                                s = new Short((short)Math.round(((ScalarToken)token).doubleValue()));
                                break block17;
                            }
                            catch (IllegalActionException illegalActionException2) {
                                throw new PasserelleException("Invalid token for obtaining Short value", token, illegalActionException2);
                            }
                        }
                    }
                    throw new PasserelleException("Invalid token for obtaining Short value", token, null);
                }
                catch (Exception exception) {
                    throw new PasserelleException("Error building Short from token", token, exception);
                }
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("exit :" + s);
        }
        return s;
    }

    public static Complex getComplexFromToken(Token token) throws PasserelleException {
        Complex complex;
        block20: {
            if (logger.isTraceEnabled()) {
                logger.trace(token.toString());
            }
            complex = null;
            if (token != null) {
                try {
                    if (token instanceof ObjectToken) {
                        Object object = ((ObjectToken)token).getValue();
                        if (object instanceof Complex) {
                            complex = (Complex)object;
                        }
                        if (object instanceof ptolemy.math.Complex) {
                            ptolemy.math.Complex complex2 = (ptolemy.math.Complex)object;
                            complex = new Complex(complex2.real, complex2.imag);
                            break block20;
                        }
                        if (object == null) break block20;
                        String string = object.toString();
                        try {
                            complex = iFormat.parse(string);
                            break block20;
                        }
                        catch (ParseException parseException) {
                            try {
                                complex = jFormat.parse(string);
                                break block20;
                            }
                            catch (ParseException parseException2) {
                                throw new PasserelleException("Invalid Complex format", token, parseException2);
                            }
                        }
                    }
                    if (token instanceof StringToken) {
                        String string = ((StringToken)token).stringValue();
                        if (string != null) {
                            try {
                                complex = iFormat.parse(string);
                            }
                            catch (ParseException parseException) {
                                complex = jFormat.parse(string);
                            }
                        }
                        break block20;
                    }
                    if (token instanceof ComplexToken) {
                        ptolemy.math.Complex complex3 = ((ComplexToken)token).complexValue();
                        complex = new Complex(complex3.real, complex3.imag);
                        break block20;
                    }
                    if (token instanceof ScalarToken) {
                        try {
                            complex = new Complex(((ScalarToken)token).doubleValue(), 0.0);
                            break block20;
                        }
                        catch (IllegalActionException illegalActionException) {
                            throw new PasserelleException("Invalid token for obtaining Complex value", token, illegalActionException);
                        }
                    }
                    throw new PasserelleException("Invalid token for obtaining Complex value", token, null);
                }
                catch (Exception exception) {
                    throw new PasserelleException("Error building Complex from token", token, exception);
                }
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("exit :" + complex);
        }
        return complex;
    }

    public static Double getDoubleFromToken(Token token) throws PasserelleException {
        Double d;
        block15: {
            if (logger.isTraceEnabled()) {
                logger.trace(token.toString());
            }
            d = null;
            if (token != null) {
                try {
                    if (token instanceof ObjectToken) {
                        Object object = ((ObjectToken)token).getValue();
                        if (object instanceof Double) {
                            d = (Double)object;
                            break block15;
                        }
                        if (object == null) break block15;
                        try {
                            d = Double.valueOf(object.toString());
                            break block15;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new PasserelleException("Invalid Double format", token, numberFormatException);
                        }
                    }
                    if (token instanceof StringToken) {
                        String string = ((StringToken)token).stringValue();
                        if (string == null) break block15;
                        try {
                            d = Double.valueOf(string);
                            break block15;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new PasserelleException("Invalid Double format", token, numberFormatException);
                        }
                    }
                    if (token instanceof ScalarToken) {
                        try {
                            d = new Double(((ScalarToken)token).doubleValue());
                            break block15;
                        }
                        catch (IllegalActionException illegalActionException) {
                            throw new PasserelleException("Invalid token for obtaining Double value", token, illegalActionException);
                        }
                    }
                    throw new PasserelleException("Invalid token for obtaining Double value", token, null);
                }
                catch (Exception exception) {
                    throw new PasserelleException("Error building Double from token", token, exception);
                }
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("exit :" + d);
        }
        return d;
    }

    public static Float getFloatFromToken(Token token) throws PasserelleException {
        Float f;
        block15: {
            if (logger.isTraceEnabled()) {
                logger.trace(token.toString());
            }
            f = null;
            if (token != null) {
                try {
                    if (token instanceof ObjectToken) {
                        Object object = ((ObjectToken)token).getValue();
                        if (object instanceof Float) {
                            f = (Float)object;
                            break block15;
                        }
                        if (object == null) break block15;
                        try {
                            f = Float.valueOf(object.toString());
                            break block15;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new PasserelleException("Invalid Float format", token, numberFormatException);
                        }
                    }
                    if (token instanceof StringToken) {
                        String string = ((StringToken)token).stringValue();
                        if (string == null) break block15;
                        try {
                            f = Float.valueOf(string);
                            break block15;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new PasserelleException("Invalid Float format", token, numberFormatException);
                        }
                    }
                    if (token instanceof ScalarToken) {
                        try {
                            f = new Float(((ScalarToken)token).doubleValue());
                            break block15;
                        }
                        catch (IllegalActionException illegalActionException) {
                            throw new PasserelleException("Invalid token for obtaining Float value", token, illegalActionException);
                        }
                    }
                    throw new PasserelleException("Invalid token for obtaining Float value", token, null);
                }
                catch (Exception exception) {
                    throw new PasserelleException("Error building Float from token", token, exception);
                }
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("exit :" + f);
        }
        return f;
    }

    public static Boolean getBooleanFromToken(Token token) throws PasserelleException {
        Boolean bl;
        block13: {
            if (logger.isTraceEnabled()) {
                logger.trace(token.toString());
            }
            bl = null;
            if (token != null) {
                try {
                    if (token instanceof ObjectToken) {
                        Object object = ((ObjectToken)token).getValue();
                        if (object instanceof Boolean) {
                            bl = (Boolean)object;
                            break block13;
                        }
                        if (object == null) break block13;
                        try {
                            bl = StringConvertor.stringToBoolean((String)object.toString());
                            break block13;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new PasserelleException("Invalid Boolean format", token, numberFormatException);
                        }
                    }
                    if (token instanceof StringToken) {
                        String string = ((StringToken)token).stringValue();
                        if (string == null) break block13;
                        try {
                            bl = StringConvertor.stringToBoolean((String)string);
                            break block13;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new PasserelleException("Invalid Boolean format", token, numberFormatException);
                        }
                    }
                    if (token instanceof BooleanToken) {
                        bl = new Boolean(((BooleanToken)token).booleanValue());
                        break block13;
                    }
                    throw new PasserelleException("Invalid token for obtaining Boolean value", token, null);
                }
                catch (Exception exception) {
                    throw new PasserelleException("Error building Boolean from token", token, exception);
                }
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("exit :" + bl);
        }
        return bl;
    }

    public static Byte getByteFromToken(Token token) throws PasserelleException {
        Byte by;
        block13: {
            if (logger.isTraceEnabled()) {
                logger.trace(token.toString());
            }
            by = null;
            if (token != null) {
                try {
                    if (token instanceof ObjectToken) {
                        Object object = ((ObjectToken)token).getValue();
                        if (object instanceof Byte) {
                            by = (Byte)object;
                            break block13;
                        }
                        if (object == null) break block13;
                        try {
                            by = Byte.valueOf(object.toString());
                            break block13;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new PasserelleException("Invalid Byte format", token, numberFormatException);
                        }
                    }
                    if (token instanceof StringToken) {
                        String string = ((StringToken)token).stringValue();
                        if (string == null) break block13;
                        try {
                            by = Byte.valueOf(string);
                            break block13;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new PasserelleException("Invalid Byte format", token, numberFormatException);
                        }
                    }
                    if (token instanceof ScalarToken) {
                        by = new Byte(((ScalarToken)token).byteValue());
                        break block13;
                    }
                    throw new PasserelleException("Invalid token for obtaining Byte value", token, null);
                }
                catch (Exception exception) {
                    throw new PasserelleException("Error building Byte from token", token, exception);
                }
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("exit :" + by);
        }
        return by;
    }
}

