/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.message;

import com.isencia.passerelle.message.ManagedMessage;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class MessageInputContext {
    private int portIndex;
    private String portName;
    private Queue<ManagedMessage> msgQ = new ConcurrentLinkedQueue<ManagedMessage>();
    private boolean processed;

    public MessageInputContext(int n, String string, ManagedMessage managedMessage) {
        this.portIndex = n;
        this.portName = string;
        if (managedMessage != null) {
            this.msgQ.offer(managedMessage);
        }
        this.processed = managedMessage == null;
    }

    public ManagedMessage getMsg() {
        return this.msgQ.peek();
    }

    public Iterator<ManagedMessage> getMsgIterator() {
        return this.msgQ.iterator();
    }

    public int getPortIndex() {
        return this.portIndex;
    }

    public String getPortName() {
        return this.portName;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean bl) {
        this.processed = bl;
    }

    public void addMsg(ManagedMessage managedMessage) {
        this.msgQ.offer(managedMessage);
    }
}

