/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.message;

import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.core.PasserelleToken;
import com.isencia.passerelle.core.PortHandler;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageException;
import com.isencia.passerelle.message.MessageFactory;
import com.isencia.passerelle.message.TokenHelper;
import com.isencia.passerelle.message.internal.MessageContainer;
import com.isencia.passerelle.message.internal.PasserelleBodyPart;
import com.isencia.passerelle.message.internal.SettableMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.IOPort;
import ptolemy.actor.NoTokenException;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.kernel.util.IllegalActionException;

public class MessageHelper {
    private static Logger logger = LoggerFactory.getLogger(MessageHelper.class);

    public static boolean isContent(Part part) {
        try {
            return MessageHelper.getContentDisposition(part).getDisposition().equalsIgnoreCase("inline");
        }
        catch (MessagingException messagingException) {
            return false;
        }
    }

    static ContentDisposition getContentDisposition(Part part) throws MessagingException {
        String string = part.getDisposition();
        try {
            if (string != null) {
                return new ContentDisposition(string);
            }
        }
        catch (ParseException parseException) {
            throw new MessagingException(parseException.toString());
        }
        if (part instanceof MimeBodyPart) {
            Multipart multipart = ((MimeBodyPart)part).getParent();
            if (multipart != null) {
                Part part2 = multipart.getParent();
                logger.debug("trying get Disposition on Parent");
                if (part2 != null) {
                    String string2 = part2.getDisposition();
                    logger.debug("Disposition on Parent : " + string2);
                    if (string2 != null) {
                        return new ContentDisposition(string2);
                    }
                }
            }
            return new ContentDisposition("attachment");
        }
        return new ContentDisposition("inline");
    }

    static ContentType getContentType(Part part) {
        String string = null;
        try {
            string = part.getContentType();
        }
        catch (MessagingException messagingException) {}
        if (string == null) {
            string = "text/plain";
        }
        ContentType contentType = null;
        try {
            contentType = new ContentType(string.toLowerCase());
        }
        catch (ParseException parseException) {}
        if (contentType == null) {
            contentType = new ContentType("text", "plain", null);
        }
        return contentType;
    }

    public static Object[] getFilteredContent(ManagedMessage managedMessage, String[] stringArray) {
        if (logger.isTraceEnabled()) {
            logger.trace("Message :" + managedMessage + "\nTypes :" + Arrays.asList(stringArray));
        }
        Object[] objectArray = null;
        if (managedMessage instanceof SettableMessage) {
            PasserelleBodyPart passerelleBodyPart = ((SettableMessage)managedMessage).getBody();
            objectArray = MessageHelper._getFilteredContent((Part)passerelleBodyPart, stringArray);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("exit :" + Arrays.asList(objectArray));
        }
        return objectArray;
    }

    private static Object[] _getFilteredContent(Part part, String[] stringArray) {
        Object[] objectArray = null;
        if (part != null) {
            try {
                Object object = part.getContent();
                if (object instanceof String) {
                    objectArray = MessageHelper.filterContent(part, stringArray) ? new String[]{(String)object} : new String[]{};
                } else if (object instanceof Multipart) {
                    ArrayList<List<Object>> arrayList = new ArrayList<List<Object>>();
                    Multipart multipart = (Multipart)object;
                    int n = multipart.getCount();
                    int n2 = 0;
                    while (n2 < n) {
                        BodyPart bodyPart = multipart.getBodyPart(n2);
                        Object[] objectArray2 = MessageHelper._getFilteredContent((Part)bodyPart, stringArray);
                        if (objectArray2 != null && objectArray2.length > 0) {
                            arrayList.add(Arrays.asList(objectArray2));
                        }
                        ++n2;
                    }
                    objectArray = arrayList.toArray();
                }
            }
            catch (IOException iOException) {
                logger.error("", (Throwable)iOException);
            }
            catch (MessagingException messagingException) {
                logger.error("", (Throwable)messagingException);
            }
        }
        return objectArray;
    }

    public static ManagedMessage getMessage(PortHandler portHandler) throws PasserelleException {
        if (logger.isTraceEnabled()) {
            logger.trace(portHandler.toString());
        }
        ManagedMessage managedMessage = null;
        Token token = portHandler.getToken();
        if (token != null) {
            managedMessage = MessageHelper.getMessageFromToken(token);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("exit :" + managedMessage);
        }
        return managedMessage;
    }

    public static ManagedMessage getMessage(IOPort iOPort) throws PasserelleException {
        ManagedMessage managedMessage;
        block7: {
            if (logger.isTraceEnabled()) {
                logger.trace(iOPort.getDisplayName());
            }
            managedMessage = null;
            try {
                if (!iOPort.hasToken(0)) break block7;
                try {
                    Token token = iOPort.get(0);
                    if (token != null) {
                        managedMessage = MessageHelper.getMessageFromToken(token);
                    }
                }
                catch (NoTokenException noTokenException) {}
            }
            catch (IllegalActionException illegalActionException) {
                throw new PasserelleException("Unexpected error while reading token from port", iOPort, illegalActionException);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("exit :" + managedMessage);
        }
        return managedMessage;
    }

    public static String getMessageAsString(IOPort iOPort) throws PasserelleException {
        String string;
        block7: {
            if (logger.isTraceEnabled()) {
                logger.trace(iOPort.getDisplayName());
            }
            string = null;
            try {
                if (!iOPort.hasToken(0)) break block7;
                try {
                    Token token = iOPort.get(0);
                    if (token != null) {
                        string = TokenHelper.getStringFromToken(token);
                    }
                }
                catch (NoTokenException noTokenException) {}
            }
            catch (IllegalActionException illegalActionException) {
                throw new PasserelleException("Unexpected error while reading token from port", iOPort, illegalActionException);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("exit :" + string);
        }
        return string;
    }

    public static Token getMessageAsToken(IOPort iOPort) throws PasserelleException {
        if (logger.isTraceEnabled()) {
            logger.trace(iOPort.getDisplayName());
        }
        Token token = null;
        try {
            if (iOPort.hasToken(0)) {
                try {
                    token = iOPort.get(0);
                }
                catch (NoTokenException noTokenException) {}
            }
        }
        catch (IllegalActionException illegalActionException) {
            throw new PasserelleException("Unexpected error while reading token from port", iOPort, illegalActionException);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("exit :" + token);
        }
        return token;
    }

    public static ManagedMessage getMessageFromToken(Token token) throws PasserelleException {
        ManagedMessage managedMessage;
        block14: {
            String string;
            block15: {
                if (logger.isTraceEnabled()) {
                    logger.trace(token.toString());
                }
                managedMessage = null;
                if (token == null) {
                    return null;
                }
                try {
                    if (token instanceof PasserelleToken) {
                        ManagedMessage managedMessage2 = ((PasserelleToken)token).getMessage();
                        managedMessage = MessageFactory.getInstance().copyMessage(managedMessage2);
                        break block14;
                    }
                    string = null;
                    if (token instanceof StringToken) {
                        string = ((StringToken)token).stringValue();
                    } else if (token instanceof ScalarToken) {
                        string = token.toString();
                    } else if (token instanceof BooleanToken) {
                        string = token.toString();
                    } else if (token instanceof ArrayToken) {
                        string = token.toString();
                    }
                    if (string != null && string.length() != 0) break block15;
                    return null;
                }
                catch (Exception exception) {
                    throw new PasserelleException("Error building MessageContainer from token", token, exception);
                }
            }
            managedMessage = new MessageContainer();
            managedMessage.setBodyContentPlainText(string);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("exit :" + managedMessage);
        }
        return managedMessage;
    }

    static boolean isMultipart(Part part) {
        try {
            return MessageHelper.getContentDisposition(part).getDisposition().equalsIgnoreCase("inline");
        }
        catch (MessagingException messagingException) {
            return false;
        }
    }

    public static void copyHeaders(Part part, Part part2) throws MessagingException {
        Enumeration enumeration = part.getAllHeaders();
        while (enumeration.hasMoreElements()) {
            Header header = (Header)enumeration.nextElement();
            part2.addHeader(header.getName(), header.getValue());
        }
    }

    public static boolean filterContent(Part part, String[] stringArray) {
        if (logger.isTraceEnabled()) {
            logger.trace("Part :" + part + "\nTypes :" + Arrays.asList(stringArray));
        }
        ContentType contentType = MessageHelper.getContentType(part);
        boolean bl = false;
        if (stringArray == null || stringArray.length == 0) {
            bl = true;
        } else if (!MessageHelper.isContent(part)) {
            logger.debug("Not a content");
        } else {
            logger.debug("Is content");
            if (contentType != null) {
                String string = contentType.getBaseType();
                logger.debug("Content type :" + string);
                int n = 0;
                while (n < stringArray.length && !bl) {
                    bl = string.equalsIgnoreCase(stringArray[n]);
                    ++n;
                }
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("exit :" + (bl ? "true" : "false"));
        }
        return bl;
    }

    public static String getPrimaryContentType(ManagedMessage managedMessage) throws MessageException {
        try {
            ContentType contentType = new ContentType(managedMessage.getBodyContentType());
            return contentType.getPrimaryType();
        }
        catch (ParseException parseException) {
            throw new MessageException(PasserelleException.Severity.NON_FATAL, "", managedMessage, parseException);
        }
    }

    public static String getSubContentType(ManagedMessage managedMessage) throws MessageException {
        try {
            ContentType contentType = new ContentType(managedMessage.getBodyContentType());
            return contentType.getSubType();
        }
        catch (ParseException parseException) {
            throw new MessageException(PasserelleException.Severity.NON_FATAL, "", managedMessage, parseException);
        }
    }

    public static boolean hasTextContent(ManagedMessage managedMessage) {
        try {
            return MessageHelper.getPrimaryContentType(managedMessage).equalsIgnoreCase("text");
        }
        catch (Exception exception) {
            logger.error("", (Throwable)exception);
            return false;
        }
    }
}

