/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.message;

import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageException;
import com.isencia.passerelle.message.internal.ErrorMessageContainer;
import com.isencia.passerelle.message.internal.MessageContainer;
import com.isencia.passerelle.message.internal.TriggerMessageContainer;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;

public class MessageFactory {
    private static final MessageFactory instance = new MessageFactory();
    private static long msgIdCounter = 0L;
    private static long seqIDCounter = 0L;
    public static final DateFormat timestampFormat = DateFormat.getDateTimeInstance();

    public static MessageFactory getInstance() {
        return instance;
    }

    public synchronized ManagedMessage createMessage() {
        MessageContainer messageContainer = new MessageContainer();
        this.setStdHeaders(messageContainer);
        return messageContainer;
    }

    public synchronized ManagedMessage createMessage(Map map) {
        MessageContainer messageContainer = (MessageContainer)this.createMessage();
        this.setHeaders(messageContainer, map);
        return messageContainer;
    }

    private void setHeaders(MessageContainer messageContainer, Map map) {
        if (map != null && map.size() > 0) {
            for (Map.Entry entry : map.entrySet()) {
                try {
                    String string = (String)entry.getKey();
                    String string2 = (String)entry.getValue();
                    if ("__PSRL_ID".equals(string) || "__PSRL_VERSION".equals(string) || "__PSRL_TIMESTAMP_CREATION".equals(string)) continue;
                    messageContainer.setHeader(string, string2);
                }
                catch (ClassCastException classCastException) {}
            }
        }
    }

    public synchronized Long createSequenceID() {
        return new Long(seqIDCounter++);
    }

    public synchronized ManagedMessage createCorrelatedMessage(String string) {
        MessageContainer messageContainer = (MessageContainer)this.createMessage();
        messageContainer.setHeader("__PSRL_CORRELATION_ID", string);
        return messageContainer;
    }

    public synchronized ManagedMessage createCorrelatedMessage(String string, Map map) {
        MessageContainer messageContainer = (MessageContainer)this.createMessage(map);
        messageContainer.setHeader("__PSRL_CORRELATION_ID", string);
        return messageContainer;
    }

    public synchronized ManagedMessage createMessageInSequence(Long l, Long l2, boolean bl) {
        MessageContainer messageContainer = (MessageContainer)this.createMessage();
        messageContainer.setSequenceID(l);
        messageContainer.setSequencePosition(l2);
        messageContainer.setSequenceEnd(bl);
        return messageContainer;
    }

    public synchronized ManagedMessage createMessageInSequence(Long l, Long l2, boolean bl, Map map) {
        MessageContainer messageContainer = (MessageContainer)this.createMessage(map);
        messageContainer.setSequenceID(l);
        messageContainer.setSequencePosition(l2);
        messageContainer.setSequenceEnd(bl);
        return messageContainer;
    }

    public synchronized ManagedMessage createErrorMessage(PasserelleException passerelleException) {
        ErrorMessageContainer errorMessageContainer = new ErrorMessageContainer(passerelleException);
        this.setStdHeaders(errorMessageContainer);
        return errorMessageContainer;
    }

    public synchronized ManagedMessage createErrorMessage(PasserelleException passerelleException, Map map) {
        ErrorMessageContainer errorMessageContainer = (ErrorMessageContainer)this.createErrorMessage(passerelleException);
        this.setHeaders(errorMessageContainer, map);
        return errorMessageContainer;
    }

    public synchronized ManagedMessage createTriggerMessage() {
        TriggerMessageContainer triggerMessageContainer = new TriggerMessageContainer();
        this.setStdHeaders(triggerMessageContainer);
        return triggerMessageContainer;
    }

    public synchronized ManagedMessage createTriggerMessage(Map map) {
        TriggerMessageContainer triggerMessageContainer = (TriggerMessageContainer)this.createTriggerMessage();
        this.setHeaders(triggerMessageContainer, map);
        return triggerMessageContainer;
    }

    public synchronized ManagedMessage copyMessage(ManagedMessage managedMessage) throws MessageException {
        if (managedMessage != null && managedMessage instanceof MessageContainer) {
            MessageContainer messageContainer = ((MessageContainer)managedMessage).copy();
            return messageContainer;
        }
        throw new IllegalArgumentException();
    }

    public synchronized ManagedMessage createCausedCopyMessage(ManagedMessage managedMessage) throws MessageException {
        if (managedMessage != null && managedMessage instanceof MessageContainer) {
            MessageContainer messageContainer = ((MessageContainer)managedMessage).copy();
            this.setStdHeaders(messageContainer);
            messageContainer.addCauseID(managedMessage.getID());
            return messageContainer;
        }
        throw new IllegalArgumentException();
    }

    public synchronized ManagedMessage createMessageCopyInSequence(ManagedMessage managedMessage, Long l, Long l2, boolean bl) throws MessageException {
        MessageContainer messageContainer = (MessageContainer)this.copyMessage(managedMessage);
        this.setStdHeaders(messageContainer);
        messageContainer.addCauseID(managedMessage.getID());
        messageContainer.setSequenceID(l);
        messageContainer.setSequencePosition(l2);
        messageContainer.setSequenceEnd(bl);
        return messageContainer;
    }

    private void setStdHeaders(MessageContainer messageContainer) {
        messageContainer.setHeader("__PSRL_ID", Long.toString(msgIdCounter++));
        messageContainer.setHeader("__PSRL_VERSION", "1");
        messageContainer.setHeader("__PSRL_TIMESTAMP_CREATION", timestampFormat.format(new Date()));
    }
}

