/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.ext.impl;

import com.isencia.passerelle.domain.cap.Director;
import com.isencia.passerelle.ext.ExecutionControlStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.Actor;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class StartStopExecutionControlStrategy
extends Attribute
implements ExecutionControlStrategy {
    private Logger logger = LoggerFactory.getLogger(StartStopExecutionControlStrategy.class);
    private boolean started;
    private boolean stopped = false;

    public StartStopExecutionControlStrategy(Director director, String string) throws IllegalActionException, NameDuplicationException {
        super((NamedObj)director, string);
        director.setExecutionControlStrategy(this);
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    public synchronized boolean isStopped() {
        return this.stopped;
    }

    public synchronized void start() {
        this.started = true;
        this.notifyAll();
    }

    public synchronized void stop() {
        this.stopped = true;
        this.notifyAll();
    }

    @Override
    public synchronized ExecutionControlStrategy.IterationPermission requestNextIteration(Actor actor) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("requestNextIteration() - entry - actor " + ((NamedObj)actor).getName());
        }
        while (!this.isStarted() && !this.isStopped()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        if (this.isStopped()) {
            ((Director)this.getContainer()).stop();
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("requestNextIteration() - exit");
        }
        return null;
    }

    @Override
    public synchronized void iterationFinished(Actor actor, ExecutionControlStrategy.IterationPermission iterationPermission) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("iterationFinished() - entry - actor " + ((NamedObj)actor).getName());
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("iterationFinished() - exit");
        }
    }
}

