/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.ext.impl;

import com.isencia.passerelle.domain.cap.Director;
import com.isencia.passerelle.ext.ExecutionControlStrategy;
import com.isencia.util.BlockingReaderQueue;
import com.isencia.util.EmptyQueueException;
import com.isencia.util.FIFOQueue;
import com.isencia.util.IQueue;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.Actor;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class EventQueueSteppingExecutionControlStrategy
extends Attribute
implements ExecutionControlStrategy {
    private Logger logger = LoggerFactory.getLogger(EventQueueSteppingExecutionControlStrategy.class);
    private BlockingReaderQueue queue;
    private boolean steppingEnabled = true;

    public EventQueueSteppingExecutionControlStrategy(Director director, String string) throws IllegalActionException, NameDuplicationException {
        super((NamedObj)director, string);
        director.setExecutionControlStrategy(this);
        this.setPersistent(false);
        this.queue = new BlockingReaderQueue((IQueue)new FIFOQueue(100));
    }

    @Override
    public synchronized ExecutionControlStrategy.IterationPermission requestNextIteration(Actor actor) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("requestNextIteration() - entry - actor " + ((NamedObj)actor).getName());
        }
        try {
            if (this.isSteppingEnabled()) {
                this.queue.get();
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("requestNextIteration() - granted for actor " + ((NamedObj)actor).getName());
            }
        }
        catch (EmptyQueueException emptyQueueException) {}
        return null;
    }

    @Override
    public void iterationFinished(Actor actor, ExecutionControlStrategy.IterationPermission iterationPermission) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("iterationFinished() - entry - actor " + ((NamedObj)actor).getName());
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("iterationFinished() - exit");
        }
    }

    public void step() {
        this.queue.put((Object)new Date());
    }

    public void resume() {
        this.setSteppingEnabled(false);
    }

    public void setSteppingEnabled(boolean bl) {
        this.steppingEnabled = bl;
        if (!bl) {
            this.step();
        }
    }

    public boolean isSteppingEnabled() {
        return this.steppingEnabled;
    }
}

