/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.ext.impl;

import com.isencia.passerelle.ext.ExecutionControlStrategy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.Actor;
import ptolemy.kernel.util.NamedObj;

public class DefaultExecutionControlStrategy
implements ExecutionControlStrategy {
    private Logger logger = LoggerFactory.getLogger(DefaultExecutionControlStrategy.class);
    private Map<Actor, Condition> pausedActors = new HashMap<Actor, Condition>();
    private ReentrantLock pauseLock = new ReentrantLock();
    private boolean modelFinished = false;
    private ExecutionControlStrategy delegate = null;

    public void setDelegate(ExecutionControlStrategy executionControlStrategy) {
        this.delegate = executionControlStrategy;
    }

    public ExecutionControlStrategy getDelegate() {
        return this.delegate;
    }

    /*
     * Loose catch block
     */
    public boolean pause(Actor actor) {
        if (actor != null) {
            block14: {
                this.pauseLock.lockInterruptibly();
                if (!this.pausedActors.containsKey(actor)) break block14;
                try {
                    this.pauseLock.unlock();
                }
                catch (Exception exception) {}
                return false;
            }
            this.pausedActors.put(actor, this.pauseLock.newCondition());
            try {
                this.pauseLock.unlock();
            }
            catch (Exception exception) {}
            return true;
            catch (InterruptedException interruptedException) {
                try {
                    this.logger.error("pause failed for actor " + actor.getFullName(), (Throwable)interruptedException);
                }
                catch (Throwable throwable) {
                    try {
                        this.pauseLock.unlock();
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    this.pauseLock.unlock();
                }
                catch (Exception exception) {}
                return false;
            }
        }
        return false;
    }

    public boolean resume(Actor actor) {
        Condition condition = this.pausedActors.remove(actor);
        if (condition != null) {
            condition.signalAll();
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ExecutionControlStrategy.IterationPermission requestNextIteration(Actor actor) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("requestNextIteration() - entry - actor " + ((NamedObj)actor).getName());
        }
        try {
            Condition condition = this.pausedActors.get(actor);
            if (condition != null) {
                try {
                    this.pauseLock.lockInterruptibly();
                    condition.await(1L, TimeUnit.SECONDS);
                    return null;
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
            }
            if (this.delegate == null) return null;
            ExecutionControlStrategy.IterationPermission iterationPermission = this.delegate.requestNextIteration(actor);
            return iterationPermission;
        }
        finally {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("requestNextIteration() - exit");
            }
        }
    }

    @Override
    public void iterationFinished(Actor actor, ExecutionControlStrategy.IterationPermission iterationPermission) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("iterationFinished() - entry - actor " + ((NamedObj)actor).getName());
        }
        if (this.delegate != null) {
            this.delegate.iterationFinished(actor, iterationPermission);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("iterationFinished() - exit");
        }
    }
}

