/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.ext.impl;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.TerminationException;
import com.isencia.passerelle.actor.ValidationException;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.ext.ErrorControlStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Nameable;

public class DefaultActorErrorControlStrategy
implements ErrorControlStrategy {
    @Override
    public void handleInitializationException(Actor actor, InitializationException initializationException) throws IllegalActionException {
        DefaultActorErrorControlStrategy.getLoggerForActor(actor).error(String.valueOf(actor.getInfo()) + " initialize() - generated exception during doInitialize()", (Throwable)initializationException);
        Actor.getAuditLogger().error(String.valueOf(actor.getInfo()) + " INITIALIZATION FAILED");
        throw new IllegalActionException((Nameable)actor, (Throwable)initializationException, "");
    }

    @Override
    public void handleInitializationValidationException(Actor actor, ValidationException validationException) throws IllegalActionException {
        DefaultActorErrorControlStrategy.getLoggerForActor(actor).error(String.valueOf(actor.getInfo()) + " initialize() - generated exception during validateInitialization()", (Throwable)validationException);
        Actor.getAuditLogger().error(String.valueOf(actor.getInfo()) + " INITIALIZATION VALIDATION FAILED");
        throw new IllegalActionException((Nameable)actor, (Throwable)validationException, "");
    }

    @Override
    public void handleIterationValidationException(Actor actor, ValidationException validationException) throws IllegalActionException {
        DefaultActorErrorControlStrategy.getLoggerForActor(actor).error(String.valueOf(actor.getInfo()) + " generated exception during iterationValidation()", (Throwable)validationException);
        Actor.getAuditLogger().error(String.valueOf(actor.getInfo()) + " ITERATION VALIDATION FAILED");
        throw new IllegalActionException((Nameable)actor, (Throwable)validationException, "");
    }

    @Override
    public void handlePreFireException(Actor actor, ProcessingException processingException) throws IllegalActionException {
        if (processingException.getSeverity() == PasserelleException.Severity.FATAL) {
            DefaultActorErrorControlStrategy.getLoggerForActor(actor).error(String.valueOf(actor.getInfo()) + " prefire() - generated exception", (Throwable)processingException);
            throw new IllegalActionException((Nameable)actor, (Throwable)processingException, "");
        }
        actor.sendErrorMessage(processingException);
    }

    protected static Logger getLoggerForActor(Actor actor) {
        return LoggerFactory.getLogger(actor.getClass());
    }

    @Override
    public void handleFireException(Actor actor, ProcessingException processingException) throws IllegalActionException {
        if (processingException.getSeverity() == PasserelleException.Severity.FATAL) {
            DefaultActorErrorControlStrategy.getLoggerForActor(actor).error(String.valueOf(actor.getInfo()) + " fire() - generated exception", (Throwable)processingException);
            throw new IllegalActionException((Nameable)actor, (Throwable)processingException, "");
        }
        actor.sendErrorMessage(processingException);
    }

    @Override
    public void handlePostFireException(Actor actor, ProcessingException processingException) throws IllegalActionException {
        if (processingException.getSeverity() == PasserelleException.Severity.FATAL) {
            DefaultActorErrorControlStrategy.getLoggerForActor(actor).error(String.valueOf(actor.getInfo()) + " postfire() -generated exception", (Throwable)processingException);
            throw new IllegalActionException((Nameable)actor, (Throwable)processingException, "");
        }
        actor.sendErrorMessage(processingException);
    }

    @Override
    public void handleTerminationException(Actor actor, TerminationException terminationException) throws IllegalActionException {
        DefaultActorErrorControlStrategy.getLoggerForActor(actor).error(String.valueOf(actor.getInfo()) + " wrapup() - generated exception during doWrapUp()", (Throwable)terminationException);
        throw new IllegalActionException((Nameable)actor, (Throwable)terminationException, "");
    }

    @Override
    public void handleFireRuntimeException(Actor actor, RuntimeException runtimeException) throws IllegalActionException {
        DefaultActorErrorControlStrategy.getLoggerForActor(actor).error(String.valueOf(actor.getInfo()) + " fire() - generated exception during doFire()", (Throwable)runtimeException);
        throw new IllegalActionException((Nameable)actor, (Throwable)runtimeException, "");
    }

    @Override
    public void handlePostFireRuntimeException(Actor actor, RuntimeException runtimeException) throws IllegalActionException {
        DefaultActorErrorControlStrategy.getLoggerForActor(actor).error(String.valueOf(actor.getInfo()) + " postfire() -generated exception during doPostFire()", (Throwable)runtimeException);
        throw new IllegalActionException((Nameable)actor, (Throwable)runtimeException, "");
    }

    @Override
    public void handlePreFireRuntimeException(Actor actor, RuntimeException runtimeException) throws IllegalActionException {
        DefaultActorErrorControlStrategy.getLoggerForActor(actor).error(String.valueOf(actor.getInfo()) + " prefire() - generated exception during doPreFire()", (Throwable)runtimeException);
        throw new IllegalActionException((Nameable)actor, (Throwable)runtimeException, "");
    }
}

