/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.executor;

import com.isencia.passerelle.executor.ContextVisitor;
import java.util.HashMap;
import java.util.Map;
import ptolemy.actor.Manager;
import ptolemy.data.ObjectToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.util.NamedObj;

public class ExecutionContext {
    public static final String EXECUTION_CTXT_ATTR = "com.isencia.passerelle.execution.ctxt";
    private Map attributes = new HashMap();

    private ExecutionContext() {
    }

    public static ExecutionContext getExecutionContext(Manager manager) {
        if (manager == null) {
            return null;
        }
        ExecutionContext executionContext = null;
        try {
            Parameter parameter = (Parameter)manager.getAttribute(EXECUTION_CTXT_ATTR);
            if (parameter != null) {
                ObjectToken objectToken = (ObjectToken)parameter.getToken();
                executionContext = (ExecutionContext)objectToken.getValue();
            } else {
                executionContext = new ExecutionContext();
                new Parameter((NamedObj)manager, EXECUTION_CTXT_ATTR, (Token)new ObjectToken((Object)executionContext));
            }
        }
        catch (Exception exception) {
            executionContext = null;
        }
        return executionContext;
    }

    public void setAttribute(String string, Object object) {
        this.attributes.put(string, object);
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public void acceptVisitor(ContextVisitor contextVisitor) {
        if (contextVisitor != null) {
            for (Map.Entry entry : this.attributes.entrySet()) {
                contextVisitor.accept((String)entry.getKey(), entry.getValue());
            }
        }
    }
}

