/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.executor;

import com.isencia.passerelle.model.Flow;
import com.isencia.passerelle.model.FlowManager;
import java.io.File;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncModelExecutor
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(AsyncModelExecutor.class);
    private String[] args;
    private FlowManager flowManager;

    public AsyncModelExecutor(String[] stringArray) {
        this.args = stringArray;
        this.flowManager = new FlowManager();
    }

    public static void main(String[] stringArray) {
        logger.debug("Passerelle started");
        AsyncModelExecutor asyncModelExecutor = new AsyncModelExecutor(stringArray);
        asyncModelExecutor.run();
        logger.debug("Passerelle stopped");
    }

    @Override
    public void run() {
        try {
            File file = new File(this.args[0]);
            if (file == null || !file.exists()) {
                throw new IllegalArgumentException("File " + file.getAbsolutePath() + " not found, execution failed ");
            }
            if (!file.getName().endsWith(".moml") && !file.getName().endsWith(".xml")) {
                throw new IllegalArgumentException("File " + file.getAbsolutePath() + " is not a moml file, execution failed ");
            }
            Flow flow = FlowManager.readMoml(file.toURL());
            HashMap<String, String> hashMap = new HashMap<String, String>();
            int n = 1;
            while (n < this.args.length) {
                String string = this.args[n];
                String[] stringArray = string.split("=");
                if (stringArray.length != 2) {
                    throw new Exception("Invalid parameter override definition " + string);
                }
                hashMap.put(stringArray[0], stringArray[1]);
                ++n;
            }
            this.flowManager.executeBlockingLocally(flow, hashMap);
        }
        catch (Exception exception) {
            logger.error("Execution failed", (Throwable)exception);
        }
    }
}

