/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.domain.cap;

import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.domain.ProcessDirector;
import com.isencia.passerelle.domain.cap.BlockingQueueReceiver;
import com.isencia.passerelle.util.SchedulerUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Receiver;
import ptolemy.actor.gui.style.CheckBoxStyle;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.FileParameter;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class Director
extends ProcessDirector {
    private static Logger logger = LoggerFactory.getLogger(Director.class);
    private File propsFile = null;
    public FileParameter propsFileParameter;
    public static final String PROPSFILE_PARAM = "Properties File";
    private boolean mockMode = false;
    public Parameter mockModeParam = null;
    public static final String MOCKMODE_PARAM = "Mock Mode";
    private boolean expertMode = false;
    public Parameter expertModeParam = null;
    public static final String EXPERTMODE_PARAM = "Expert Modeler";
    private boolean validateInitialization = false;
    public Parameter validateInitializationParam = null;
    public static final String VALIDATE_INITIALIZATION_PARAM = "Validate Initialization";
    private boolean validateIteration = false;
    public Parameter validateIterationParam = null;
    public static final String VALIDATE_ITERATION_PARAM = "Validate Iteration";
    private Scheduler scheduler = null;
    private Collection<BlockingQueueReceiver> managedReceivers = new HashSet<BlockingQueueReceiver>();

    public Director() throws IllegalActionException, NameDuplicationException {
        this(null);
    }

    public Director(Workspace workspace) throws IllegalActionException, NameDuplicationException {
        super(workspace);
        this.propsFileParameter = new FileParameter((NamedObj)this, PROPSFILE_PARAM);
        this.registerConfigurableParameter((Parameter)this.propsFileParameter);
        this.mockModeParam = new Parameter((NamedObj)this, MOCKMODE_PARAM, (Token)new BooleanToken(false));
        this.mockModeParam.setTypeEquals((Type)BaseType.BOOLEAN);
        new CheckBoxStyle(this.mockModeParam, "style");
        this.registerConfigurableParameter(this.mockModeParam);
        this.expertModeParam = new Parameter((NamedObj)this, EXPERTMODE_PARAM, (Token)new BooleanToken(false));
        this.expertModeParam.setTypeEquals((Type)BaseType.BOOLEAN);
        new CheckBoxStyle(this.expertModeParam, "style");
        this.registerConfigurableParameter(this.expertModeParam);
        this.validateInitializationParam = new Parameter((NamedObj)this, VALIDATE_INITIALIZATION_PARAM, (Token)new BooleanToken(true));
        this.validateInitializationParam.setTypeEquals((Type)BaseType.BOOLEAN);
        new CheckBoxStyle(this.validateInitializationParam, "style");
        this.registerConfigurableParameter(this.validateInitializationParam);
        this.validateIterationParam = new Parameter((NamedObj)this, VALIDATE_ITERATION_PARAM, (Token)new BooleanToken(false));
        this.validateIterationParam.setTypeEquals((Type)BaseType.BOOLEAN);
        new CheckBoxStyle(this.validateIterationParam, "style");
        this.registerConfigurableParameter(this.validateIterationParam);
    }

    public Director(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
        this.propsFileParameter = new FileParameter((NamedObj)this, PROPSFILE_PARAM);
        this.registerConfigurableParameter((Parameter)this.propsFileParameter);
        this.mockModeParam = new Parameter((NamedObj)this, MOCKMODE_PARAM, (Token)new BooleanToken(false));
        this.mockModeParam.setTypeEquals((Type)BaseType.BOOLEAN);
        new CheckBoxStyle(this.mockModeParam, "style");
        this.registerConfigurableParameter(this.mockModeParam);
        this.expertModeParam = new Parameter((NamedObj)this, EXPERTMODE_PARAM, (Token)new BooleanToken(false));
        this.expertModeParam.setTypeEquals((Type)BaseType.BOOLEAN);
        new CheckBoxStyle(this.expertModeParam, "style");
        this.registerConfigurableParameter(this.expertModeParam);
        this.validateInitializationParam = new Parameter((NamedObj)this, VALIDATE_INITIALIZATION_PARAM, (Token)new BooleanToken(true));
        this.validateInitializationParam.setTypeEquals((Type)BaseType.BOOLEAN);
        new CheckBoxStyle(this.validateInitializationParam, "style");
        this.registerConfigurableParameter(this.validateInitializationParam);
        this.validateIterationParam = new Parameter((NamedObj)this, VALIDATE_ITERATION_PARAM, (Token)new BooleanToken(false));
        this.validateIterationParam.setTypeEquals((Type)BaseType.BOOLEAN);
        new CheckBoxStyle(this.validateIterationParam, "style");
        this.registerConfigurableParameter(this.validateIterationParam);
        this._attachText("_iconDescription", "<svg>\n<polygon points=\"-20,0 -10,-18 10,-18 20,0 10,18 -10,18\" style=\"fill:red;stroke:red\"/>\n<line x1=\"-9.5\" y1=\"17\" x2=\"-19\" y2=\"0\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"-19\" y1=\"0\" x2=\"-9.5\" y2=\"-17\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"-9\" y1=\"-17\" x2=\"9\" y2=\"-17\" style=\"stroke-width:1.0;stroke:white\"/>\n<line x1=\"10\" y1=\"-17.5\" x2=\"20\" y2=\"0\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"20\" y1=\"0\" x2=\"10\" y2=\"17.5\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"10\" y1=\"17.5\" x2=\"-10\" y2=\"17.5\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"11\" y1=\"-15\" x2=\"19\" y2=\"0\" style=\"stroke-width:1.0;stroke:grey\"/>\n<line x1=\"19\" y1=\"0\" x2=\"11\" y2=\"16\" style=\"stroke-width:1.0;stroke:grey\"/>\n<line x1=\"10\" y1=\"17\" x2=\"-9\" y2=\"17\" style=\"stroke-width:1.0;stroke:grey\"/>\n<line x1=\"0\" y1=\"0\" x2=\"0\" y2=\"10\" style=\"stroke-width:1.0;stroke:black\"/>\n<line x1=\"-6\" y1=\"10\" x2=\"6\" y2=\"10\" style=\"stroke-width:1.0;stroke:black\"/>\n<polygon points=\"-8,0 -6,-8 8,-8 6,0\" style=\"fill:lightgrey\"/>\n<line x1=\"5\" y1=\"-15\" x2=\"15\" y2=\"-5\" style=\"stroke-width:2.0;stroke:black\"/>\n<line x1=\"5\" y1=\"-15\" x2=\"6\" y2=\"-14\" style=\"stroke-width:2.0;stroke:white\"/>\n<circle cx=\"12\" cy=\"-16\" r=\"1\"style=\"fill:black;stroke:white\"/>\n<circle cx=\"16\" cy=\"-16\" r=\"1\"style=\"fill:black;stroke:white\"/>\n<circle cx=\"14\" cy=\"-14\" r=\"1\"style=\"fill:black;stroke:white\"/>\n</svg>\n");
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        Director director = (Director)super.clone(workspace);
        return director;
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getName()) + " :" + attribute);
        }
        if (attribute == this.propsFileParameter) {
            try {
                String string = this.propsFileParameter.asFile().getPath();
                this.propsFile = new File(string);
                logger.debug("System Properties file changed to : " + string);
            }
            catch (NullPointerException nullPointerException) {}
        } else if (attribute == this.mockModeParam) {
            this.mockMode = ((BooleanToken)this.mockModeParam.getToken()).booleanValue();
            logger.debug("Test mode set to : " + this.mockMode);
        } else if (attribute == this.expertModeParam) {
            this.expertMode = ((BooleanToken)this.expertModeParam.getToken()).booleanValue();
            logger.debug("Expert mode set to : " + this.expertMode);
        } else if (attribute == this.validateInitializationParam) {
            this.validateInitialization = ((BooleanToken)this.validateInitializationParam.getToken()).booleanValue();
            logger.debug("Initialization validation set to : " + this.validateInitialization);
        } else if (attribute == this.validateIterationParam) {
            this.validateIteration = ((BooleanToken)this.validateIterationParam.getToken()).booleanValue();
            logger.debug("Iteration validation set to : " + this.validateIteration);
        } else {
            super.attributeChanged(attribute);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(this.getName());
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getName()) + " initialize() - entry");
        }
        if (this.propsFile != null) {
            try {
                FileInputStream fileInputStream = new FileInputStream(this.propsFile);
                System.getProperties().load(fileInputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.error("", (Throwable)fileNotFoundException);
            }
            catch (IOException iOException) {
                logger.error("", (Throwable)iOException);
            }
        }
        super.initialize();
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getName()) + " initialize() - exit");
        }
    }

    public Receiver newReceiver() {
        BlockingQueueReceiver blockingQueueReceiver = new BlockingQueueReceiver();
        this.managedReceivers.add(blockingQueueReceiver);
        try {
            blockingQueueReceiver.setCapacity(-1);
        }
        catch (IllegalActionException illegalActionException) {}
        return blockingQueueReceiver;
    }

    public Collection<BlockingQueueReceiver> getManagedReceivers() {
        return Collections.unmodifiableCollection(this.managedReceivers);
    }

    public boolean postfire() throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getName()) + " postfire() - entry");
        }
        boolean bl = true;
        this._notDone = super.postfire();
        bl = !((CompositeActor)this.getContainer()).inputPortList().isEmpty() && this._getActiveThreadsCount() != 0 ? !this._stopRequested : this._notDone;
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getName()) + " postfire() - exit - returning :" + bl);
        }
        return bl;
    }

    @Override
    public void wrapup() throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getName()) + " wrapup() - entry");
        }
        if (this.scheduler != null) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Stopping scheduler " + this.scheduler.getSchedulerName());
                }
            }
            catch (SchedulerException schedulerException) {
                logger.error("Error shutting down the scheduler", (Throwable)schedulerException);
            }
            this.scheduler = null;
        }
        super.wrapup();
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getName()) + " wrapup() - exit");
        }
    }

    protected boolean _resolveInternalDeadlock() throws IllegalActionException {
        return this._getActiveThreadsCount() != 0;
    }

    public Scheduler getScheduler() throws InitializationException {
        if (this.scheduler == null) {
            try {
                String string = String.valueOf(this.getContainer().getName()) + "_" + this.getName();
                if (logger.isDebugEnabled()) {
                    logger.debug("Starting scheduler " + string);
                }
                this.scheduler = SchedulerUtils.getQuartzScheduler(string);
                this.scheduler.start();
            }
            catch (SchedulerException schedulerException) {
                throw new InitializationException(PasserelleException.Severity.FATAL, String.valueOf(this.getName()) + " - Error starting the scheduler", this, schedulerException);
            }
        }
        return this.scheduler;
    }

    public boolean isMockMode() {
        return this.mockMode;
    }

    public boolean isExpertMode() {
        return this.expertMode;
    }

    public boolean mustValidateInitialization() {
        return this.validateInitialization;
    }

    public boolean mustValidateIteration() {
        return this.validateIteration;
    }
}

