/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.domain.cap;

import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageBuffer;
import com.isencia.passerelle.message.MessageHelper;
import com.isencia.passerelle.message.MessageInputContext;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.IOPort;
import ptolemy.actor.QueueReceiver;
import ptolemy.actor.Receiver;
import ptolemy.actor.process.BoundaryDetector;
import ptolemy.actor.process.ProcessReceiver;
import ptolemy.data.Token;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Workspace;

public class BlockingQueueReceiver
extends QueueReceiver
implements ProcessReceiver {
    private static final Logger logger = LoggerFactory.getLogger(BlockingQueueReceiver.class);
    private BoundaryDetector _boundaryDetector = new BoundaryDetector((Receiver)this);
    private boolean _terminate = false;
    private int sizeWarningThreshold;
    private MessageBuffer buffer;

    public BlockingQueueReceiver() {
    }

    public BlockingQueueReceiver(IOPort iOPort) throws IllegalActionException {
        super(iOPort);
    }

    public void setMessagBuffer(MessageBuffer messageBuffer) {
        this.buffer = messageBuffer;
        if (messageBuffer != null) {
            messageBuffer.registerMessageProvider((Object)this);
        }
    }

    public boolean isConnectedToBoundary() {
        return this._boundaryDetector.isConnectedToBoundary();
    }

    public boolean isConnectedToBoundaryInside() {
        return this._boundaryDetector.isConnectedToBoundaryInside();
    }

    public boolean isConnectedToBoundaryOutside() {
        return this._boundaryDetector.isConnectedToBoundaryOutside();
    }

    public boolean isConsumerReceiver() {
        return this.isConnectedToBoundary();
    }

    public boolean isInsideBoundary() {
        return this._boundaryDetector.isInsideBoundary();
    }

    public boolean isOutsideBoundary() {
        return this._boundaryDetector.isOutsideBoundary();
    }

    public boolean isProducerReceiver() {
        return this.isOutsideBoundary() || this.isInsideBoundary();
    }

    public boolean isReadBlocked() {
        return false;
    }

    public boolean isWriteBlocked() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Token get() {
        Workspace workspace = this.getContainer().workspace();
        Token token = null;
        if (this.buffer != null) {
            throw new UnsupportedOperationException("get() not supported for shared buffer");
        }
        BlockingQueueReceiver blockingQueueReceiver = this;
        synchronized (blockingQueueReceiver) {
            while (true) {
                if (this._terminate || super.hasToken()) {
                    if (!super.hasToken()) return token;
                    return super.get();
                }
                try {
                    workspace.wait((Object)this, 1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public boolean hasRoom() {
        return true;
    }

    public boolean hasRoom(int n) {
        return true;
    }

    public boolean hasToken() {
        return true;
    }

    public boolean hasToken(int n) {
        return true;
    }

    public List<Token> elementList() {
        if (this.buffer != null) {
            throw new UnsupportedOperationException("elementList() not supported for shared buffer");
        }
        return super.elementList();
    }

    public int getCapacity() {
        if (this.buffer != null) {
            return 0;
        }
        return super.getCapacity();
    }

    public void setCapacity(int n) throws IllegalActionException {
        if (this.buffer != null) {
            throw new UnsupportedOperationException("setCapacity() not supported for shared buffer");
        }
        super.setCapacity(n);
    }

    public int size() {
        if (this.buffer != null) {
            return this.buffer.getMessageQueue().size();
        }
        return super.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Token token) {
        BlockingQueueReceiver blockingQueueReceiver = this;
        synchronized (blockingQueueReceiver) {
            if (this._terminate) {
                return;
            }
            if (this.buffer != null) {
                try {
                    Object object;
                    if (this.getContainer() instanceof Port) {
                        object = (Port)this.getContainer();
                        try {
                            token = ((Port)((Object)object)).convertTokenForMe(token);
                        }
                        catch (Exception exception) {
                            throw new RuntimeException("Failed to convert token " + token, exception);
                        }
                    }
                    object = MessageHelper.getMessageFromToken(token);
                    MessageInputContext messageInputContext = new MessageInputContext(0, this.getContainer().getName(), (ManagedMessage)object);
                    this.buffer.offer(messageInputContext);
                }
                catch (PasserelleException passerelleException) {
                    throw new RuntimeException("Failed to interpret token " + token, passerelleException);
                }
            }
            super.put(token);
            ((Object)((Object)this)).notifyAll();
            if (this.getSizeWarningThreshold() != -1 && this.size() >= this.getSizeWarningThreshold()) {
                logger.warn(String.valueOf(this.getContainer().getFullName()) + " - reached/passed warning threshold size " + this.getSizeWarningThreshold());
            }
        }
    }

    public synchronized void requestFinish() {
        if (logger.isTraceEnabled()) {
            logger.trace("requestFinish() - entry - for " + this.toString() + " in " + this.getContainer().getFullName());
        }
        this._terminate = true;
        ((Object)((Object)this)).notifyAll();
        if (this.buffer != null) {
            this.buffer.unregisterMessageProvider((Object)this);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("requestFinish() - exit");
        }
    }

    public void reset() {
        this._terminate = false;
        this._boundaryDetector.reset();
    }

    public void setSizeWarningThreshold(int n) {
        this.sizeWarningThreshold = n;
    }

    public int getSizeWarningThreshold() {
        return this.sizeWarningThreshold;
    }
}

