/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.domain;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.domain.ProcessThread;
import com.isencia.passerelle.ext.ErrorCollector;
import com.isencia.passerelle.ext.ErrorControlStrategy;
import com.isencia.passerelle.ext.ExecutionControlStrategy;
import com.isencia.passerelle.ext.ExecutionPrePostProcessor;
import com.isencia.passerelle.ext.FiringEventListener;
import com.isencia.passerelle.ext.impl.DefaultActorErrorControlStrategy;
import com.isencia.passerelle.ext.impl.DefaultExecutionControlStrategy;
import com.isencia.passerelle.ext.impl.DefaultExecutionPrePostProcessor;
import java.util.Collection;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.FiringEvent;
import ptolemy.actor.process.CompositeProcessDirector;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Workspace;

public abstract class ProcessDirector
extends CompositeProcessDirector
implements ExecutionControlStrategy {
    private static Logger logger = LoggerFactory.getLogger(ProcessDirector.class);
    private Collection<Parameter> configurableParameters = new HashSet<Parameter>();
    private Collection<FiringEventListener> firingEventListeners = new HashSet<FiringEventListener>();
    private Collection<ErrorCollector> errorCollectors = new HashSet<ErrorCollector>();
    private DefaultExecutionControlStrategy execCtrlStrategy = new DefaultExecutionControlStrategy();
    private ExecutionPrePostProcessor execPrePostProcessor = new DefaultExecutionPrePostProcessor();
    private ErrorControlStrategy errorCtrlStrategy = new DefaultActorErrorControlStrategy();
    private boolean enforcedErrorCtrlStrategy;
    private Collection<ProcessThread> myThreads = new HashSet<ProcessThread>();

    public ProcessDirector() throws IllegalActionException, NameDuplicationException {
        this(null);
    }

    public ProcessDirector(Workspace workspace) throws IllegalActionException, NameDuplicationException {
        super(workspace);
    }

    public ProcessDirector(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
    }

    public synchronized void addThread(Thread thread) {
        super.addThread(thread);
        if (thread instanceof ProcessThread) {
            this.myThreads.add((ProcessThread)((Object)thread));
        }
    }

    public void preinitialize() throws IllegalActionException {
        super.preinitialize();
        this.myThreads.clear();
    }

    public synchronized void removeThread(Thread thread) {
        super.removeThread(thread);
        if (thread instanceof ProcessThread) {
            this.myThreads.remove((Object)((ProcessThread)((Object)thread)));
        }
    }

    public Collection<ProcessThread> getThreads() {
        return this.myThreads;
    }

    public Parameter[] getConfigurableParameters() {
        return this.configurableParameters.toArray(new Parameter[0]);
    }

    protected void registerConfigurableParameter(Parameter parameter) {
        if (parameter != null && !this.configurableParameters.contains(parameter) && parameter.getContainer().equals(this)) {
            this.configurableParameters.add(parameter);
        }
    }

    public void registerFiringEventListener(FiringEventListener firingEventListener) {
        if (firingEventListener != null) {
            this.firingEventListeners.add(firingEventListener);
        }
    }

    public boolean removeFiringEventListener(FiringEventListener firingEventListener) {
        return this.firingEventListeners.remove(firingEventListener);
    }

    public boolean hasFiringEventListeners() {
        return !this.firingEventListeners.isEmpty();
    }

    public void notifyFiringEventListeners(FiringEvent firingEvent) {
        if (firingEvent != null && firingEvent.getDirector().equals(this)) {
            for (FiringEventListener firingEventListener : this.firingEventListeners) {
                firingEventListener.onEvent(firingEvent);
            }
        }
    }

    protected ptolemy.actor.process.ProcessThread _newProcessThread(ptolemy.actor.Actor actor, ptolemy.actor.process.ProcessDirector processDirector) throws IllegalActionException {
        return new ProcessThread(actor, (ProcessDirector)processDirector);
    }

    @Override
    public synchronized ExecutionControlStrategy.IterationPermission requestNextIteration(ptolemy.actor.Actor actor) {
        return this.execCtrlStrategy.requestNextIteration(actor);
    }

    @Override
    public void iterationFinished(ptolemy.actor.Actor actor, ExecutionControlStrategy.IterationPermission iterationPermission) {
        this.execCtrlStrategy.iterationFinished(actor, iterationPermission);
    }

    public void pauseAllActors() {
        this.stopFire();
    }

    public void resumeAllActors() {
        for (ProcessThread processThread : this.myThreads) {
            if (!(processThread.getActor() instanceof Actor)) continue;
            ((Actor)processThread.getActor()).resumeFire();
        }
    }

    public void setExecutionControlStrategy(ExecutionControlStrategy executionControlStrategy) {
        this.execCtrlStrategy.setDelegate(executionControlStrategy);
    }

    public ExecutionControlStrategy getExecutionControlStrategy() {
        return this.execCtrlStrategy.getDelegate();
    }

    public ErrorControlStrategy getErrorControlStrategy() {
        return this.errorCtrlStrategy;
    }

    public void setErrorControlStrategy(ErrorControlStrategy errorControlStrategy, boolean bl) {
        if (bl || !this.enforcedErrorCtrlStrategy) {
            this.errorCtrlStrategy = errorControlStrategy;
            this.enforcedErrorCtrlStrategy = bl;
        }
    }

    public void setExecutionPrePostProcessor(ExecutionPrePostProcessor executionPrePostProcessor) {
        this.execPrePostProcessor = executionPrePostProcessor;
    }

    public ExecutionPrePostProcessor getExecutionPrePostProcessor() {
        return this.execPrePostProcessor;
    }

    public void addErrorCollector(ErrorCollector errorCollector) {
        if (logger.isTraceEnabled()) {
            logger.trace("addErrorCollector() - Adding error collector " + errorCollector);
        }
        if (errorCollector != null) {
            this.errorCollectors.add(errorCollector);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("addErrorCollector() - exit");
        }
    }

    public boolean removeErrorCollector(ErrorCollector errorCollector) {
        if (logger.isTraceEnabled()) {
            logger.trace("removeErrorCollector() - entry - Removing error collector " + errorCollector);
        }
        boolean bl = false;
        if (errorCollector != null) {
            bl = this.errorCollectors.remove(errorCollector);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("removeErrorCollector() - exit :" + bl);
        }
        return bl;
    }

    public void removeAllErrorCollectors() {
        if (logger.isTraceEnabled()) {
            logger.trace("removeAllErrorCollectors() - entry - Removing all error collectors");
        }
        this.errorCollectors.clear();
        if (logger.isTraceEnabled()) {
            logger.trace("removeAllErrorCollectors() - exit");
        }
    }

    public void reportError(PasserelleException passerelleException) {
        if (logger.isTraceEnabled()) {
            logger.trace("reportError() - entry - Reporting error :" + passerelleException);
        }
        if (!this.errorCollectors.isEmpty()) {
            for (ErrorCollector errorCollector : this.errorCollectors) {
                errorCollector.acceptError(passerelleException);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Reported error to " + errorCollector);
            }
        } else {
            logger.error("reportError() - no errorCollectors but received exception", (Throwable)passerelleException);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("reportError() - exit");
        }
    }

    public void initialize() throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getName()) + " initialize() - entry");
        }
        this.getExecutionPrePostProcessor().preProcess();
        super.initialize();
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getName()) + " initialize() - exit");
        }
    }

    public void wrapup() throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getName()) + " wrapup() - entry");
        }
        this.getExecutionPrePostProcessor().postProcess();
        super.wrapup();
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getName()) + " wrapup() - exit");
        }
    }

    public void terminate() {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getName()) + " terminate() - entry");
        }
        this.getExecutionPrePostProcessor().postProcess();
        super.terminate();
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getName()) + " terminate() - exit");
        }
    }
}

