/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.v5;

import com.isencia.passerelle.actor.v5.ProcessRequest;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageOutputContext;
import java.util.ArrayList;
import java.util.List;

public class ProcessResponse {
    private List<MessageOutputContext> outputs = new ArrayList<MessageOutputContext>();
    private List<MessageOutputContext> outputsInSequence = new ArrayList<MessageOutputContext>();
    private ProcessRequest request;

    public ProcessResponse(ProcessRequest processRequest) {
        this.request = processRequest;
    }

    public void addOutputMessage(Port port, ManagedMessage managedMessage) {
        this.outputs.add(new MessageOutputContext(port, managedMessage));
    }

    public void addOutputContext(MessageOutputContext messageOutputContext) {
        this.outputs.add(messageOutputContext);
    }

    public void addOutputMessageInSequence(Port port, ManagedMessage managedMessage) {
        this.outputsInSequence.add(new MessageOutputContext(port, managedMessage));
    }

    public void addOutputContextInSequence(MessageOutputContext messageOutputContext) {
        this.outputsInSequence.add(messageOutputContext);
    }

    public MessageOutputContext[] getOutputs() {
        return this.outputs.toArray(new MessageOutputContext[this.outputs.size()]);
    }

    public MessageOutputContext[] getOutputsInSequence() {
        return this.outputsInSequence.toArray(new MessageOutputContext[this.outputsInSequence.size()]);
    }

    public String toString() {
        MessageOutputContext messageOutputContext;
        StringBuffer stringBuffer = new StringBuffer();
        MessageOutputContext[] messageOutputContextArray = this.getOutputs();
        stringBuffer.append("\n\tIndependent msgs:");
        int n = 0;
        while (n < messageOutputContextArray.length) {
            messageOutputContext = messageOutputContextArray[n];
            stringBuffer.append("\n\t\t" + messageOutputContext.getPort().getName() + ": msgID=" + messageOutputContext.getMessage().getID());
            ++n;
        }
        messageOutputContextArray = this.getOutputsInSequence();
        stringBuffer.append("\n\tSequenced msgs:");
        n = 0;
        while (n < messageOutputContextArray.length) {
            messageOutputContext = messageOutputContextArray[n];
            stringBuffer.append("\n\t\t" + messageOutputContext.getPort().getName() + ": msgID=" + messageOutputContext.getMessage().getID());
            ++n;
        }
        return stringBuffer.toString();
    }
}

