/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.v5;

import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.ValidationException;
import com.isencia.passerelle.actor.v5.ActorContext;
import com.isencia.passerelle.actor.v5.ProcessRequest;
import com.isencia.passerelle.actor.v5.ProcessResponse;
import com.isencia.passerelle.core.ControlPort;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortHandler;
import com.isencia.passerelle.core.PortMode;
import com.isencia.passerelle.domain.cap.Director;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageBuffer;
import com.isencia.passerelle.message.MessageException;
import com.isencia.passerelle.message.MessageFactory;
import com.isencia.passerelle.message.MessageHelper;
import com.isencia.passerelle.message.MessageInputContext;
import com.isencia.passerelle.message.MessageOutputContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.IOPort;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public abstract class Actor
extends com.isencia.passerelle.actor.Actor
implements MessageBuffer {
    private static final Logger logger = LoggerFactory.getLogger(Actor.class);
    private boolean isSource = true;
    protected List<PortHandler> blockingInputHandlers = new ArrayList<PortHandler>();
    protected List<Boolean> blockingInputFinishRequests = new ArrayList<Boolean>();
    private Collection<Object> msgProviders = new HashSet<Object>();
    private Queue<MessageInputContext> pushedMessages = new ConcurrentLinkedQueue<MessageInputContext>();
    private ReentrantLock msgQLock = new ReentrantLock();
    private Condition msgQNonEmpty = this.msgQLock.newCondition();
    private long iterationCount = 0L;
    public Parameter bufferTimeParameter = new Parameter((NamedObj)this, "Buffer time (ms)", (Token)new IntToken(0));

    public Actor(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
        this.registerExpertParameter(this.bufferTimeParameter);
    }

    @Override
    protected String getExtendedInfo() {
        return "";
    }

    @Override
    public Queue<MessageInputContext> getMessageQueue() {
        return this.pushedMessages;
    }

    @Override
    public boolean acceptInputPort(Port port) {
        if (port == null || port.getContainer() != this) {
            return false;
        }
        if (port instanceof ControlPort || !port.isInput()) {
            return false;
        }
        return PortMode.PUSH.equals(port.getMode());
    }

    @Override
    public boolean registerMessageProvider(Object object) {
        this.getLogger().debug("Registered msgprovider {}", object);
        return this.msgProviders.add(object);
    }

    @Override
    public boolean unregisterMessageProvider(Object object) {
        this.getLogger().debug("Unregistered msgprovider {}", object);
        return this.msgProviders.remove(object);
    }

    @Override
    public void offer(MessageInputContext messageInputContext) throws PasserelleException {
        try {
            try {
                if (!this.msgQLock.tryLock(10L, TimeUnit.SECONDS)) {
                    throw new Exception("Msg Queue lock overcharged...");
                }
                this.pushedMessages.offer(messageInputContext);
                this.msgQNonEmpty.signal();
            }
            catch (Exception exception) {
                throw new PasserelleException("Error storing received msg", messageInputContext, exception);
            }
        }
        catch (Throwable throwable) {
            try {
                this.msgQLock.unlock();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            this.msgQLock.unlock();
        }
        catch (Exception exception) {}
    }

    @Override
    protected void doInitialize() throws InitializationException {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace(String.valueOf(this.getInfo()) + " doInitialize() - entry");
        }
        this.blockingInputHandlers.clear();
        this.blockingInputFinishRequests.clear();
        super.doInitialize();
        this.iterationCount = 0L;
        List list = this.inputPortList();
        for (Port port : list) {
            if (!port.isInput() || port instanceof ControlPort) continue;
            if (PortMode.PULL.equals(port.getMode())) {
                this.blockingInputHandlers.add(new PortHandler((IOPort)port));
                this.blockingInputFinishRequests.add(Boolean.FALSE);
            }
            this.isSource = false;
        }
        int n = 0;
        while (n < this.blockingInputHandlers.size()) {
            PortHandler portHandler = this.blockingInputHandlers.get(n);
            if (portHandler.getWidth() > 0) {
                this.blockingInputFinishRequests.set(n, Boolean.FALSE);
                portHandler.start();
            } else {
                this.blockingInputFinishRequests.set(n, Boolean.TRUE);
            }
            ++n;
        }
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace(String.valueOf(this.getInfo()) + " doInitialize() - exit ");
        }
    }

    protected PortHandler createPortHandler(Port port) {
        return new PortHandler((IOPort)port);
    }

    public long getIterationCount() {
        return this.iterationCount;
    }

    @Override
    protected void doFire() throws ProcessingException {
        Object object;
        Object object2;
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace(String.valueOf(this.getInfo()) + " doFire() - entry");
        }
        ProcessRequest processRequest = new ProcessRequest();
        processRequest.setIterationCount(this.iterationCount++);
        if (!this.isSource) {
            int n = 0;
            while (n < this.blockingInputHandlers.size()) {
                object2 = this.blockingInputHandlers.get(n);
                object = null;
                if (!this.blockingInputFinishRequests.get(n).booleanValue()) {
                    try {
                        object = MessageHelper.getMessage((PortHandler)object2);
                    }
                    catch (ProcessingException processingException) {
                        throw processingException;
                    }
                    catch (PasserelleException passerelleException) {
                        throw new ProcessingException("", object2, passerelleException);
                    }
                    if (object == null) {
                        this.blockingInputFinishRequests.set(n, Boolean.TRUE);
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug(String.valueOf(this.getInfo()) + " doFire() - found exhausted port " + ((PortHandler)object2).getName());
                        }
                    } else if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug(String.valueOf(this.getInfo()) + " doFire() - msg " + object.getID() + " received on port " + ((PortHandler)object2).getName());
                    }
                }
                processRequest.addInputMessage(n, ((PortHandler)object2).getName(), (ManagedMessage)object);
                ++n;
            }
            if (!this.msgProviders.isEmpty() || !this.pushedMessages.isEmpty()) {
                try {
                    n = ((IntToken)this.bufferTimeParameter.getToken()).intValue();
                    if (n > 0) {
                        this.getLogger().debug("{} doFire() - sleeping for buffer time {}", (Object)this.getInfo(), (Object)n);
                        Thread.sleep(n);
                    }
                }
                catch (Exception exception) {
                    this.getLogger().warn(String.valueOf(this.getInfo()) + " - Failed to enforce buffer time", (Throwable)exception);
                }
                this.addPushedMessages(processRequest);
            }
            if (this.areAllInputsFinished()) {
                this.requestFinish();
            }
        }
        if (this.isSource || processRequest.hasSomethingToProcess()) {
            Object object3;
            int n;
            Object object4;
            ActorContext actorContext = new ActorContext();
            if (this.mustValidateIteration()) {
                try {
                    if (this.getLogger().isTraceEnabled()) {
                        this.getLogger().trace("doFire() - validating iteration for request " + processRequest);
                    }
                    this.validateIteration(actorContext, processRequest);
                    if (Actor.getAuditLogger().isDebugEnabled()) {
                        Actor.getAuditLogger().debug("ITERATION VALIDATED");
                    }
                    if (this.getLogger().isTraceEnabled()) {
                        this.getLogger().trace("doFire() - validation done");
                    }
                }
                catch (ValidationException validationException) {
                    try {
                        this.getErrorControlStrategy().handleIterationValidationException(this, validationException);
                    }
                    catch (IllegalActionException illegalActionException) {
                        throw new ProcessingException(PasserelleException.Severity.FATAL, "", this, validationException);
                    }
                }
            }
            object2 = new ProcessResponse(processRequest);
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace("doFire() - processing request " + processRequest);
            }
            this.process(actorContext, processRequest, (ProcessResponse)object2);
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace("doFire() - obtained response " + object2);
            }
            object = processRequest.getAllInputContexts();
            while (object.hasNext()) {
                object4 = (MessageInputContext)object.next();
                ((MessageInputContext)object4).setProcessed(true);
            }
            object4 = ((ProcessResponse)object2).getOutputs();
            if (object4 != null) {
                Object object5 = object4;
                int n2 = ((Object)object5).length;
                n = 0;
                while (n < n2) {
                    object3 = object5[n];
                    this.sendOutputMsg(((MessageOutputContext)object3).getPort(), ((MessageOutputContext)object3).getMessage());
                    ++n;
                }
            }
            if ((object4 = ((ProcessResponse)object2).getOutputsInSequence()) != null && ((Object)object4).length > 0) {
                object3 = MessageFactory.getInstance().createSequenceID();
                n = 0;
                while (n < ((Object)object4).length) {
                    Object object6 = object4[n];
                    boolean bl = n == ((Object)object4).length - 1;
                    try {
                        ManagedMessage managedMessage = MessageFactory.getInstance().createMessageCopyInSequence(((MessageOutputContext)object6).getMessage(), (Long)object3, new Long(n), bl);
                        this.sendOutputMsg(((MessageOutputContext)object6).getPort(), managedMessage);
                    }
                    catch (MessageException messageException) {
                        throw new ProcessingException("Error creating output sequence msg for msg " + ((MessageOutputContext)object6).getMessage().getID(), ((MessageOutputContext)object6).getMessage(), messageException);
                    }
                    ++n;
                }
            }
        }
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace(String.valueOf(this.getInfo()) + " doFire() - exit ");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addPushedMessages(ProcessRequest processRequest) throws ProcessingException {
        this.getLogger().debug("addPushedMessages() - entry");
        try {
            try {
                if (!this.msgQLock.tryLock(10L, TimeUnit.SECONDS)) {
                    throw new ProcessingException("Msg Queue lock overcharged...", this, null);
                }
                while (!this.isFinishRequested() && !this.areAllInputsFinished() && this.pushedMessages.isEmpty()) {
                    this.msgQNonEmpty.await(100L, TimeUnit.MILLISECONDS);
                }
                while (!this.pushedMessages.isEmpty()) {
                    processRequest.addInputContext(this.pushedMessages.poll());
                }
            }
            catch (InterruptedException interruptedException) {
                throw new ProcessingException("Msg Queue lock interrupted...", this, null);
            }
        }
        catch (Throwable throwable) {
            try {
                this.msgQLock.unlock();
            }
            catch (Exception exception) {}
            this.getLogger().debug("addPushedMessages() - exit");
            throw throwable;
        }
        try {
            this.msgQLock.unlock();
        }
        catch (Exception exception) {}
        this.getLogger().debug("addPushedMessages() - exit");
    }

    protected boolean areAllInputsFinished() {
        boolean bl = true;
        int n = 0;
        while (n < this.blockingInputFinishRequests.size()) {
            bl = bl && this.blockingInputFinishRequests.get(n) != false;
            ++n;
        }
        return bl && this.msgProviders.isEmpty();
    }

    protected abstract void process(ActorContext var1, ProcessRequest var2, ProcessResponse var3) throws ProcessingException;

    protected void validateIteration(ActorContext actorContext, ProcessRequest processRequest) throws ValidationException {
    }

    protected boolean mustValidateIteration() {
        try {
            return ((Director)this.getDirector()).mustValidateIteration();
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        Actor actor = (Actor)super.clone(workspace);
        actor.blockingInputHandlers = new ArrayList<PortHandler>();
        actor.blockingInputFinishRequests = new ArrayList<Boolean>();
        actor.pushedMessages = new ConcurrentLinkedQueue<MessageInputContext>();
        actor.msgProviders = new HashSet<Object>();
        return actor;
    }

    protected Logger getLogger() {
        return logger;
    }
}

