/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.v3;

import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.ValidationException;
import com.isencia.passerelle.actor.v3.ActorContext;
import com.isencia.passerelle.actor.v3.MessageInputContext;
import com.isencia.passerelle.actor.v3.MessageOutputContext;
import com.isencia.passerelle.actor.v3.ProcessRequest;
import com.isencia.passerelle.actor.v3.ProcessResponse;
import com.isencia.passerelle.core.ControlPort;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.core.PortHandler;
import com.isencia.passerelle.core.PortListenerAdapter;
import com.isencia.passerelle.core.PortMode;
import com.isencia.passerelle.domain.cap.Director;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageException;
import com.isencia.passerelle.message.MessageFactory;
import com.isencia.passerelle.message.MessageHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.IOPort;
import ptolemy.data.Token;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Workspace;

public abstract class Actor
extends com.isencia.passerelle.actor.Actor {
    private static final Logger logger = LoggerFactory.getLogger(Actor.class);
    private boolean isSource = true;
    protected List<PortHandler> blockingInputHandlers;
    protected List<Boolean> blockingInputFinishRequests;
    protected List<PortHandler> pushingInputHandlers;
    protected List<Boolean> pushingInputFinishRequests;
    protected Map<String, MessageInputContext> pushedMessages = new HashMap<String, MessageInputContext>();
    private long iterationCount = 0L;

    public Actor(CompositeEntity compositeEntity, String string) throws IllegalActionException, NameDuplicationException {
        super(compositeEntity, string);
        this.blockingInputHandlers = new ArrayList<PortHandler>();
        this.blockingInputFinishRequests = new ArrayList<Boolean>();
        this.pushingInputHandlers = new ArrayList<PortHandler>();
        this.pushingInputFinishRequests = new ArrayList<Boolean>();
    }

    @Override
    protected String getExtendedInfo() {
        return "";
    }

    @Override
    protected void doInitialize() throws InitializationException {
        Object object;
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doInitialize() - entry");
        }
        this.blockingInputHandlers.clear();
        this.blockingInputFinishRequests.clear();
        this.pushingInputHandlers.clear();
        this.pushingInputFinishRequests.clear();
        super.doInitialize();
        this.iterationCount = 0L;
        this.isSource = true;
        List list = this.inputPortList();
        for (Port port : list) {
            if (!port.isInput() || port instanceof ControlPort) continue;
            if (PortMode.PUSH.equals(port.getMode())) {
                PortHandler portHandler = new PortHandler((IOPort)port);
                MsgListener msgListener = new MsgListener(this, portHandler);
                portHandler.setListener(msgListener);
                this.pushingInputHandlers.add(portHandler);
                this.pushingInputFinishRequests.add(Boolean.FALSE);
            } else {
                this.blockingInputHandlers.add(new PortHandler((IOPort)port));
                this.blockingInputFinishRequests.add(Boolean.FALSE);
            }
            this.isSource = false;
        }
        int n = 0;
        while (n < this.blockingInputHandlers.size()) {
            object = this.blockingInputHandlers.get(n);
            if (((PortHandler)object).getWidth() > 0) {
                this.blockingInputFinishRequests.set(n, Boolean.FALSE);
                ((PortHandler)object).start();
            } else {
                this.blockingInputFinishRequests.set(n, Boolean.TRUE);
            }
            ++n;
        }
        n = 0;
        while (n < this.pushingInputHandlers.size()) {
            object = this.pushingInputHandlers.get(n);
            if (((PortHandler)object).getWidth() > 0) {
                this.pushingInputFinishRequests.set(n, Boolean.FALSE);
                ((PortHandler)object).start();
            } else {
                this.pushingInputFinishRequests.set(n, Boolean.TRUE);
            }
            ++n;
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doInitialize() - exit ");
        }
    }

    public long getIterationCount() {
        return this.iterationCount;
    }

    @Override
    protected void doFire() throws ProcessingException {
        Object object;
        Iterator<MessageInputContext> iterator;
        Object object2;
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doFire() - entry");
        }
        ProcessRequest processRequest = new ProcessRequest();
        processRequest.setIterationCount(this.iterationCount++);
        if (!this.isSource) {
            int n = 0;
            while (n < this.blockingInputHandlers.size()) {
                object2 = this.blockingInputHandlers.get(n);
                iterator = null;
                if (!this.blockingInputFinishRequests.get(n).booleanValue()) {
                    try {
                        iterator = MessageHelper.getMessage((PortHandler)object2);
                    }
                    catch (ProcessingException processingException) {
                        throw processingException;
                    }
                    catch (PasserelleException passerelleException) {
                        throw new ProcessingException("", object2, passerelleException);
                    }
                    if (iterator == null) {
                        this.blockingInputFinishRequests.set(n, Boolean.TRUE);
                        if (logger.isDebugEnabled()) {
                            logger.debug(String.valueOf(this.getInfo()) + " doFire() - found exhausted port " + ((PortHandler)object2).getName());
                        }
                    } else if (logger.isDebugEnabled()) {
                        logger.debug(String.valueOf(this.getInfo()) + " doFire() - msg " + iterator.getID() + " received on port " + ((PortHandler)object2).getName());
                    }
                }
                processRequest.addInputMessage(n, ((PortHandler)object2).getName(), (ManagedMessage)((Object)iterator));
                ++n;
            }
            object = this.pushedMessages.values();
            iterator = object.iterator();
            while (iterator.hasNext()) {
                object2 = (MessageInputContext)iterator.next();
                processRequest.addInputContext((MessageInputContext)object2);
            }
            if (this.areAllInputsFinished()) {
                this.requestFinish();
            }
        }
        if (this.isSource || processRequest.hasSomethingToProcess()) {
            Object object3;
            int n;
            Object object4;
            object = new ActorContext();
            if (this.mustValidateIteration()) {
                try {
                    if (logger.isTraceEnabled()) {
                        logger.trace("doFire() - validating iteration for request " + processRequest);
                    }
                    this.validateIteration((ActorContext)object, processRequest);
                    if (Actor.getAuditLogger().isDebugEnabled()) {
                        Actor.getAuditLogger().debug("ITERATION VALIDATED");
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("doFire() - validation done");
                    }
                }
                catch (ValidationException validationException) {
                    try {
                        this.getErrorControlStrategy().handleIterationValidationException(this, validationException);
                    }
                    catch (IllegalActionException illegalActionException) {
                        throw new ProcessingException(PasserelleException.Severity.FATAL, "", this, validationException);
                    }
                }
            }
            object2 = new ProcessResponse(processRequest);
            if (logger.isTraceEnabled()) {
                logger.trace("doFire() - processing request " + processRequest);
            }
            this.process((ActorContext)object, processRequest, (ProcessResponse)object2);
            if (logger.isTraceEnabled()) {
                logger.trace("doFire() - obtained response " + object2);
            }
            iterator = processRequest.getAllInputContexts();
            while (iterator.hasNext()) {
                object4 = iterator.next();
                ((MessageInputContext)object4).setProcessed(true);
            }
            object4 = ((ProcessResponse)object2).getOutputs();
            if (object4 != null) {
                Object object5 = object4;
                int n2 = ((Object)object5).length;
                n = 0;
                while (n < n2) {
                    object3 = object5[n];
                    this.sendOutputMsg(((MessageOutputContext)object3).getPort(), ((MessageOutputContext)object3).getMessage());
                    ++n;
                }
            }
            if ((object4 = ((ProcessResponse)object2).getOutputsInSequence()) != null && ((Object)object4).length > 0) {
                object3 = MessageFactory.getInstance().createSequenceID();
                n = 0;
                while (n < ((Object)object4).length) {
                    Object object6 = object4[n];
                    boolean bl = n == ((Object)object4).length - 1;
                    try {
                        ManagedMessage managedMessage = MessageFactory.getInstance().createMessageCopyInSequence(((MessageOutputContext)object6).getMessage(), (Long)object3, new Long(n), bl);
                        this.sendOutputMsg(((MessageOutputContext)object6).getPort(), managedMessage);
                    }
                    catch (MessageException messageException) {
                        throw new ProcessingException("Error creating output sequence msg for msg " + ((MessageOutputContext)object6).getMessage().getID(), ((MessageOutputContext)object6).getMessage(), messageException);
                    }
                    ++n;
                }
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " doFire() - exit ");
        }
    }

    protected final boolean areAllInputsFinished() {
        boolean bl = true;
        int n = 0;
        while (n < this.blockingInputFinishRequests.size()) {
            bl = bl && this.blockingInputFinishRequests.get(n) != false;
            ++n;
        }
        n = 0;
        while (n < this.pushingInputFinishRequests.size()) {
            bl = bl && this.pushingInputFinishRequests.get(n) != false;
            ++n;
        }
        return bl;
    }

    protected abstract void process(ActorContext var1, ProcessRequest var2, ProcessResponse var3) throws ProcessingException;

    protected void validateIteration(ActorContext actorContext, ProcessRequest processRequest) throws ValidationException {
    }

    protected boolean mustValidateIteration() {
        try {
            return ((Director)this.getDirector()).mustValidateIteration();
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        Actor actor = (Actor)super.clone(workspace);
        actor.blockingInputHandlers = new ArrayList<PortHandler>();
        actor.blockingInputFinishRequests = new ArrayList<Boolean>();
        actor.pushingInputHandlers = new ArrayList<PortHandler>();
        actor.pushingInputFinishRequests = new ArrayList<Boolean>();
        actor.pushedMessages = new HashMap<String, MessageInputContext>();
        return actor;
    }

    private static class MsgListener
    extends PortListenerAdapter {
        private Actor actor;
        private PortHandler handler;

        MsgListener(Actor actor, PortHandler portHandler) {
            this.actor = actor;
            this.handler = portHandler;
        }

        @Override
        public void noMoreTokens() {
            int n = this.getMyIndex();
            this.actor.pushingInputFinishRequests.set(n, Boolean.TRUE);
        }

        @Override
        public void tokenReceived() {
            Token token = this.handler.getToken();
            try {
                ManagedMessage managedMessage = MessageHelper.getMessageFromToken(token);
                int n = this.getMyIndex();
                MessageInputContext messageInputContext = new MessageInputContext(n, this.handler.getName(), managedMessage);
                this.actor.pushedMessages.put(this.handler.getName(), messageInputContext);
            }
            catch (Exception exception) {
                logger.error("", (Throwable)exception);
            }
        }

        private int getMyIndex() {
            int n = this.actor.pushingInputHandlers.indexOf(this.handler);
            return n;
        }
    }
}

