/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.gui.graph.userlib;

import com.isencia.passerelle.actor.gui.LibraryManager;
import java.awt.Container;
import javax.swing.BoxLayout;
import ptolemy.actor.gui.Configuration;
import ptolemy.gui.Query;
import ptolemy.gui.QueryListener;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.moml.EntityLibrary;
import ptolemy.util.MessageHandler;

public class RenameConfigurer
extends Query
implements ChangeListener,
QueryListener {
    private boolean _changed = false;
    private EntityLibrary library;
    private Configuration _configuration;
    private LibraryManager libraryManager;

    public RenameConfigurer(Configuration configuration, EntityLibrary entityLibrary) {
        this._configuration = configuration;
        this.libraryManager = new LibraryManager(this._configuration);
        this.library = entityLibrary;
        this.addQueryListener(this);
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.setTextWidth(25);
        this.addLine("New name", "New name", entityLibrary.getName());
    }

    public void apply() {
        if (this._changed) {
            String string = this.getStringValue("New name");
            this.libraryManager.renameLibrary(this.library, string);
        }
    }

    public void changeExecuted(ChangeRequest changeRequest) {
    }

    public void changeFailed(ChangeRequest changeRequest, Exception exception) {
        if (changeRequest != null && changeRequest.getSource() != this) {
            return;
        }
        if (changeRequest != null && !changeRequest.isErrorReported()) {
            changeRequest.setErrorReported(true);
            MessageHandler.error((String)"Rename failed: ", (Throwable)exception);
        }
    }

    public void changed(String string) {
        this._changed = true;
    }
}

