/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.gui.graph.userlib;

import com.isencia.passerelle.actor.gui.graph.ModelGraphPanel;
import com.isencia.passerelle.model.util.MoMLParser;
import com.isencia.passerelle.util.EnvironmentUtils;
import com.isencia.util.swing.components.FinderAccessory;
import diva.gui.ExtensionFileFilter;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.EntityLibrary;
import ptolemy.util.MessageHandler;
import ptolemy.vergil.toolbox.FigureAction;

class ImportClassAction
extends FigureAction {
    private static final Logger logger = LoggerFactory.getLogger(ImportClassAction.class);
    private ModelGraphPanel panel;

    public ImportClassAction(ModelGraphPanel modelGraphPanel) {
        super("Import shared actor");
        this.panel = modelGraphPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        NamedObj namedObj = this.getTarget();
        if (namedObj instanceof EntityLibrary) {
            EntityLibrary entityLibrary = (EntityLibrary)namedObj;
            File file = null;
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle("Import shared actor from...");
            jFileChooser.setCurrentDirectory(EnvironmentUtils.getUserRelevantDirectory());
            jFileChooser.setAccessory((JComponent)new FinderAccessory(jFileChooser));
            jFileChooser.addChoosableFileFilter((FileFilter)new ExtensionFileFilter(new String[]{"xml", "moml"}, "Passerelle model files"));
            int n = jFileChooser.showOpenDialog(this.panel);
            if (n == 0) {
                file = jFileChooser.getSelectedFile();
                if (logger.isInfoEnabled()) {
                    logger.info("Importing actor in Library " + entityLibrary.getFullName() + " from " + file.getPath());
                }
                EnvironmentUtils.setLastSelectedDirectory(jFileChooser.getCurrentDirectory());
                MoMLParser moMLParser = new MoMLParser();
                try {
                    Entity entity = (Entity)moMLParser.parse(null, file.toURL());
                    this.panel.getLibraryManager().saveEntityInLibrary(entityLibrary, entity);
                }
                catch (Exception exception) {
                    MessageHandler.error((String)"Failed to load actor", (Throwable)exception);
                }
            }
        } else {
            MessageHandler.error((String)"Selected item is not an actor library");
        }
    }
}

