/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.gui.graph;

import com.isencia.passerelle.actor.gui.GetDocumentationAction;
import com.isencia.passerelle.actor.gui.LibraryManager;
import com.isencia.passerelle.actor.gui.graph.EditorDropTarget;
import com.isencia.passerelle.actor.gui.graph.EditorGraphController;
import com.isencia.passerelle.actor.gui.graph.userlib.AddUserLibraryFolderMenuItemFactory;
import com.isencia.passerelle.actor.gui.graph.userlib.DeleteFromLibraryMenuItemFactory;
import com.isencia.passerelle.actor.gui.graph.userlib.ImportClassInLibraryMenuItemFactory;
import com.isencia.passerelle.actor.gui.graph.userlib.RenameLibraryMenuItemFactory;
import com.isencia.passerelle.core.ControlPort;
import com.isencia.passerelle.core.ErrorPort;
import com.isencia.passerelle.model.util.MoMLParser;
import com.isencia.passerelle.util.EnvironmentUtils;
import diva.canvas.CanvasUtilities;
import diva.canvas.Figure;
import diva.canvas.JCanvas;
import diva.canvas.Site;
import diva.canvas.connector.FixedNormalSite;
import diva.canvas.connector.PerimeterSite;
import diva.canvas.connector.TerminalFigure;
import diva.canvas.event.LayerAdapter;
import diva.canvas.event.LayerEvent;
import diva.canvas.event.LayerListener;
import diva.canvas.interactor.SelectionModel;
import diva.canvas.toolbox.BasicFigure;
import diva.graph.GraphController;
import diva.graph.GraphEvent;
import diva.graph.GraphModel;
import diva.graph.GraphPane;
import diva.graph.GraphUtilities;
import diva.graph.JGraph;
import diva.graph.NodeRenderer;
import diva.gui.GUIUtilities;
import diva.gui.toolbox.JCanvasPanner;
import diva.util.java2d.Polygon2D;
import diva.util.java2d.ShapeUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.UndoableEditListener;
import javax.swing.tree.TreeModel;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.IOPort;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.JNLPUtilities;
import ptolemy.actor.gui.ModelDirectory;
import ptolemy.actor.gui.PtolemyEffigy;
import ptolemy.actor.gui.SizeAttribute;
import ptolemy.data.ArrayToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.Typeable;
import ptolemy.gui.GraphicalMessageHandler;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Port;
import ptolemy.kernel.attributes.URIAttribute;
import ptolemy.kernel.undo.RedoChangeRequest;
import ptolemy.kernel.undo.UndoChangeRequest;
import ptolemy.kernel.undo.UndoStackAttribute;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.BasicModelErrorHandler;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.DebugEvent;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.ModelErrorHandler;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.kernel.util.Workspace;
import ptolemy.moml.EntityLibrary;
import ptolemy.moml.LibraryAttribute;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.util.CancelException;
import ptolemy.util.MessageHandler;
import ptolemy.vergil.actor.ActorGraphModel;
import ptolemy.vergil.basic.AbstractBasicGraphModel;
import ptolemy.vergil.toolbox.MenuItemFactory;
import ptolemy.vergil.tree.EntityTreeModel;
import ptolemy.vergil.tree.PTree;
import ptolemy.vergil.tree.PTreeMenuCreator;
import ptolemy.vergil.tree.VisibleTreeModel;

public class ModelGraphPanel
extends JPanel
implements ClipboardOwner,
ChangeListener,
Printable {
    static final Logger logger = LoggerFactory.getLogger(ModelGraphPanel.class);
    private NamedObj model = null;
    private Effigy effigy = null;
    private EditorGraphController controller = null;
    protected Action _cutAction;
    protected Action _copyAction;
    protected Action _pasteAction;
    private UndoManager undoManager = new UndoManager();
    protected Action _undoAction;
    protected Action _redoAction;
    protected Action _selectAllAction;
    UndoableEditSupport undoableEditSupport = new UndoableEditSupport(this);
    private Action _zoomInAction = new ZoomInAction("Zoom In");
    private Action _zoomResetAction = new ZoomResetAction("Zoom Reset");
    private Action _zoomFitAction = new ZoomFitAction("Zoom Fit");
    private Action _zoomOutAction = new ZoomOutAction("Zoom Out");
    protected EditorDropTarget _dropTarget;
    protected JCanvasPanner _graphPanner;
    protected JGraph _jgraph;
    protected static Color BACKGROUND_COLOR = new Color(0xE5E5E5);
    protected JTree _library;
    protected PTreeMenuCreator _libraryContextMenuCreator;
    protected EntityTreeModel _libraryModel;
    protected JScrollPane _libraryScrollPane;
    protected JPanel _palettePane;
    protected JSplitPane _splitPane;
    protected JToolBar _toolbar;
    protected CompositeEntity _topLibrary;
    LibraryManager libraryManager;
    EntityLibrary usrLibrary;

    public ModelGraphPanel(NamedObj namedObj, PtolemyEffigy ptolemyEffigy) {
        this.model = namedObj;
        this.effigy = ptolemyEffigy;
        this.model.setModelErrorHandler((ModelErrorHandler)new BasicModelErrorHandler());
        List list = this.model.attributeList(UndoStackAttribute.class);
        if (list.size() == 0) {
            try {
                new UndoStackAttribute(this.model, "_undoInfo");
            }
            catch (KernelException kernelException) {
                throw new InternalErrorException((Throwable)kernelException);
            }
        }
        this.libraryManager = new LibraryManager(this.getConfiguration());
        this.setLayout(new BorderLayout());
        namedObj.addChangeListener((ChangeListener)this);
        this.initGUI();
    }

    @Override
    public void setEnabled(boolean bl) {
        Component[] componentArray;
        this._jgraph.getGraphPane().getForegroundEventLayer().setEnabled(bl);
        this._jgraph.getGraphPane().getForegroundLayer().setEnabled(bl);
        this._jgraph.getGraphPane().getBackgroundEventLayer().setEnabled(bl);
        Component[] componentArray2 = componentArray = this._toolbar.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray2[n2];
            component.setEnabled(bl);
            ++n2;
        }
        this._dropTarget.setActive(bl);
    }

    private void initGUI() {
        Parameter parameter;
        Object object;
        GraphPane graphPane = this._createGraphPane();
        graphPane.getForegroundLayer().setPickHalo(2.0);
        this._jgraph = new JGraph(graphPane);
        GraphicalMessageHandler.setContext((Component)this.getDialogHookComponent());
        MessageHandler.setMessageHandler((MessageHandler)new GraphicalMessageHandler());
        this._dropTarget = new EditorDropTarget(this._jgraph, this);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelGraphPanel.this.delete();
            }
        };
        PanMouseListener panMouseListener = new PanMouseListener();
        this._jgraph.addMouseListener((MouseListener)panMouseListener);
        this._jgraph.addMouseMotionListener((MouseMotionListener)panMouseListener);
        this._jgraph.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                int n = mouseWheelEvent.getWheelRotation();
                if (n > 0) {
                    ModelGraphPanel.this.zoom(1.1);
                } else {
                    ModelGraphPanel.this.zoom(0.9);
                }
            }
        });
        this._jgraph.registerKeyboardAction(actionListener, "Delete", KeyStroke.getKeyStroke(127, 0), 2);
        this._jgraph.registerKeyboardAction(actionListener, "BackSpace", KeyStroke.getKeyStroke(8, 0), 2);
        ShowDocumentationAction showDocumentationAction = new ShowDocumentationAction();
        showDocumentationAction.setConfiguration(this.getConfiguration());
        this._jgraph.registerKeyboardAction((ActionListener)((Object)showDocumentationAction), "Ctrl+D", KeyStroke.getKeyStroke(68, 2), 2);
        this._jgraph.setRequestFocusEnabled(true);
        graphPane.getForegroundEventLayer().setConsuming(false);
        graphPane.getForegroundEventLayer().setEnabled(true);
        graphPane.getForegroundEventLayer().addLayerListener((LayerListener)new LayerAdapter(){

            public void mousePressed(LayerEvent layerEvent) {
                Component component = layerEvent.getComponent();
                if (!component.hasFocus()) {
                    component.requestFocus();
                }
            }
        });
        this._jgraph.setAlignmentX(1.0f);
        this._jgraph.setAlignmentY(1.0f);
        try {
            SizeAttribute sizeAttribute = (SizeAttribute)this.getModel().getAttribute("_vergilSize", SizeAttribute.class);
            if (sizeAttribute != null) {
                sizeAttribute.setSize((Component)this._jgraph);
            } else {
                this._jgraph.setMinimumSize(new Dimension(200, 200));
                this._jgraph.setPreferredSize(new Dimension(600, 400));
                this._jgraph.setSize(600, 400);
            }
            object = (Parameter)this.getModel().getAttribute("_vergilZoomFactor", Parameter.class);
            if (object != null) {
                this.zoom(((DoubleToken)object.getToken()).doubleValue());
                object.setVisibility(Settable.EXPERT);
            }
            if ((parameter = (Parameter)this.getModel().getAttribute("_vergilCenter", Parameter.class)) != null) {
                ArrayToken arrayToken = (ArrayToken)parameter.getToken();
                Point2D.Double double_ = new Point2D.Double(((DoubleToken)arrayToken.getElement(0)).doubleValue(), ((DoubleToken)arrayToken.getElement(1)).doubleValue());
                this.setCenter(double_);
                parameter.setVisibility(Settable.EXPERT);
            }
        }
        catch (Exception exception) {}
        this._graphPanner = new JCanvasPanner((JCanvas)this._jgraph);
        this._graphPanner.setPreferredSize(new Dimension(200, 150));
        this._graphPanner.setMaximumSize(new Dimension(200, 150));
        this._graphPanner.setSize(200, 150);
        boolean bl = false;
        try {
            object = EnvironmentUtils.getUserLibraryURL();
            this.usrLibrary = ModelGraphPanel.openLibrary(this.getConfiguration(), (URL)object);
            parameter = (LibraryAttribute)this.getModel().getAttribute("_library", LibraryAttribute.class);
            if (parameter != null) {
                this._topLibrary = parameter.getLibrary();
                bl = true;
            }
        }
        catch (Exception exception) {
            try {
                MessageHandler.warning((String)"Invalid library in the model.", (Throwable)exception);
            }
            catch (CancelException cancelException) {}
        }
        if (!bl) {
            this._topLibrary = this._createDefaultLibrary(this.getModel().workspace());
        }
        this._libraryModel = new VisibleTreeModel(this._topLibrary);
        this._library = new PTree((TreeModel)this._libraryModel);
        this._library.setRootVisible(false);
        this._library.setBackground(BACKGROUND_COLOR);
        this._libraryContextMenuCreator = new PTreeMenuCreator();
        this._libraryContextMenuCreator.addMenuItemFactory((MenuItemFactory)new RenameLibraryMenuItemFactory(this));
        this._libraryContextMenuCreator.addMenuItemFactory((MenuItemFactory)new AddUserLibraryFolderMenuItemFactory(this));
        this._libraryContextMenuCreator.addMenuItemFactory((MenuItemFactory)new DeleteFromLibraryMenuItemFactory(this));
        this._libraryContextMenuCreator.addMenuItemFactory((MenuItemFactory)new ImportClassInLibraryMenuItemFactory(this));
        this._library.addMouseListener((MouseListener)this._libraryContextMenuCreator);
        this._libraryScrollPane = new JScrollPane(this._library);
        this._libraryScrollPane.setMinimumSize(new Dimension(200, 200));
        this._libraryScrollPane.setPreferredSize(new Dimension(200, 200));
        this._palettePane = new JPanel();
        this._palettePane.setBorder(null);
        this._palettePane.setLayout(new BoxLayout(this._palettePane, 1));
        this._palettePane.add((Component)this._libraryScrollPane, "Center");
        this._palettePane.add((Component)this._graphPanner, "South");
        this._splitPane = new JSplitPane(1, true);
        this._splitPane.setLeftComponent(this._palettePane);
        this._splitPane.setRightComponent((Component)this._jgraph);
        this.add((Component)this._splitPane, "Center");
        this.addUndoableEditListener(this.undoManager);
        this._undoAction = new UndoAction();
        this._redoAction = new RedoAction();
        this._copyAction = new CopyAction();
        this._pasteAction = new PasteAction();
        this._cutAction = new CutAction();
        this._selectAllAction = new SelectAllAction();
        this._jgraph.registerKeyboardAction((ActionListener)this._undoAction, "Undo", KeyStroke.getKeyStroke(90, 128), 2);
        this._jgraph.registerKeyboardAction((ActionListener)this._redoAction, "Redo", KeyStroke.getKeyStroke(89, 128), 2);
        this._jgraph.registerKeyboardAction((ActionListener)this._copyAction, "Copy", KeyStroke.getKeyStroke(67, 128), 2);
        this._jgraph.registerKeyboardAction((ActionListener)this._pasteAction, "Paste", KeyStroke.getKeyStroke(86, 128), 2);
        this._jgraph.registerKeyboardAction((ActionListener)this._cutAction, "Cut", KeyStroke.getKeyStroke(88, 128), 2);
        this._jgraph.registerKeyboardAction((ActionListener)this._selectAllAction, "Ctrl+A", KeyStroke.getKeyStroke(65, 2), 2);
        this._toolbar = new JToolBar();
        this.add((Component)this._toolbar, "North");
        GUIUtilities.addToolBarButton((JToolBar)this._toolbar, (Action)this._zoomInAction);
        GUIUtilities.addToolBarButton((JToolBar)this._toolbar, (Action)this._zoomResetAction);
        GUIUtilities.addToolBarButton((JToolBar)this._toolbar, (Action)this._zoomFitAction);
        GUIUtilities.addToolBarButton((JToolBar)this._toolbar, (Action)this._zoomOutAction);
        this._toolbar.addSeparator();
        GUIUtilities.addToolBarButton((JToolBar)this._toolbar, (Action)this._copyAction);
        GUIUtilities.addToolBarButton((JToolBar)this._toolbar, (Action)this._cutAction);
        GUIUtilities.addToolBarButton((JToolBar)this._toolbar, (Action)this._pasteAction);
        this._toolbar.addSeparator();
        GUIUtilities.addToolBarButton((JToolBar)this._toolbar, (Action)this._undoAction);
        GUIUtilities.addToolBarButton((JToolBar)this._toolbar, (Action)this._redoAction);
        this._toolbar.addSeparator();
        GUIUtilities.addToolBarButton((JToolBar)this._toolbar, (Action)this._selectAllAction);
        this.controller.addToMenuAndToolbar(null, this._toolbar);
    }

    protected GraphPane _createGraphPane() {
        logger.debug("create graph pane");
        this.controller = new EditorGraphController(this);
        this.controller.setConfiguration(this.getConfiguration());
        this.controller.getEntityPortController().setNodeRenderer((NodeRenderer)new EntityPortRenderer());
        NamedObj namedObj = this.getModel();
        ActorGraphModel actorGraphModel = new ActorGraphModel(namedObj);
        GraphPane graphPane = new GraphPane((GraphController)this.controller, (GraphModel)actorGraphModel);
        return graphPane;
    }

    public Frame getDialogHookComponent() {
        if (this._jgraph == null) {
            return null;
        }
        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, (Component)this._jgraph);
        return jFrame;
    }

    public void setAnimationDelay(long l) {
        this.controller.setAnimationDelay(l);
    }

    public void event(DebugEvent debugEvent) {
        this.controller.event(debugEvent);
    }

    public NamedObj getModel() {
        return this.model;
    }

    public Effigy getEffigy() {
        return this.effigy;
    }

    public Configuration getConfiguration() {
        NamedObj namedObj = this.getEffigy().toplevel();
        if (namedObj instanceof Configuration) {
            return (Configuration)namedObj;
        }
        logger.warn("No configuration found as top level of model");
        return null;
    }

    public void registerViewFactory(EditorGraphController.ViewFactory viewFactory) {
        this.controller.registerViewFactory(viewFactory);
    }

    public EditorGraphController.ViewFactory getViewFactory() {
        return this.controller.getViewFactory();
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void changeExecuted(ChangeRequest changeRequest) {
        if (this._graphPanner != null) {
            this._graphPanner.repaint();
        }
        if (this.model instanceof EntityLibrary && (changeRequest instanceof MoMLChangeRequest || changeRequest instanceof UndoChangeRequest || changeRequest instanceof RedoChangeRequest)) {
            this.libraryManager.saveChangedEntityLibrary((EntityLibrary)this.model);
        }
    }

    public void changeFailed(ChangeRequest changeRequest, Exception exception) {
        if (changeRequest == null) {
            logger.error("Change failed", (Throwable)exception);
        } else if (!changeRequest.isErrorReported()) {
            changeRequest.setErrorReported(true);
            logger.error("Change failed", (Throwable)exception);
        }
    }

    public void copy() {
        Object object2;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        GraphPane graphPane = this._jgraph.getGraphPane();
        GraphController graphController = graphPane.getGraphController();
        SelectionModel selectionModel = graphController.getSelectionModel();
        GraphModel graphModel = graphController.getGraphModel();
        Object[] objectArray = selectionModel.getSelectionAsArray();
        HashSet<Object> hashSet = new HashSet<Object>();
        HashSet hashSet2 = new HashSet();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof Figure && graphModel.isNode(object2 = ((Figure)objectArray[n]).getUserObject())) {
                hashSet2.add(object2);
                NamedObj object5 = (NamedObj)graphModel.getSemanticObject(object2);
                hashSet.add(object5);
            }
            ++n;
        }
        n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof Figure && graphModel.isEdge(object2 = ((Figure)objectArray[n]).getUserObject())) {
                Object object;
                Object object3 = graphModel.getHead(object2);
                Object object4 = graphModel.getTail(object2);
                boolean bl = hashSet2.contains(object3);
                boolean bl2 = hashSet2.contains(object4);
                Iterator iterator = hashSet2.iterator();
                while (!(bl && bl2 || !iterator.hasNext())) {
                    object = iterator.next();
                    if (!bl && GraphUtilities.isContainedNode((Object)object3, object, (GraphModel)graphModel)) {
                        bl = true;
                    }
                    if (bl2 || !GraphUtilities.isContainedNode((Object)object4, object, (GraphModel)graphModel)) continue;
                    bl2 = true;
                }
                if (bl && bl2) {
                    object = (NamedObj)graphModel.getSemanticObject(object2);
                    hashSet.add(object);
                }
            }
            ++n;
        }
        StringWriter stringWriter = new StringWriter();
        try {
            for (NamedObj namedObj : hashSet) {
                namedObj.exportMoML((Writer)stringWriter, 0);
            }
            NamedObj namedObj = (NamedObj)graphModel.getRoot();
            if (namedObj instanceof CompositeEntity) {
                stringWriter.write(((CompositeEntity)namedObj).exportLinks(1, hashSet));
            }
            clipboard.setContents(new StringSelection(stringWriter.toString()), this);
        }
        catch (Exception exception) {
            MessageHandler.error((String)"Copy failed", (Throwable)exception);
        }
    }

    public void cut() {
        this.copy();
        this.delete();
    }

    public void delete() {
        Object object2;
        this.postUndoableEdit("delete");
        GraphPane graphPane = this._jgraph.getGraphPane();
        GraphController graphController = graphPane.getGraphController();
        SelectionModel selectionModel = graphController.getSelectionModel();
        AbstractBasicGraphModel abstractBasicGraphModel = (AbstractBasicGraphModel)graphController.getGraphModel();
        Object[] objectArray = selectionModel.getSelectionAsArray();
        Object[] objectArray2 = new Object[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            objectArray2[n] = ((Figure)objectArray[n]).getUserObject();
            selectionModel.removeSelection(objectArray[n]);
            ++n;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        StringBuffer stringBuffer = new StringBuffer("<group>\n");
        int n2 = 0;
        while (n2 < objectArray.length) {
            object2 = objectArray2[n2];
            if (abstractBasicGraphModel.isEdge(object2)) {
                NamedObj namedObj = (NamedObj)abstractBasicGraphModel.getSemanticObject(object2);
                if (namedObj == null) {
                    hashSet.add(object2);
                } else {
                    stringBuffer.append(abstractBasicGraphModel.getDeleteEdgeMoML(object2));
                }
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < objectArray.length) {
            object2 = objectArray2[n2];
            if (abstractBasicGraphModel.isNode(object2)) {
                stringBuffer.append(abstractBasicGraphModel.getDeleteNodeMoML(object2));
            }
            ++n2;
        }
        stringBuffer.append("</group>\n");
        try {
            abstractBasicGraphModel.setDispatchEnabled(false);
            for (Object object2 : hashSet) {
                if (!abstractBasicGraphModel.isEdge(object2)) continue;
                abstractBasicGraphModel.disconnectEdge((Object)this, object2);
            }
        }
        finally {
            abstractBasicGraphModel.setDispatchEnabled(true);
        }
        try {
            NamedObj namedObj = abstractBasicGraphModel.getPtolemyModel();
            object2 = new MoMLChangeRequest((Object)this, namedObj, stringBuffer.toString());
            object2.setUndoable(true);
            namedObj.requestChange((ChangeRequest)object2);
        }
        catch (Exception exception) {
            MessageHandler.error((String)("Delete failed, changeRequest was:" + stringBuffer), (Throwable)exception);
        }
        abstractBasicGraphModel.dispatchGraphEvent(new GraphEvent((Object)this, 30, abstractBasicGraphModel.getRoot()));
    }

    public void paste() {
        this.postUndoableEdit("paste");
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        GraphPane graphPane = this._jgraph.getGraphPane();
        GraphController graphController = graphPane.getGraphController();
        GraphModel graphModel = graphController.getGraphModel();
        if (transferable == null) {
            return;
        }
        try {
            NamedObj namedObj = (NamedObj)graphModel.getRoot();
            StringBuffer stringBuffer = new StringBuffer();
            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            string = this.translateFiguresInSegment(string, 20, 20);
            stringBuffer.append("<group name=\"auto\">\n");
            stringBuffer.append(string);
            stringBuffer.append("</group>\n");
            MoMLChangeRequest moMLChangeRequest = new MoMLChangeRequest((Object)this, namedObj, stringBuffer.toString());
            moMLChangeRequest.setUndoable(true);
            namedObj.requestChange((ChangeRequest)moMLChangeRequest);
        }
        catch (Exception exception) {
            MessageHandler.error((String)"Paste failed", (Throwable)exception);
        }
    }

    private String translateFiguresInSegment(String string, int ... nArray) {
        String string2 = string;
        int n = 0;
        while (n >= 0) {
            if ((n = string2.indexOf("_location", n)) < 0) continue;
            int n2 = string2.indexOf("{", n);
            int n3 = string2.indexOf("[", n);
            if (n2 < 0 && n3 < 0) break;
            n = n2 < 0 ? n3 : (n3 < 0 ? n2 : Math.min(n2, n3));
            n2 = string2.indexOf("}", n);
            n3 = string2.indexOf("]", n);
            if (n2 < 0 && n3 < 0) break;
            int n4 = 0;
            n4 = n2 < 0 ? n3 : (n3 < 0 ? n2 : Math.min(n2, n3));
            String string3 = string2.substring(n + 1, n4);
            String[] stringArray = string3.split(",");
            int[] nArray2 = new int[stringArray.length];
            int n5 = 0;
            while (n5 < stringArray.length) {
                String string4 = stringArray[n5].trim();
                nArray2[n5] = Math.round(Float.parseFloat(string4)) + nArray[n5];
                ++n5;
            }
            string2 = String.valueOf(string2.substring(0, n + 1)) + nArray2[0] + "," + nArray2[1] + string2.substring(n4);
            n = n4;
        }
        return string2;
    }

    public void postUndoableEdit(String string) {
        this.undoableEditSupport.postEdit(new UndoableEdit(string));
    }

    public void redo() {
        GraphPane graphPane = this._jgraph.getGraphPane();
        GraphController graphController = graphPane.getGraphController();
        GraphModel graphModel = graphController.getGraphModel();
        try {
            NamedObj namedObj = (NamedObj)graphModel.getRoot();
            RedoChangeRequest redoChangeRequest = new RedoChangeRequest((Object)this, namedObj);
            namedObj.requestChange((ChangeRequest)redoChangeRequest);
        }
        catch (Exception exception) {
            MessageHandler.error((String)"Redo failed", (Throwable)exception);
        }
    }

    public void undo() {
        GraphPane graphPane = this._jgraph.getGraphPane();
        GraphController graphController = graphPane.getGraphController();
        GraphModel graphModel = graphController.getGraphModel();
        try {
            NamedObj namedObj = (NamedObj)graphModel.getRoot();
            UndoChangeRequest undoChangeRequest = new UndoChangeRequest((Object)this, namedObj);
            namedObj.requestChange((ChangeRequest)undoChangeRequest);
        }
        catch (Exception exception) {
            MessageHandler.error((String)"Undo failed", (Throwable)exception);
        }
    }

    public void zoom(double d) {
        JCanvas jCanvas = this._jgraph.getGraphPane().getCanvas();
        AffineTransform affineTransform = jCanvas.getCanvasPane().getTransformContext().getTransform();
        Point2D point2D = this.getCenter();
        affineTransform.scale(d, d);
        jCanvas.getCanvasPane().setTransform(affineTransform);
        this.setCenter(point2D);
        if (this._graphPanner != null) {
            this._graphPanner.repaint();
        }
    }

    public void zoomFit() {
        GraphPane graphPane = this._jgraph.getGraphPane();
        Rectangle2D rectangle2D = graphPane.getForegroundLayer().getLayerBounds();
        if (rectangle2D.isEmpty()) {
            return;
        }
        Rectangle2D rectangle2D2 = this.getVisibleRectangle();
        AffineTransform affineTransform = CanvasUtilities.computeFitTransform((RectangularShape)rectangle2D, (RectangularShape)rectangle2D2);
        JCanvas jCanvas = graphPane.getCanvas();
        jCanvas.getCanvasPane().setTransform(affineTransform);
        if (this._graphPanner != null) {
            this._graphPanner.repaint();
        }
    }

    public void zoomReset() {
        JCanvas jCanvas = this._jgraph.getGraphPane().getCanvas();
        AffineTransform affineTransform = jCanvas.getCanvasPane().getTransformContext().getTransform();
        affineTransform.setToIdentity();
        jCanvas.getCanvasPane().setTransform(affineTransform);
        if (this._graphPanner != null) {
            this._graphPanner.repaint();
        }
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.undoableEditSupport.addUndoableEditListener(undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.undoableEditSupport.removeUndoableEditListener(undoableEditListener);
    }

    public Point2D getCenter() {
        Rectangle2D rectangle2D = this.getVisibleCanvasRectangle();
        return new Point2D.Double(rectangle2D.getCenterX(), rectangle2D.getCenterY());
    }

    public void setCenter(Point2D point2D) {
        Rectangle2D rectangle2D = this.getVisibleCanvasRectangle();
        AffineTransform affineTransform = this._jgraph.getCanvasPane().getTransformContext().getTransform();
        affineTransform.translate(rectangle2D.getCenterX() - point2D.getX(), rectangle2D.getCenterY() - point2D.getY());
        this._jgraph.getCanvasPane().setTransform(affineTransform);
    }

    public Rectangle2D getVisibleCanvasRectangle() {
        AffineTransform affineTransform;
        AffineTransform affineTransform2 = this._jgraph.getCanvasPane().getTransformContext().getTransform();
        try {
            affineTransform = affineTransform2.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new RuntimeException(noninvertibleTransformException.toString());
        }
        Rectangle2D rectangle2D = this.getVisibleRectangle();
        return ShapeUtilities.transformBounds((Rectangle2D)rectangle2D, (AffineTransform)affineTransform);
    }

    public Rectangle2D getVisibleRectangle() {
        Dimension dimension = this._jgraph.getSize();
        return new Rectangle2D.Double(0.0, 0.0, dimension.getWidth(), dimension.getHeight());
    }

    public JGraph getJGraph() {
        return this._jgraph;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (this.getJGraph() != null) {
            Rectangle2D rectangle2D = this.getVisibleRectangle();
            return this.getJGraph().print(graphics, pageFormat, n, rectangle2D);
        }
        return 1;
    }

    public static EntityLibrary openLibrary(Configuration configuration, URL uRL) throws Exception {
        final CompositeEntity compositeEntity = (CompositeEntity)configuration.getEntity("actor library");
        if (compositeEntity == null) {
            return null;
        }
        final ModelDirectory modelDirectory = (ModelDirectory)configuration.getEntity("directory");
        if (modelDirectory == null) {
            return null;
        }
        URL uRL2 = JNLPUtilities.canonicalizeJarURL((URL)uRL);
        String string = uRL2.toExternalForm();
        Effigy effigy = modelDirectory.getEffigy(string);
        if (effigy == null) {
            MoMLParser moMLParser = new MoMLParser(compositeEntity.workspace());
            moMLParser.parse(uRL2, uRL2);
            final PtolemyEffigy ptolemyEffigy = new PtolemyEffigy(modelDirectory.workspace());
            ptolemyEffigy.setSystemEffigy(true);
            final EntityLibrary entityLibrary = (EntityLibrary)moMLParser.getToplevel();
            entityLibrary.setName("UserLibrary");
            ptolemyEffigy.setName(modelDirectory.uniqueName(entityLibrary.getName()));
            ChangeRequest changeRequest = new ChangeRequest(configuration, uRL.toString()){

                protected void _execute() throws Exception {
                    entityLibrary.setContainer(compositeEntity);
                    ptolemyEffigy.setContainer((CompositeEntity)modelDirectory);
                }
            };
            compositeEntity.requestChange(changeRequest);
            changeRequest.waitForCompletion();
            ptolemyEffigy.setModel((NamedObj)entityLibrary);
            URIAttribute uRIAttribute = new URIAttribute((NamedObj)entityLibrary, "_uri");
            uRIAttribute.setURL(uRL2);
            ptolemyEffigy.uri.setURL(uRL2);
            ptolemyEffigy.identifier.setExpression(string);
            return entityLibrary;
        }
        return (EntityLibrary)((PtolemyEffigy)effigy).getModel();
    }

    protected CompositeEntity _createDefaultLibrary(Workspace workspace) {
        Configuration configuration = this.getConfiguration();
        if (configuration != null) {
            CompositeEntity compositeEntity = (CompositeEntity)configuration.getEntity("actor library");
            if (compositeEntity == null) {
                compositeEntity = new CompositeEntity(workspace);
                try {
                    compositeEntity.setName("topLibrary");
                    new Attribute((NamedObj)compositeEntity, "_libraryMarker");
                }
                catch (Exception exception) {
                    throw new InternalErrorException("Library configuration failed: " + exception);
                }
            }
            return compositeEntity;
        }
        return null;
    }

    public LibraryManager getLibraryManager() {
        return this.libraryManager;
    }

    public EntityLibrary getUserLibrary() {
        return this.usrLibrary;
    }

    private class CopyAction
    extends AbstractAction {
        public CopyAction() {
            super("Copy");
            this.putValue("tooltip", "Copy the current selection onto the clipboard. (Ctrl+c)");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("MnemonicKey", 67);
            URL uRL = this.getClass().getResource("copy.png");
            if (uRL != null) {
                ImageIcon imageIcon = new ImageIcon(uRL);
                this.putValue("LargeIcon", imageIcon);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelGraphPanel.this.copy();
        }
    }

    private class CutAction
    extends AbstractAction {
        public CutAction() {
            super("Cut");
            this.putValue("tooltip", "Cut the current selection onto the clipboard. (Ctrl+x)");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("MnemonicKey", 84);
            URL uRL = this.getClass().getResource("cut.png");
            if (uRL != null) {
                ImageIcon imageIcon = new ImageIcon(uRL);
                this.putValue("LargeIcon", imageIcon);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelGraphPanel.this.cut();
        }
    }

    public class EntityPortRenderer
    implements NodeRenderer {
        public Figure render(Object object) {
            final Port port = (Port)object;
            Polygon2D.Double double_ = new Polygon2D.Double();
            double_.moveTo(-3.0, 3.0);
            double_.lineTo(3.0, 0.0);
            double_.lineTo(-3.0, -3.0);
            double_.closePath();
            Color color = port instanceof ErrorPort ? Color.red : (port instanceof ControlPort ? Color.blue : (port instanceof IOPort && ((IOPort)port).isMultiport() ? Color.white : Color.black));
            BasicFigure basicFigure = new BasicFigure((Shape)double_, color, 1.5f){

                public String getToolTipText() {
                    String string = port.getName();
                    StringAttribute stringAttribute = (StringAttribute)port.getAttribute("_explanation");
                    if (stringAttribute != null) {
                        string = stringAttribute.getExpression();
                    } else if (port instanceof Typeable) {
                        try {
                            string = String.valueOf(string) + ", type:" + ((Typeable)port).getType();
                        }
                        catch (IllegalActionException illegalActionException) {}
                    }
                    return string;
                }
            };
            basicFigure.setToolTipText(port.getName());
            int n = !(port instanceof IOPort) ? 5 : (((IOPort)port).isInput() && ((IOPort)port).isOutput() ? 5 : (((IOPort)port).isInput() ? 7 : (((IOPort)port).isOutput() ? 3 : 5)));
            double d = CanvasUtilities.getNormal((int)n);
            PerimeterSite perimeterSite = new PerimeterSite((Figure)basicFigure, 0);
            perimeterSite.setNormal(d);
            perimeterSite = new FixedNormalSite((Site)perimeterSite);
            basicFigure = new TerminalFigure((Figure)basicFigure, (Site)perimeterSite);
            return basicFigure;
        }
    }

    private class PanMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private int startX;
        private int startY;

        private PanMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.startX = mouseEvent.getX();
            this.startY = mouseEvent.getY();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (ModelGraphPanel.this._jgraph != null && (mouseEvent.getModifiers() & 8) != 0) {
                this.setPosition(mouseEvent.getX(), mouseEvent.getY());
                this.startX = mouseEvent.getX();
                this.startY = mouseEvent.getY();
            }
        }

        public void setPosition(int n, int n2) {
            AffineTransform affineTransform = ModelGraphPanel.this._jgraph.getCanvasPane().getTransformContext().getTransform();
            new Point2D.Double(n, n2);
            affineTransform.translate(n - this.startX, n2 - this.startY);
            ModelGraphPanel.this._jgraph.getCanvasPane().setTransform(affineTransform);
        }
    }

    private class PasteAction
    extends AbstractAction {
        public PasteAction() {
            super("Paste");
            this.putValue("tooltip", "Paste the contents of the clipboard. (Ctrl+v)");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("MnemonicKey", 80);
            URL uRL = this.getClass().getResource("paste.png");
            if (uRL != null) {
                ImageIcon imageIcon = new ImageIcon(uRL);
                this.putValue("LargeIcon", imageIcon);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelGraphPanel.this.paste();
        }
    }

    private class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo");
            this.putValue("tooltip", "Redo the last change undone. (Ctrl+y)");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("MnemonicKey", 82);
            URL uRL = this.getClass().getResource("redo.png");
            if (uRL != null) {
                ImageIcon imageIcon = new ImageIcon(uRL);
                this.putValue("LargeIcon", imageIcon);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelGraphPanel.this.redo();
        }
    }

    public class SelectAllAction
    extends AbstractAction {
        public SelectAllAction() {
            super("select all");
            URL uRL = this.getClass().getResource("selectall.png");
            if (uRL != null) {
                ImageIcon imageIcon = new ImageIcon(uRL);
                this.putValue("LargeIcon", imageIcon);
            }
            this.putValue("tooltip", "select all (Ctrl+A)");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelGraphPanel.this.controller.selectAll();
        }
    }

    public class ShowDocumentationAction
    extends GetDocumentationAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Figure figure = ModelGraphPanel.this.controller.getGraphPane().getForegroundLayer().getCurrentFigure();
            NamedObj namedObj = null;
            while (namedObj == null && figure != null) {
                Object object = figure;
                if (object instanceof Figure) {
                    object = figure.getUserObject();
                }
                namedObj = (NamedObj)ModelGraphPanel.this.controller.getGraphModel().getSemanticObject(object);
                figure = figure.getParent();
            }
            try {
                this.showDocumentation(namedObj, (Effigy)ModelGraphPanel.this.controller._getEffigy(namedObj, this._configuration));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public Frame getFrame() {
            return ModelGraphPanel.this.getDialogHookComponent();
        }

        public void showDocumentation(NamedObj namedObj, Effigy effigy) {
            if (this._configuration == null) {
                MessageHandler.error((String)"Cannot get documentation without a configuration.");
            }
            String string = namedObj.getClass().getName();
            this.getDocumentation(this._configuration, string, effigy);
        }
    }

    private class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo");
            this.putValue("tooltip", "Undo the last change. (Ctrl+z)");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("MnemonicKey", 85);
            URL uRL = this.getClass().getResource("undo.png");
            if (uRL != null) {
                ImageIcon imageIcon = new ImageIcon(uRL);
                this.putValue("LargeIcon", imageIcon);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelGraphPanel.this.undo();
        }
    }

    public class UndoableEdit
    extends AbstractUndoableEdit {
        private String changeMsg = "";

        public UndoableEdit(String string) {
            this.changeMsg = string;
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            ModelGraphPanel.this.redo();
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            ModelGraphPanel.this.undo();
        }

        @Override
        public String getPresentationName() {
            return this.changeMsg;
        }

        @Override
        public String getRedoPresentationName() {
            return " " + this.getPresentationName();
        }

        @Override
        public String getUndoPresentationName() {
            return " " + this.getPresentationName();
        }
    }

    public class ZoomFitAction
    extends AbstractAction {
        public ZoomFitAction(String string) {
            super(string);
            URL uRL = this.getClass().getResource("/ptolemy/vergil/basic/img/zoomfit.gif");
            if (uRL != null) {
                ImageIcon imageIcon = new ImageIcon(uRL);
                this.putValue("LargeIcon", imageIcon);
            }
            this.putValue("tooltip", String.valueOf(string) + " (Ctrl+Shift+-)");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(45, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelGraphPanel.this.zoomFit();
        }
    }

    public class ZoomInAction
    extends AbstractAction {
        public ZoomInAction(String string) {
            super(string);
            URL uRL = this.getClass().getResource("/ptolemy/vergil/basic/img/zoomin.gif");
            if (uRL != null) {
                ImageIcon imageIcon = new ImageIcon(uRL);
                this.putValue("LargeIcon", imageIcon);
            }
            this.putValue("tooltip", String.valueOf(string) + " (Ctrl+Shift+=)");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(61, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelGraphPanel.this.zoom(1.25);
        }
    }

    public class ZoomOutAction
    extends AbstractAction {
        public ZoomOutAction(String string) {
            super(string);
            URL uRL = this.getClass().getResource("/ptolemy/vergil/basic/img/zoomout.gif");
            if (uRL != null) {
                ImageIcon imageIcon = new ImageIcon(uRL);
                this.putValue("LargeIcon", imageIcon);
            }
            this.putValue("tooltip", String.valueOf(string) + " (Ctrl+-)");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(45, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelGraphPanel.this.zoom(0.8);
        }
    }

    public class ZoomResetAction
    extends AbstractAction {
        public ZoomResetAction(String string) {
            super(string);
            URL uRL = this.getClass().getResource("/ptolemy/vergil/basic/img/zoomreset.gif");
            if (uRL != null) {
                ImageIcon imageIcon = new ImageIcon(uRL);
                this.putValue("LargeIcon", imageIcon);
            }
            this.putValue("tooltip", String.valueOf(string) + " (Ctrl+=)");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(61, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelGraphPanel.this.zoomReset();
        }
    }
}

