/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.gui.graph;

import com.isencia.passerelle.actor.gui.graph.ModelGraphPanel;
import diva.canvas.Figure;
import diva.canvas.FigureLayer;
import diva.graph.GraphPane;
import diva.graph.JGraph;
import diva.util.UserObjectContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.TooManyListenersException;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.ToolTipManager;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.gui.GraphicalMessageHandler;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.Location;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Singleton;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.util.MessageHandler;
import ptolemy.vergil.kernel.AnimationRenderer;
import ptolemy.vergil.toolbox.PtolemyTransferable;
import ptolemy.vergil.toolbox.SnapConstraint;

public class EditorDropTarget
extends DropTarget {
    private ModelGraphPanel parentPanel;
    private boolean _dropIntoEnabled = true;

    public EditorDropTarget(JGraph jGraph, ModelGraphPanel modelGraphPanel) {
        this.parentPanel = modelGraphPanel;
        this.setComponent((Component)jGraph);
        try {
            this.addDropTargetListener(new DTListener());
        }
        catch (TooManyListenersException tooManyListenersException) {}
    }

    public boolean isDropIntoEnabled() {
        return this._dropIntoEnabled;
    }

    public void setDropIntoEnabled(boolean bl) {
        this._dropIntoEnabled = bl;
    }

    private class DTListener
    implements DropTargetListener {
        private NamedObj _highlighted = null;
        private Figure _highlightedFigure = null;
        private AnimationRenderer _highlighter = null;

        private DTListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (dropTargetDragEvent.isDataFlavorSupported(PtolemyTransferable.namedObjFlavor)) {
                dropTargetDragEvent.acceptDrag(3);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
            if (this._highlighted != null) {
                this._highlighter.renderDeselected(this._highlightedFigure);
                this._highlighted = null;
                this._highlightedFigure = null;
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            Point2D point2D = SnapConstraint.constrainPoint((Point2D)dropTargetDragEvent.getLocation());
            NamedObj namedObj = this._getObjectUnder(point2D);
            if (namedObj != this._highlighted) {
                if (this._highlighted != null) {
                    this._highlighter.renderDeselected(this._highlightedFigure);
                    this._highlighted = null;
                    this._highlightedFigure = null;
                }
                if (namedObj != null && EditorDropTarget.this._dropIntoEnabled) {
                    if (this._highlighter == null) {
                        this._highlighter = new AnimationRenderer(Color.white);
                    }
                    this._highlighted = namedObj;
                    this._highlightedFigure = this._getFigureUnder(point2D);
                    this._highlighter.renderSelected(this._highlightedFigure);
                }
            }
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            Object object;
            NamedObj namedObj;
            Object object2;
            Object object3;
            if (this._highlighted != null) {
                this._highlighter.renderDeselected(this._highlightedFigure);
                this._highlighted = null;
                this._highlightedFigure = null;
            }
            Point2D point2D = SnapConstraint.constrainPoint((Point2D)dropTargetDropEvent.getLocation());
            NamedObj namedObj2 = this._getObjectUnder(point2D);
            GraphPane graphPane = ((JGraph)EditorDropTarget.this.getComponent()).getGraphPane();
            if (namedObj2 == null || !EditorDropTarget.this._dropIntoEnabled) {
                object3 = graphPane.getGraphController();
                object2 = object3.getGraphModel();
                namedObj2 = (NamedObj)object2.getRoot();
            }
            object3 = new Point2D.Double();
            graphPane.getTransformContext().getInverseTransform().transform(point2D, (Point2D)object3);
            object2 = null;
            if (dropTargetDropEvent.isDataFlavorSupported(PtolemyTransferable.namedObjFlavor)) {
                try {
                    dropTargetDropEvent.acceptDrop(3);
                    object2 = (Iterator)dropTargetDropEvent.getTransferable().getTransferData(PtolemyTransferable.namedObjFlavor);
                }
                catch (Exception exception) {
                    MessageHandler.error((String)("Can't find a supported data flavor for drop in " + dropTargetDropEvent), (Throwable)exception);
                    return;
                }
            } else {
                dropTargetDropEvent.rejectDrop();
            }
            if (object2 == null) {
                return;
            }
            EditorDropTarget.this.parentPanel.postUndoableEdit("model change");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<group>");
            while (object2.hasNext()) {
                Object[] objectArray;
                namedObj = (NamedObj)object2.next();
                if (namedObj instanceof Director) {
                    String[] stringArray;
                    if (namedObj2.getContainer() != null) {
                        object = GraphicalMessageHandler.getContext();
                        objectArray = new Object[]{"Ok"};
                        stringArray = new String[]{"A submodel can not have its own Director.", "Place your desired Director in the toplevel model."};
                        JOptionPane.showOptionDialog((Component)object, stringArray, "Info", 0, 1, null, objectArray, objectArray[0]);
                        continue;
                    }
                    if (((CompositeActor)namedObj2).getDirector() != null) {
                        object = GraphicalMessageHandler.getContext();
                        objectArray = new Object[]{"Ok"};
                        stringArray = new String[]{"A model can only have one Director.", "Please first remove the existing Director,", "before adding a new one."};
                        JOptionPane.showOptionDialog((Component)object, stringArray, "Info", 0, 1, null, objectArray, objectArray[0]);
                        continue;
                    }
                }
                object = namedObj instanceof Singleton ? namedObj.getName() : namedObj2.uniqueName(namedObj.getName());
                objectArray = SnapConstraint.constrainPoint((Point2D)object3);
                stringBuffer.append(namedObj.exportMoML((String)object));
                stringBuffer.append("<" + namedObj.getElementName() + " name=\"" + (String)object + "\">\n");
                stringBuffer.append("<property name=\"_location\" class=\"ptolemy.kernel.util.Location\" value=\"{");
                stringBuffer.append((int)objectArray.getX());
                stringBuffer.append(", ");
                stringBuffer.append((int)objectArray.getY());
                stringBuffer.append("}\"/>\n</" + namedObj.getElementName() + ">\n");
            }
            stringBuffer.append("</group>");
            namedObj = new MoMLChangeRequest((Object)this, namedObj2, stringBuffer.toString());
            namedObj.setUndoable(true);
            namedObj2.requestChange((ChangeRequest)namedObj);
            dropTargetDropEvent.dropComplete(true);
            object = (JComponent)EditorDropTarget.this.getComponent();
            if (object != null) {
                ToolTipManager.sharedInstance().registerComponent((JComponent)object);
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        private Figure _getFigureUnder(Point2D point2D) {
            GraphPane graphPane = ((JGraph)EditorDropTarget.this.getComponent()).getGraphPane();
            Point2D.Double double_ = new Point2D.Double();
            graphPane.getTransformContext().getInverseTransform().transform(point2D, double_);
            FigureLayer figureLayer = graphPane.getForegroundLayer();
            double d = figureLayer.getPickHalo();
            double d2 = d * 2.0;
            Rectangle2D.Double double_2 = new Rectangle2D.Double(((Point2D)double_).getX() - d, ((Point2D)double_).getY() - d, d2, d2);
            Figure figure = figureLayer.pick((Rectangle2D)double_2);
            Object object = null;
            while (figure instanceof UserObjectContainer && object == null) {
                object = ((UserObjectContainer)figure).getUserObject();
                if (object instanceof NamedObj && figure instanceof Figure) {
                    return figure;
                }
                figure = figure.getParent();
            }
            return null;
        }

        private NamedObj _getObjectUnder(Point2D point2D) {
            Figure figure = this._getFigureUnder(point2D);
            if (figure == null) {
                return null;
            }
            Object object = figure.getUserObject();
            if (object instanceof Location) {
                return ((NamedObj)object).getContainer();
            }
            if (object instanceof NamedObj) {
                return (NamedObj)object;
            }
            return null;
        }
    }
}

