/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.gui.graph;

import java.awt.Container;
import javax.swing.BoxLayout;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.PtolemyPreferences;
import ptolemy.data.BooleanToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.gui.Query;
import ptolemy.gui.QueryListener;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.NamedObj;
import ptolemy.util.MessageHandler;

public class EditPreferencesConfigurer
extends Query
implements ChangeListener,
QueryListener {
    private static final String PARAMETERS_CHECK_BOX = "parametersCheckBox";
    private static final String PORT_NAMES_CHECK_BOX = "portNamesCheckBox";
    private PtolemyPreferences preferences = null;
    private Parameter showPortNamesParameter;
    private StringParameter showParametersParameter;

    public EditPreferencesConfigurer(Configuration configuration) {
        this.addQueryListener(this);
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        try {
            this.preferences = PtolemyPreferences.getPtolemyPreferencesWithinConfiguration((Configuration)configuration);
            this.showPortNamesParameter = (Parameter)this.preferences.getAttribute("_showPortNames");
            if (this.showPortNamesParameter == null) {
                this.showPortNamesParameter = new Parameter((NamedObj)this.preferences, "_showPortNames");
                this.showPortNamesParameter.setToken((Token)new BooleanToken(false));
            }
            this.showParametersParameter = (StringParameter)this.preferences.getAttribute("_showParameters");
            this.addCheckBox(PORT_NAMES_CHECK_BOX, "Show port names", ((BooleanToken)this.showPortNamesParameter.getToken()).booleanValue());
            this.addCheckBox(PARAMETERS_CHECK_BOX, "Show parameters", "All".equals(this.showParametersParameter.getExpression()));
        }
        catch (Exception exception) {
            MessageHandler.error((String)"Error reading preferences", (Throwable)exception);
        }
    }

    public void apply() {
        try {
            boolean bl = this.getBooleanValue(PORT_NAMES_CHECK_BOX);
            boolean bl2 = this.getBooleanValue(PARAMETERS_CHECK_BOX);
            if (bl2) {
                this.showParametersParameter.setToken((Token)new StringToken("All"));
            } else {
                this.showParametersParameter.setToken((Token)new StringToken("None"));
            }
            this.showPortNamesParameter.setToken((Token)new BooleanToken(bl));
            this.preferences.setAsDefault();
            this.preferences.save();
        }
        catch (Exception exception) {
            MessageHandler.error((String)"Error setting preferences", (Throwable)exception);
        }
    }

    public void changeExecuted(ChangeRequest changeRequest) {
    }

    public void changeFailed(ChangeRequest changeRequest, Exception exception) {
        if (changeRequest != null && changeRequest.getSource() != this) {
            return;
        }
        if (changeRequest != null && !changeRequest.isErrorReported()) {
            changeRequest.setErrorReported(true);
            MessageHandler.error((String)"Preferences change failed: ", (Throwable)exception);
        }
    }

    public void changed(String string) {
    }
}

