/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.gui;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.actor.gui.IPasserelleComponent;
import com.isencia.passerelle.actor.gui.IPasserelleComponentCloseListener;
import com.isencia.passerelle.actor.gui.IPasserelleQuery;
import com.isencia.passerelle.actor.gui.PasserelleEditorFactory;
import com.isencia.passerelle.actor.gui.binding.ParameterToWidgetBinder;
import com.isencia.passerelle.model.util.MoMLParser;
import com.isencia.passerelle.util.ptolemy.DateTimeParameter;
import com.isencia.passerelle.util.ptolemy.ParameterGroup;
import com.isencia.util.swing.calendar.DateTimeSelector;
import com.isencia.util.swing.components.FinderAccessory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.gui.ColorAttribute;
import ptolemy.actor.gui.EditorFactory;
import ptolemy.actor.gui.PtolemyQuery;
import ptolemy.actor.gui.style.ParameterEditorStyle;
import ptolemy.actor.parameters.IntRangeParameter;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.FileParameter;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.Variable;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.gui.ComponentDialog;
import ptolemy.gui.Query;
import ptolemy.kernel.attributes.URIAttribute;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.moml.ErrorHandler;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.util.MessageHandler;

public class PasserelleQuery
extends PtolemyQuery
implements IPasserelleQuery,
IPasserelleComponent {
    private static final String NEW_NAME_FIELDLABEL = "New name";
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(PasserelleQuery.class);
    private QueryLabelProvider labelProvider;
    private boolean nameChanged;
    private ComponentDialog _dialog;
    private NamedObj _handler;
    private boolean _isOpenErrorWindow = false;
    private PasserelleQuery _query = null;
    private Map _revertValue = new HashMap();
    private ErrorHandler _savedErrorHandler = null;
    private static Color _STRING_MODE_BACKGROUND_COLOR = new Color(230, 255, 255, 255);

    public PasserelleQuery(NamedObj namedObj) {
        this(namedObj, null);
    }

    public PasserelleQuery(NamedObj namedObj, QueryLabelProvider queryLabelProvider) {
        this(namedObj, queryLabelProvider, true);
    }

    public PasserelleQuery(NamedObj namedObj, QueryLabelProvider queryLabelProvider, boolean bl) {
        super(namedObj);
        this.labelProvider = queryLabelProvider;
        this._handler = namedObj;
        if (this._handler != null) {
            if (bl) {
                this.addLine(NEW_NAME_FIELDLABEL, NEW_NAME_FIELDLABEL, namedObj.getName());
            }
            this._handler.addChangeListener((ChangeListener)this);
            if (Actor.class.isInstance(this._handler)) {
                this.configureParameters((Actor)this._handler);
            }
        }
    }

    private void configureParameters(Actor actor) {
        List list = actor.attributeList(Parameter.class);
        if (actor.getOptionsFactory() != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                actor.getOptionsFactory().setOptionsForParameter((Parameter)iterator.next());
            }
        }
    }

    public void changed(String string) {
        if (NEW_NAME_FIELDLABEL.equals(string)) {
            this.nameChanged = true;
        }
        super.changed(string);
    }

    public void valueChanged(Settable settable) {
    }

    public void setEnabled(boolean bl) {
        for (String string : this._entries.keySet()) {
            this.setEnabled(string, bl);
        }
    }

    public void addStyledEntry(Settable settable) {
        String string;
        Object object;
        Object object2;
        boolean bl = false;
        if (settable instanceof NamedObj) {
            object2 = ((NamedObj)settable).attributeList(ParameterEditorStyle.class).iterator();
            while (object2.hasNext() && !bl) {
                object = (ParameterEditorStyle)object2.next();
                try {
                    object.addEntry((PtolemyQuery)this);
                    bl = true;
                }
                catch (IllegalActionException illegalActionException) {}
            }
        }
        object2 = settable.getName();
        Object object3 = object = this.labelProvider != null ? this.labelProvider.getLabelFor(settable) : object2;
        if (!bl) {
            try {
                if (settable.getVisibility() == Settable.NOT_EDITABLE) {
                    string = settable.getExpression();
                    this.addDisplay((String)object2, (String)object, string);
                    this.attachParameter(settable, (String)object2);
                    bl = true;
                } else if (settable instanceof IntRangeParameter) {
                    int n = ((IntRangeParameter)settable).getCurrentValue();
                    int n2 = ((IntRangeParameter)settable).getMinValue();
                    int n3 = ((IntRangeParameter)settable).getMaxValue();
                    this.addSlider((String)object2, (String)object, n, n2, n3);
                    this.attachParameter(settable, (String)object2);
                    bl = true;
                } else if (settable instanceof ColorAttribute) {
                    this.addColorChooser((String)object2, (String)object, settable.getExpression());
                    this.attachParameter(settable, (String)object2);
                    bl = true;
                } else if (settable instanceof FileParameter) {
                    Object object4;
                    File file = null;
                    FileFilter fileFilter = null;
                    URI uRI = null;
                    File file2 = ((FileParameter)settable).asFile();
                    if (file2 != null) {
                        file = file2;
                    }
                    if (file == null && (object4 = URIAttribute.getModelURI((NamedObj)((NamedObj)settable))) != null && ((URI)object4).getScheme().equals("file")) {
                        File file3 = new File((URI)object4);
                        file = file3.getParentFile();
                    }
                    if (file != null) {
                        uRI = file.toURI();
                    }
                    if (settable instanceof com.isencia.passerelle.util.ptolemy.FileParameter) {
                        object4 = (com.isencia.passerelle.util.ptolemy.FileParameter)settable;
                        fileFilter = ((com.isencia.passerelle.util.ptolemy.FileParameter)((Object)object4)).getFilter();
                    }
                    this.addFileChooser((String)object2, (String)object, settable.getExpression(), uRI, file, fileFilter, PasserelleQuery.preferredBackgroundColor((Object)settable), PasserelleQuery.preferredForegroundColor((Object)settable));
                    this.attachParameter(settable, (String)object2);
                    bl = true;
                } else if (settable instanceof DateTimeParameter) {
                    this.addDatePicker((String)object2, (String)object, ((DateTimeParameter)settable).getDateValue(), Color.ORANGE, PasserelleQuery.preferredForegroundColor((Object)settable));
                    this.attachParameter(settable, (String)object2);
                    bl = true;
                } else if (settable instanceof ParameterGroup) {
                    this.addParameterGroupButton((String)object2, (String)object, (ParameterGroup)settable);
                    bl = true;
                } else if (settable instanceof Parameter && ((Parameter)settable).getChoices() != null) {
                    Parameter parameter = (Parameter)settable;
                    this.addChoice((String)object2, (String)object, parameter.getChoices(), parameter.getExpression(), true, PasserelleQuery.preferredBackgroundColor((Object)settable), PasserelleQuery.preferredForegroundColor((Object)settable));
                    this.attachParameter(settable, (String)object2);
                    bl = true;
                } else if (settable instanceof Variable) {
                    Type type = ((Variable)settable).getDeclaredType();
                    Token token = ((Variable)settable).getToken();
                    if (type == BaseType.BOOLEAN && (settable.getExpression().equals("true") || settable.getExpression().equals("false"))) {
                        this.addCheckBox((String)object2, (String)object, ((BooleanToken)token).booleanValue());
                        this.attachParameter(settable, (String)object2);
                        bl = true;
                    }
                }
            }
            catch (IllegalActionException illegalActionException) {}
        }
        if ((string = settable.getExpression()) == null) {
            string = "";
        }
        if (!bl) {
            this.addLine((String)object2, (String)object, string, PasserelleQuery.preferredBackgroundColor((Object)settable), PasserelleQuery.preferredForegroundColor((Object)settable));
            this.attachParameter(settable, (String)object2);
        }
    }

    public void addFileChooser(String string, String string2, String string3, URI uRI, File file, FileFilter fileFilter, Color color, Color color2) {
        JLabel jLabel = new JLabel(String.valueOf(string2) + ": ");
        jLabel.setBackground(this._background);
        QueryFileChooser queryFileChooser = new QueryFileChooser(string, string3, uRI, file, fileFilter, color, color2);
        this._addPair(string, jLabel, queryFileChooser, queryFileChooser);
    }

    private void addParameterGroupButton(String string, String string2, ParameterGroup parameterGroup) {
        JLabel jLabel = new JLabel(String.valueOf(string2) + ": ");
        jLabel.setBackground(this._background);
        ParameterGroupButton parameterGroupButton = new ParameterGroupButton(string, string2, parameterGroup);
        this._addPair(string, jLabel, parameterGroupButton, parameterGroupButton);
    }

    private void addDatePicker(String string, String string2, Date date, Color color, Color color2) {
        JLabel jLabel = new JLabel(String.valueOf(string2) + ": ");
        jLabel.setBackground(this._background);
        QueryDatePicker queryDatePicker = new QueryDatePicker(string, string2, date, color, color2);
        this._addPair(string, jLabel, (Component)((Object)queryDatePicker), (Object)queryDatePicker);
    }

    @Override
    public String getStringValue(String string) throws NoSuchElementException, IllegalArgumentException {
        Object v = this._entries.get(string);
        if (v == null) {
            throw new NoSuchElementException("No item named \"" + string + " \" in the query box.");
        }
        if (v instanceof QueryDatePicker) {
            String string2 = ((QueryDatePicker)((Object)v)).getDateTimeAsString();
            if (logger.isDebugEnabled()) {
                logger.debug(String.valueOf(((QueryDatePicker)((Object)v)).getName()) + " has value " + string2);
            }
            return string2;
        }
        if (v instanceof ParameterGroupButton) {
            return "";
        }
        if (v instanceof QueryFileChooser) {
            return ((QueryFileChooser)v).getSelectedFileName();
        }
        try {
            return super.getStringValue(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            char[] cArray = super.getCharArrayValue(string);
            return new String(cArray);
        }
    }

    @Override
    public void setStringValue(String string, String string2) {
        this.set(string, string2);
    }

    public final void set(String string, String string2) throws NoSuchElementException, IllegalArgumentException {
        try {
            super.set(string, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void windowClosed(Window window, String string) {
        super.windowClosed(window, string);
        if (this.nameChanged && !"Cancel".equals(string)) {
            this.applyNameChange();
        }
    }

    private void applyNameChange() {
        String string = this.getStringValue(NEW_NAME_FIELDLABEL);
        NamedObj namedObj = this._handler.getContainer();
        String string2 = this._handler.getName();
        StringBuffer stringBuffer = new StringBuffer("<");
        String string3 = this._handler.getElementName();
        stringBuffer.append(string3);
        stringBuffer.append(" name=\"");
        stringBuffer.append(string2);
        stringBuffer.append("\">");
        if (!string2.equals(string)) {
            stringBuffer.append("<rename name=\"");
            stringBuffer.append(string);
            stringBuffer.append("\"/>");
        }
        stringBuffer.append("</");
        stringBuffer.append(string3);
        stringBuffer.append(">");
        RenameRequest renameRequest = new RenameRequest(this, namedObj, stringBuffer.toString(), string2, string);
        renameRequest.addChangeListener((ChangeListener)this);
        renameRequest.setUndoable(true);
        namedObj.requestChange((ChangeRequest)renameRequest);
        this.nameChanged = false;
    }

    public void changeExecuted(ChangeRequest changeRequest) {
        super.changeExecuted(changeRequest);
    }

    public void changeFailed(final ChangeRequest changeRequest, Exception exception) {
        if (changeRequest == null || changeRequest.getSource() != this) {
            return;
        }
        if (this._savedErrorHandler != null) {
            MoMLParser.setErrorHandler(this._savedErrorHandler);
        }
        if (changeRequest != null && !changeRequest.isErrorReported() && changeRequest instanceof RenameRequest) {
            changeRequest.setErrorReported(true);
            MessageHandler.error((String)"Rename failed: ", (Throwable)exception);
        } else if (this._isOpenErrorWindow) {
            this.setMessage(String.valueOf(exception.getMessage()) + "\n\nPlease enter a new value (or cancel to revert):");
        } else {
            int n;
            if (changeRequest.isErrorReported()) {
                return;
            }
            changeRequest.setErrorReported(true);
            this._query = new PasserelleQuery(this._handler, this.labelProvider);
            this._query.setTextWidth(this.getTextWidth());
            this._query._isOpenErrorWindow = true;
            String string = changeRequest.getDescription();
            this._query.setMessage(String.valueOf(exception.getMessage()) + "\n\nPlease enter a new value:");
            String string2 = string;
            int n2 = string.lastIndexOf("<property name=\"");
            if (n2 >= 0 && (n = string.indexOf("\"", n2 + 16)) > n2 + 15) {
                string2 = string.substring(n2 + 16, n);
            }
            final String string3 = string2;
            final Settable settable = (Settable)this._attributes.get(string3);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (settable == null) {
                        throw new InternalErrorException("Expected attribute attached to entry name: " + string3);
                    }
                    PasserelleQuery.this._query.addStyledEntry(settable);
                    PasserelleQuery.this._dialog = new ComponentDialog(JOptionPane.getFrameForComponent((Component)((Object)PasserelleQuery.this)), "Error", (Component)((Object)PasserelleQuery.this._query), null);
                    PasserelleQuery.this._query._isOpenErrorWindow = false;
                    if (PasserelleQuery.this._dialog.buttonPressed().equals("Cancel")) {
                        if (PasserelleQuery.this._revertValue.containsKey(string3)) {
                            String string = (String)PasserelleQuery.this._revertValue.get(string3);
                            PasserelleQuery.this.set(((NamedObj)settable).getName(), string);
                            PasserelleQuery.this.changed(string3);
                        }
                    } else {
                        try {
                            settable.validate();
                        }
                        catch (IllegalActionException illegalActionException) {
                            changeRequest.setErrorReported(false);
                            PasserelleQuery.this.changeFailed(changeRequest, (Exception)((Object)illegalActionException));
                        }
                    }
                }
            });
        }
    }

    @Override
    public boolean hasAutoSync() {
        return true;
    }

    public void closed(String string) {
    }

    @Override
    public IPasserelleComponent getPasserelleComponent() {
        return this;
    }

    @Override
    public void addListener(IPasserelleComponentCloseListener iPasserelleComponentCloseListener) {
    }

    @Override
    public Set<ParameterToWidgetBinder> getParameterBindings() {
        return Collections.EMPTY_SET;
    }

    class ParameterGroupButton
    extends Box {
        private EditorFactory dlgFactory;
        private final ParameterGroup parameterGroup;

        public ParameterGroupButton(String string, String string2, ParameterGroup parameterGroup) {
            super(0);
            this.dlgFactory = null;
            this.parameterGroup = parameterGroup;
            try {
                this.dlgFactory = new PasserelleEditorFactory((NamedObj)parameterGroup, "_editorFactory");
            }
            catch (NameDuplicationException nameDuplicationException) {
                this.dlgFactory = (EditorFactory)parameterGroup.getAttribute("_editorFactory");
            }
            catch (Exception exception) {
                logger.error("Error initializing ParameterGroupButton", (Throwable)exception);
            }
            JButton jButton = new JButton("...");
            jButton.setPreferredSize(new Dimension(15, 20));
            this.add(jButton);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ParameterGroupButton.this.dlgFactory.createEditor((NamedObj)ParameterGroupButton.this.parameterGroup, null);
                }
            });
        }
    }

    class QueryDatePicker
    extends DateTimeSelector {
        private boolean allowChangeNotifications = false;

        public QueryDatePicker(String string, String string2, Date date, Color color, Color color2) {
            this.init();
            this.setName(string);
            if (date == null) {
                date = new Date();
            }
            this.setDate(date);
            this.allowChangeNotifications = true;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            if (logger.isDebugEnabled()) {
                logger.debug(String.valueOf(this.getName()) + " : property change evt " + propertyChangeEvent);
            }
            if (this.allowChangeNotifications && (propertyChangeEvent.getPropertyName().equals("closeMe") || propertyChangeEvent.getPropertyName().equals("time"))) {
                PasserelleQuery.this._notifyListeners(this.getName());
            }
        }
    }

    class QueryFileChooser
    extends Box
    implements ActionListener {
        private URI _base;
        private JTextField _entryBox;
        private String _name;
        private File _startingDirectory;
        private FileFilter _fileFilter;
        private JButton button;

        public QueryFileChooser(String string, String string2, URI uRI, File file, FileFilter fileFilter) {
            this(string, string2, uRI, file, fileFilter, Color.white, Color.black);
        }

        public QueryFileChooser(String string, String string2, URI uRI, File file, FileFilter fileFilter, Color color, Color color2) {
            super(0);
            this._fileFilter = fileFilter;
            this._base = uRI;
            this._startingDirectory = file;
            this._entryBox = new JTextField(string2, PasserelleQuery.this.getTextWidth());
            this._entryBox.setBackground(color);
            this._entryBox.setForeground(color2);
            this.button = new JButton("Browse");
            this.button.addActionListener(this);
            this.add(this._entryBox);
            this.add(this.button);
            this._entryBox.addActionListener((ActionListener)new Query.QueryActionListener((Query)PasserelleQuery.this, string));
            this._entryBox.addFocusListener((FocusListener)new Query.QueryFocusListener((Query)PasserelleQuery.this, string));
            this._name = string;
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this._entryBox.setEnabled(bl);
            this.button.setEnabled(bl);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(this._startingDirectory);
            if (this._fileFilter != null) {
                jFileChooser.setFileFilter(this._fileFilter);
                jFileChooser.setAcceptAllFileFilterUsed(false);
            } else {
                jFileChooser.setAccessory((JComponent)new FinderAccessory(jFileChooser));
            }
            jFileChooser.setApproveButtonText("Select");
            jFileChooser.setApproveButtonMnemonic('S');
            int n = jFileChooser.showOpenDialog((Component)((Object)PasserelleQuery.this));
            if (n == 0) {
                if (this._base == null) {
                    try {
                        this._entryBox.setText(jFileChooser.getSelectedFile().getCanonicalPath());
                    }
                    catch (IOException iOException) {
                        this._entryBox.setText(jFileChooser.getSelectedFile().getName());
                    }
                } else {
                    File file = jFileChooser.getSelectedFile();
                    try {
                        file = file.getCanonicalFile();
                    }
                    catch (IOException iOException) {}
                    URI uRI = this._base.relativize(file.toURI());
                    this._entryBox.setText(uRI.toString());
                }
                PasserelleQuery.this._notifyListeners(this._name);
            }
        }

        public String getSelectedFileName() {
            return this._entryBox.getText();
        }

        public void setFileName(String string) {
            this._entryBox.setText(string);
        }
    }

    public static interface QueryLabelProvider {
        public String getLabelFor(Settable var1);
    }

    public static class RenameRequest
    extends MoMLChangeRequest {
        private String oldName;
        private String newName;

        public RenameRequest(Object object, NamedObj namedObj, String string, String string2, String string3) {
            super(object, namedObj, string);
            this.oldName = string2;
            this.newName = string3;
        }

        public String getOldName() {
            return this.oldName;
        }

        public String getNewName() {
            return this.newName;
        }
    }
}

