/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.gui;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.actor.gui.GetDocumentationAction;
import com.isencia.passerelle.actor.gui.LocatableNodeDragInteractor;
import com.isencia.passerelle.actor.gui.SaveInLibraryAction;
import com.isencia.passerelle.actor.gui.graph.EditorGraphController;
import com.isencia.passerelle.actor.gui.graph.ModelGraphPanel;
import com.isencia.passerelle.actor.gui.graph.ViewOpener;
import diva.canvas.interactor.DragInteractor;
import diva.graph.GraphController;
import diva.graph.NodeInteractor;
import diva.gui.toolbox.JContextMenu;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.DialogTableau;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.ModelDirectory;
import ptolemy.actor.gui.PortConfigurerDialog;
import ptolemy.actor.gui.TableauFrame;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.NamedObj;
import ptolemy.util.MessageHandler;
import ptolemy.vergil.basic.CustomizeDocumentationAction;
import ptolemy.vergil.basic.IconController;
import ptolemy.vergil.basic.RemoveCustomDocumentationAction;
import ptolemy.vergil.toolbox.FigureAction;
import ptolemy.vergil.toolbox.MenuActionFactory;
import ptolemy.vergil.toolbox.MenuItemFactory;
import ptolemy.vergil.toolbox.MoveAction;

public class PasserelleActorController
extends IconController {
    private static final Logger logger = LoggerFactory.getLogger(PasserelleActorController.class);
    protected LookInsideAction _lookInsideAction;
    protected SaveInLibraryAction _saveInLibraryAction;
    public static final Access FULL = new Access();
    public static final Access PARTIAL = new Access();
    protected MenuActionFactory _appearanceMenuActionFactory;
    private GetDocumentationAction _getDocumentationAction = new GetDocumentationAction();

    public PasserelleActorController(GraphController graphController) {
        this(graphController, FULL);
    }

    public PasserelleActorController(GraphController graphController, Access access) {
        super(graphController);
        Action[] actionArray = new Action[]{this._getDocumentationAction, new CustomizeDocumentationAction(), new RemoveCustomDocumentationAction()};
        this._menuFactory.addMenuItemFactory((MenuItemFactory)new MenuActionFactory(actionArray, "Documentation"));
        Action[] actionArray2 = new Action[]{new MoveAction("Send to Back", MoveAction.TO_FIRST), new MoveAction("Bring to Front", MoveAction.TO_LAST)};
        this._appearanceMenuActionFactory = new MenuActionFactory(actionArray2, "Appearance");
        this._menuFactory.addMenuItemFactory((MenuItemFactory)this._appearanceMenuActionFactory);
        this._lookInsideAction = new LookInsideAction(this);
        this._saveInLibraryAction = new SaveInLibraryAction();
        ((NodeInteractor)this.getNodeInteractor()).setDragInteractor((DragInteractor)new LocatableNodeDragInteractor(this));
        if (access == FULL) {
            this._menuFactory.addMenuItemFactory((MenuItemFactory)new PortDialogFactory());
            this._menuFactory.addMenuItemFactory((MenuItemFactory)new CompositeActorMenuItemFactory(this));
        }
    }

    public void postUndoableEdit(String string) {
        ((EditorGraphController)this.getController()).postUndoableEdit(string);
    }

    public void setConfiguration(Configuration configuration) {
        super.setConfiguration(configuration);
        this._getDocumentationAction.setConfiguration(configuration);
    }

    protected static class Access {
        protected Access() {
        }
    }

    private class CompositeActorMenuItemFactory
    implements MenuItemFactory {
        private PasserelleActorController ctrlr;

        public CompositeActorMenuItemFactory(PasserelleActorController passerelleActorController2) {
            this.ctrlr = passerelleActorController2;
        }

        public JMenuItem create(JContextMenu jContextMenu, NamedObj namedObj) {
            JMenuItem jMenuItem = null;
            if (namedObj != null && namedObj instanceof CompositeEntity) {
                PasserelleActorController.this._saveInLibraryAction.setConfiguration(this.ctrlr._configuration);
                jMenuItem = jContextMenu.add((Action)((Object)PasserelleActorController.this._lookInsideAction), "Look Inside");
            }
            return jMenuItem;
        }
    }

    private static class LookInsideAction
    extends FigureAction {
        private PasserelleActorController ctrlr;

        public LookInsideAction(PasserelleActorController passerelleActorController) {
            super("Look Inside");
            this.ctrlr = passerelleActorController;
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NamedObj namedObj;
            super.actionPerformed(actionEvent);
            NamedObj namedObj2 = this.getTarget();
            if (this.ctrlr._configuration == null) {
                namedObj = namedObj2.toplevel();
                if (namedObj instanceof Configuration) {
                    this.ctrlr._configuration = (Configuration)namedObj;
                } else {
                    this.ctrlr._configuration = new Configuration(namedObj2.workspace());
                    try {
                        new ModelDirectory((CompositeEntity)this.ctrlr._configuration, "directory");
                    }
                    catch (Exception exception) {
                        MessageHandler.error((String)"Cannot look inside without a configuration.");
                        return;
                    }
                }
            }
            try {
                namedObj = this.ctrlr.getController();
                ((ViewOpener)namedObj).openView(namedObj2, this.ctrlr._configuration);
            }
            catch (Exception exception) {
                MessageHandler.error((String)"Cannot open view for looking inside.", (Throwable)exception);
            }
        }
    }

    private static class PortDialogFactory
    implements MenuItemFactory {
        private static String _configPorts = "Configure Ports";
        private Configuration _configuration;

        private PortDialogFactory() {
        }

        public JMenuItem create(final JContextMenu jContextMenu, NamedObj namedObj) {
            JMenuItem jMenuItem = null;
            final NamedObj namedObj2 = namedObj;
            if (namedObj2 == null || !(namedObj2 instanceof Entity) || namedObj2 instanceof Actor) {
                return null;
            }
            AbstractAction abstractAction = new AbstractAction(_configPorts){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DialogTableau dialogTableau;
                    Component component = jContextMenu.getInvoker();
                    ModelGraphPanel modelGraphPanel = null;
                    while (component.getParent() != null) {
                        if (component instanceof ModelGraphPanel) {
                            modelGraphPanel = (ModelGraphPanel)component;
                        }
                        component = component.getParent();
                    }
                    if (modelGraphPanel != null) {
                        DialogTableau dialogTableau2 = DialogTableau.createDialog((Frame)((Frame)component), (Configuration)PortDialogFactory.this._configuration, (Effigy)modelGraphPanel.getEffigy(), PortConfigurerDialog.class, (Entity)((Entity)namedObj2));
                        if (dialogTableau2 != null) {
                            dialogTableau2.show();
                        }
                    } else if (component instanceof TableauFrame && (dialogTableau = DialogTableau.createDialog((Frame)((Frame)component), (Configuration)PortDialogFactory.this._configuration, (Effigy)((TableauFrame)component).getEffigy(), PortConfigurerDialog.class, (Entity)((Entity)namedObj2))) != null) {
                        dialogTableau.show();
                    }
                }
            };
            jMenuItem = jContextMenu.add((Action)abstractAction, _configPorts);
            return jMenuItem;
        }

        public void setConfiguration(Configuration configuration) {
            this._configuration = configuration;
        }
    }
}

