/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.gui;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.ModelDirectory;
import ptolemy.actor.gui.PtolemyEffigy;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.KernelRuntimeException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.util.MessageHandler;
import ptolemy.vergil.actor.DocApplicationSpecializer;
import ptolemy.vergil.actor.DocEffigy;
import ptolemy.vergil.actor.DocManager;
import ptolemy.vergil.actor.DocTableau;
import ptolemy.vergil.basic.DocAttribute;
import ptolemy.vergil.basic.KeplerDocumentationAttribute;
import ptolemy.vergil.toolbox.FigureAction;

public class GetDocumentationAction
extends FigureAction {
    protected Configuration _configuration;
    private static String _lastClassName = null;
    private int docPreference = 0;
    private Effigy _effigy = null;

    public GetDocumentationAction(int n) {
        super("Get Documentation");
        this.docPreference = n;
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    }

    public GetDocumentationAction() {
        super("Get Documentation");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        NamedObj namedObj;
        super.actionPerformed(actionEvent);
        if (this._configuration == null) {
            MessageHandler.error((String)"Cannot get documentation without a configuration.");
        }
        if ((namedObj = this.getTarget()) == null) {
            return;
        }
        this.showDocumentation(namedObj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void showDocumentation(NamedObj namedObj) {
        if (this._configuration == null) {
            MessageHandler.error((String)"Cannot get documentation without a configuration.");
        }
        List list = namedObj.attributeList(DocAttribute.class);
        KeplerDocumentationAttribute keplerDocumentationAttribute = (KeplerDocumentationAttribute)namedObj.getAttribute("KeplerDocumentation");
        int n = list.size();
        if (list.size() != 0 && keplerDocumentationAttribute != null) {
            if (this.docPreference == 0) {
                keplerDocumentationAttribute = null;
            } else if (this.docPreference == 1) {
                n = 0;
            }
        }
        if (keplerDocumentationAttribute != null) {
            DocAttribute docAttribute = keplerDocumentationAttribute.getDocAttribute(namedObj);
            if (docAttribute == null) throw new InternalErrorException("Error building Kepler documentation");
            this.showDocAttributeTableau(docAttribute, namedObj);
            return;
        }
        if (n != 0) {
            DocAttribute docAttribute = (DocAttribute)list.get(list.size() - 1);
            this.showDocAttributeTableau(docAttribute, namedObj);
            return;
        }
        String string = namedObj.getClass().getName();
        Effigy effigy = Configuration.findEffigy((NamedObj)namedObj);
        NamedObj namedObj2 = namedObj.getContainer();
        while (effigy == null && namedObj2 != null) {
            effigy = Configuration.findEffigy((NamedObj)namedObj2);
            namedObj2 = namedObj2.getContainer();
        }
        if (effigy == null) {
            effigy = new PtolemyEffigy(this._configuration.workspace());
            ((PtolemyEffigy)effigy).setModel(namedObj);
            ModelDirectory modelDirectory = this._configuration.getDirectory();
            try {
                effigy.setName(modelDirectory.uniqueName(namedObj.getName()));
                effigy.setContainer((CompositeEntity)modelDirectory);
                effigy.identifier.setExpression(this._effigyIdentifier(effigy, namedObj));
            }
            catch (Exception exception) {
                MessageHandler.error((String)("Cannot find documentation for " + string), (Throwable)exception);
            }
        }
        this.getDocumentation(this._configuration, string, effigy);
    }

    public void getDocumentation(Configuration configuration, String string, Effigy effigy) {
        block6: {
            try {
                URL uRL = DocManager.docClassNameToURL((Configuration)configuration, (String)string, (boolean)true, (boolean)true, (boolean)false, (boolean)false);
                if (uRL != null) {
                    _lastClassName = null;
                    configuration.openModel(null, uRL, uRL.toExternalForm());
                    break block6;
                }
                Parameter parameter = (Parameter)configuration.getAttribute("_docApplicationSpecializer", Parameter.class);
                if (parameter != null) {
                    String string2 = parameter.getExpression();
                    Class<?> clazz = Class.forName(string2);
                    DocApplicationSpecializer docApplicationSpecializer = (DocApplicationSpecializer)clazz.newInstance();
                    docApplicationSpecializer.handleDocumentationNotFound(string, effigy);
                    break block6;
                }
                throw new Exception("Could not get find documentation for " + string + "." + (DocManager.getRemoteDocumentationURLBase() != null ? " Also tried looking on \"" + DocManager.getRemoteDocumentationURLBase() + "\"." : ""));
            }
            catch (Exception exception) {
                try {
                    String string3 = "The documentation was not found.";
                    Object[] objectArray = new Object[]{"Ok"};
                    JOptionPane.showOptionDialog(this.getFrame(), string3, "Documentation not found", 2, 2, null, objectArray, objectArray[0]);
                }
                catch (Throwable throwable) {
                    MessageHandler.error((String)("Cannot find documentation for " + string), (Throwable)throwable);
                }
            }
        }
    }

    public void setConfiguration(Configuration configuration) {
        this._configuration = configuration;
    }

    public void setEffigy(Effigy effigy) {
        this._effigy = effigy;
    }

    private String _effigyIdentifier(Effigy effigy, NamedObj namedObj) {
        Effigy effigy2 = null;
        try {
            effigy2 = (Effigy)effigy.getContainer();
        }
        catch (ClassCastException classCastException) {}
        if (effigy2 == null) {
            return effigy.getFullName();
        }
        String string = effigy2.identifier.getExpression();
        String string2 = "#";
        if (string.indexOf("#") > 0) {
            string2 = ".";
        }
        return String.valueOf(string) + string2 + namedObj.getName();
    }

    private static boolean isMultipleDocumentationAllowed() {
        boolean bl = false;
        List list = Configuration.configurations();
        Configuration configuration2 = null;
        for (Configuration configuration2 : list) {
            if (configuration2 != null) break;
        }
        if (configuration2 == null) {
            throw new KernelRuntimeException("Could not find configuration, list of configurations was " + list.size() + " elements, all were null.");
        }
        StringAttribute stringAttribute = (StringAttribute)configuration2.getAttribute("_multipleDocumentationAllowed");
        if (stringAttribute != null) {
            bl = Boolean.parseBoolean(stringAttribute.getExpression());
        }
        return bl;
    }

    private void showDocAttributeTableau(DocAttribute docAttribute, NamedObj namedObj) {
        Effigy effigy = null;
        Effigy effigy2 = Configuration.findEffigy((NamedObj)namedObj);
        if (this._effigy == null) {
            if (effigy2 == null) {
                effigy2 = Configuration.findEffigy((NamedObj)namedObj.getContainer());
                if (effigy2 == null) {
                    MessageHandler.error((String)("Cannot find an effigy for " + namedObj.getFullName()));
                }
                effigy = effigy2.getEntity("DocEffigy");
            }
        } else {
            effigy = this._effigy;
        }
        if (effigy == null) {
            try {
                effigy = new DocEffigy((CompositeEntity)effigy2, "DocEffigy");
            }
            catch (KernelException kernelException) {
                throw new InternalErrorException((Throwable)kernelException);
            }
        }
        if (!(effigy instanceof DocEffigy)) {
            MessageHandler.error((String)"Found an effigy named DocEffigy that is not an instance of DocEffigy!");
        }
        ((DocEffigy)effigy).setDocAttribute(docAttribute);
        ComponentEntity componentEntity = effigy.getEntity("DocTableau");
        if (componentEntity == null) {
            try {
                componentEntity = new DocTableau((Effigy)((DocEffigy)effigy), "DocTableau");
                ((DocTableau)componentEntity).setTitle("Documentation for " + namedObj.getFullName());
            }
            catch (KernelException kernelException) {
                throw new InternalErrorException((Throwable)kernelException);
            }
        }
        if (GetDocumentationAction.isMultipleDocumentationAllowed()) {
            try {
                componentEntity = new DocTableau((Effigy)((DocEffigy)effigy), effigy.uniqueName("DocTableau"));
                ((DocTableau)componentEntity).setTitle("Documentation for " + namedObj.getFullName());
            }
            catch (KernelException kernelException) {
                MessageHandler.error((String)("Failed to display documentation for \" " + namedObj.getFullName() + "\"."), (Throwable)kernelException);
            }
        }
        if (!(componentEntity instanceof DocTableau)) {
            MessageHandler.error((String)"Found a tableau named DocTableau that is not an instance of DocTableau!");
        }
        ((DocTableau)componentEntity).show();
    }
}

