/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor.gui;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.core.ControlPort;
import com.isencia.passerelle.domain.cap.Director;
import diva.canvas.CompositeFigure;
import diva.canvas.Figure;
import diva.canvas.toolbox.LabelFigure;
import diva.graph.GraphController;
import diva.graph.GraphModel;
import diva.graph.basic.BasicLayoutTarget;
import diva.graph.layout.AbstractGlobalLayout;
import diva.graph.layout.LayoutTarget;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import ptolemy.actor.IOPort;
import ptolemy.actor.gui.PtolemyPreferences;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.Variable;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.util.MessageHandler;
import ptolemy.vergil.toolbox.PortSite;

public class ActorPortLayout
extends AbstractGlobalLayout {
    private static Font _portLabelFont = new Font("SansSerif", 0, 8);
    private GraphController graphController;

    public ActorPortLayout(GraphController graphController) {
        super((LayoutTarget)new BasicLayoutTarget(graphController));
        this.graphController = graphController;
    }

    public void layout(Object object) {
        Port port;
        GraphModel graphModel = this.graphController.getGraphModel();
        Iterator iterator = graphModel.nodes(object);
        Vector<Port> vector = new Vector<Port>();
        Vector<Port> vector2 = new Vector<Port>();
        Vector<Port> vector3 = new Vector<Port>();
        Vector<Port> vector4 = new Vector<Port>();
        while (iterator.hasNext()) {
            port = (Port)iterator.next();
            int n = ActorPortLayout._getCardinality(port);
            int n2 = ActorPortLayout._getDirection(n);
            if (n2 == 7) {
                vector.add(port);
                continue;
            }
            if (n2 == 1) {
                vector4.add(port);
                continue;
            }
            if (n2 == 3) {
                vector2.add(port);
                continue;
            }
            vector3.add(port);
        }
        port = (CompositeFigure)this.getLayoutTarget().getVisualObject(object);
        this._reOrderPorts(vector);
        this._placePortFigures((CompositeFigure)port, vector, 7);
        this._reOrderPorts(vector2);
        this._placePortFigures((CompositeFigure)port, vector2, 3);
        this._reOrderPorts(vector3);
        this._placePortFigures((CompositeFigure)port, vector3, 5);
        this._reOrderPorts(vector4);
        this._placePortFigures((CompositeFigure)port, vector4, 1);
    }

    private void _reOrderPorts(Vector vector) {
        int n = vector.size();
        Enumeration enumeration = vector.elements();
        StringAttribute stringAttribute = null;
        int n2 = 0;
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            Port port = (Port)enumeration.nextElement();
            stringAttribute = (StringAttribute)port.getAttribute("_ordinal");
            if (stringAttribute != null) {
                n2 = Integer.parseInt(stringAttribute.getExpression());
                if (n2 >= n) {
                    vector.remove(n3);
                    try {
                        stringAttribute.setExpression(Integer.toString(n - 1));
                    }
                    catch (Exception exception) {
                        MessageHandler.error((String)"Error setting ordinal property", (Throwable)exception);
                    }
                    vector.add(port);
                } else if (n2 < 0) {
                    vector.remove(n3);
                    try {
                        stringAttribute.setExpression(Integer.toString(0));
                    }
                    catch (Exception exception) {
                        MessageHandler.error((String)"Error setting ordinal property", (Throwable)exception);
                    }
                    vector.add(0, port);
                } else if (n2 != n3) {
                    vector.remove(n3);
                    vector.add(n2, port);
                }
            }
            ++n3;
        }
    }

    private void _placePortFigures(CompositeFigure compositeFigure, List list, int n) {
        Iterator iterator = list.iterator();
        int n2 = 0;
        int n3 = list.size();
        Figure figure = compositeFigure.getBackgroundFigure();
        if (figure == null) {
            figure = compositeFigure;
        }
        while (iterator.hasNext()) {
            String string;
            Attribute attribute;
            String string2;
            boolean bl;
            IOPort iOPort = (IOPort)iterator.next();
            Figure figure2 = this.graphController.getFigure((Object)iOPort);
            if (figure2 == null) continue;
            Rectangle2D rectangle2D = figure2.getShape().getBounds2D();
            PortSite portSite = new PortSite(figure, (Port)iOPort, n2, n3, n);
            ++n2;
            double d = portSite.getX() - rectangle2D.getCenterX();
            double d2 = portSite.getY() - rectangle2D.getCenterY();
            figure2.translate(d, d2);
            boolean bl2 = false;
            if (iOPort.getContainer() instanceof Actor) {
                Actor actor = (Actor)iOPort.getContainer();
                try {
                    bl2 = ((Director)actor.getDirector()).isExpertMode();
                }
                catch (Exception exception) {}
            }
            boolean bl3 = bl = iOPort.getWidth() > 0;
            if (iOPort instanceof ControlPort && !bl && !bl2) {
                figure2.setVisible(false);
                continue;
            }
            Attribute attribute2 = iOPort.getAttribute("_showRate");
            if (iOPort instanceof IOPort && attribute2 instanceof Variable) {
                boolean bl4 = false;
                try {
                    bl4 = ((Variable)attribute2).getToken().equals(BooleanToken.TRUE);
                }
                catch (Exception exception) {}
                if (bl4) {
                    string2 = "";
                    attribute = null;
                    if (iOPort.isInput()) {
                        attribute = (Variable)iOPort.getAttribute("tokenConsumptionRate");
                        if (attribute == null) {
                            string = "_tokenConsumptionRate";
                            attribute = (Variable)iOPort.getAttribute(string);
                        }
                    } else if (iOPort.isOutput() && (attribute = (Variable)iOPort.getAttribute("tokenProductionRate")) == null) {
                        string = "_tokenProductionRate";
                        attribute = (Variable)iOPort.getAttribute(string);
                    }
                    if (attribute != null) {
                        try {
                            string2 = attribute.getToken().toString();
                        }
                        catch (KernelException kernelException) {}
                    }
                    string = this._createPortLabelFigure(string2, _portLabelFont, d, d2, n);
                    string.setFillPaint((Paint)Color.BLUE);
                    compositeFigure.add((Figure)string);
                }
            }
            Token token = PtolemyPreferences.preferenceValueLocal((NamedObj)iOPort.toplevel(), (String)"_showPortNames");
            string2 = null;
            if (token != null) {
                boolean bl5 = true;
                if (token instanceof BooleanToken) {
                    bl5 = ((BooleanToken)token).booleanValue();
                }
                if (bl5) {
                    string2 = iOPort.getDisplayName();
                }
            }
            attribute = iOPort.getAttribute("_showInfo");
            try {
                if (attribute instanceof Variable && !((Variable)attribute).isStringMode()) {
                    string = ((Variable)attribute).getToken().toString();
                    string2 = string2 != null ? String.valueOf(string2) + " (" + string + ")" : string;
                } else if (attribute instanceof Settable) {
                    string2 = string2 != null ? String.valueOf(string2) + " (" + ((Settable)attribute).getExpression() + ")" : ((Settable)attribute).getExpression();
                }
            }
            catch (IllegalActionException illegalActionException) {
                string2 = String.valueOf(string2) + illegalActionException.getMessage();
            }
            if (string2 == null) continue;
            string = this._createPortLabelFigure(string2, _portLabelFont, d, d2, n);
            compositeFigure.add((Figure)string);
        }
    }

    private LabelFigure _createPortLabelFigure(String string, Font font, double d, double d2, int n) {
        LabelFigure labelFigure;
        if (n == 5) {
            labelFigure = new LabelFigure(string, font, 1.0, 6);
            labelFigure.translateTo(d, d2 + 5.0);
            AffineTransform affineTransform = AffineTransform.getRotateInstance(1.5707963267948966, d, d2 + 5.0);
            labelFigure.transform(affineTransform);
        } else if (n == 3) {
            labelFigure = new LabelFigure(string, font, 1.0, 6);
            labelFigure.translateTo(d + 5.0, d2);
        } else if (n == 7) {
            labelFigure = new LabelFigure(string, font, 1.0, 4);
            labelFigure.translateTo(d - 5.0, d2);
        } else {
            labelFigure = new LabelFigure(string, font, 1.0, 6);
            labelFigure.translateTo(d, d2 - 5.0);
            AffineTransform affineTransform = AffineTransform.getRotateInstance(-1.5707963267948966, d, d2 - 5.0);
            labelFigure.transform(affineTransform);
        }
        return labelFigure;
    }

    protected static int _getCardinality(Port port) {
        Token token;
        Parameter parameter;
        NamedObj namedObj;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (port instanceof IOPort) {
            bl = ((IOPort)port).isInput();
            bl2 = ((IOPort)port).isOutput();
            bl3 = bl && bl2;
        }
        StringAttribute stringAttribute = null;
        int n = 0;
        try {
            stringAttribute = (StringAttribute)port.getAttribute("_cardinal", StringAttribute.class);
            namedObj = port.getContainer();
            if (namedObj != null && (parameter = (Parameter)namedObj.getAttribute("_rotatePorts", Parameter.class)) != null && (token = parameter.getToken()) instanceof IntToken) {
                n = ((IntToken)token).intValue();
            }
        }
        catch (IllegalActionException illegalActionException) {}
        if (stringAttribute == null) {
            if (bl3) {
                n -= 90;
            } else if (bl2) {
                n += 180;
            }
        } else {
            n = stringAttribute.getExpression().equalsIgnoreCase("NORTH") ? 90 : (stringAttribute.getExpression().equalsIgnoreCase("SOUTH") ? -90 : (stringAttribute.getExpression().equalsIgnoreCase("EAST") ? 180 : (stringAttribute.getExpression().equalsIgnoreCase("WEST") ? 0 : (n -= 90))));
        }
        n = 90 * (n / 90 % 4);
        try {
            namedObj = port.getContainer();
            if (namedObj != null) {
                Token token2;
                parameter = (Parameter)namedObj.getAttribute("_flipPortsHorizontal", Parameter.class);
                if (parameter != null && (token = parameter.getToken()) instanceof BooleanToken && ((BooleanToken)token).booleanValue()) {
                    if (n == 0 || n == -180) {
                        n += 180;
                    } else if (n == 180) {
                        n = 0;
                    }
                }
                if ((token = (Parameter)namedObj.getAttribute("_flipPortsVertical", Parameter.class)) != null && (token2 = token.getToken()) instanceof BooleanToken && ((BooleanToken)token2).booleanValue()) {
                    if (n == -270 || n == -90) {
                        n += 180;
                    } else if (n == 90 || n == 270) {
                        n -= 180;
                    }
                }
            }
        }
        catch (IllegalActionException illegalActionException) {}
        return n;
    }

    protected static int _getDirection(int n) {
        int n2 = n == 90 || n == -270 ? 1 : (n == 180 || n == -180 ? 3 : (n == 270 || n == -90 ? 5 : 7));
        return n2;
    }
}

