/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.actor;

import com.isencia.message.ChannelException;
import com.isencia.message.IReceiverChannel;
import com.isencia.message.NoMoreMessagesException;
import com.isencia.message.interceptor.IMessageInterceptor;
import com.isencia.message.interceptor.IMessageInterceptorChain;
import com.isencia.message.interceptor.MessageInterceptorChain;
import com.isencia.passerelle.actor.InitializationException;
import com.isencia.passerelle.actor.ProcessingException;
import com.isencia.passerelle.actor.TerminationException;
import com.isencia.passerelle.actor.TriggeredSource;
import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.message.ManagedMessage;
import com.isencia.passerelle.message.MessageFactory;
import com.isencia.passerelle.message.interceptor.TextToMessageConverter;
import com.isencia.passerelle.message.xml.XmlMessageHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.gui.style.CheckBoxStyle;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public abstract class TriggeredChannelSource
extends TriggeredSource {
    private static Logger logger = LoggerFactory.getLogger(TriggeredChannelSource.class);
    private IReceiverChannel receiverChannel = null;
    public Parameter passThroughParam = new Parameter((NamedObj)this, "PassThrough", (Token)new BooleanToken(false));
    private boolean passThrough = true;
    private Long sequenceID;
    private long sequencePosition = 0L;
    private Object messageBuffer = null;
    private boolean readAheadOK = false;
    private boolean isEndOfSequence = false;
    private IMessageInterceptorChain interceptorChain = null;

    public TriggeredChannelSource(CompositeEntity compositeEntity, String string) throws NameDuplicationException, IllegalActionException {
        super(compositeEntity, string);
        this.passThroughParam.setTypeEquals((Type)BaseType.BOOLEAN);
        this.registerExpertParameter(this.passThroughParam);
        new CheckBoxStyle(this.passThroughParam, "style");
    }

    public IReceiverChannel getChannel() {
        return this.receiverChannel;
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + attribute);
        }
        if (attribute == this.passThroughParam) {
            this.passThrough = ((BooleanToken)this.passThroughParam.getToken()).booleanValue();
        } else {
            super.attributeChanged(attribute);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    @Override
    protected void doInitialize() throws InitializationException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        super.doInitialize();
        IReceiverChannel iReceiverChannel = null;
        this.readAheadOK = false;
        try {
            iReceiverChannel = this.createChannel();
        }
        catch (ChannelException channelException) {
            throw new InitializationException(PasserelleException.Severity.FATAL, "Receiver channel for " + this.getInfo() + " not created correctly.", this, channelException);
        }
        if (iReceiverChannel == null) {
            throw new InitializationException(PasserelleException.Severity.FATAL, "Receiver channel for " + this.getInfo() + " not created correctly.", this, null);
        }
        try {
            this.closeChannel(this.getChannel());
        }
        catch (ChannelException channelException) {
            throw new InitializationException("Receiver channel for " + this.getInfo() + " not initialized correctly.", this.getChannel(), channelException);
        }
        this.receiverChannel = iReceiverChannel;
        if (!this.isPassThrough()) {
            this.interceptorChain = this.createInterceptorChain();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    @Override
    protected boolean doPreFire() throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        boolean bl = true;
        if (this.mustWaitForTrigger()) {
            this.waitForTrigger();
            if (this.isFinishRequested()) {
                bl = false;
            }
        }
        try {
            if (!this.getChannel().isOpen()) {
                this.openChannel(this.getChannel());
                if (logger.isInfoEnabled()) {
                    logger.info(String.valueOf(this.getInfo()) + " - Opened :" + this.getChannel());
                }
            }
            if (bl) {
                bl = super.doPreFire();
            }
        }
        catch (ChannelException channelException) {
            throw new ProcessingException(PasserelleException.Severity.FATAL, "Receiver channel for " + this.getInfo() + " not opened correctly.", this.getChannel(), channelException);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit " + " :" + bl);
        }
        return bl;
    }

    @Override
    protected boolean doPostFire() throws ProcessingException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        try {
            if (this.hasNoMoreMessages()) {
                this.closeChannel(this.getChannel());
            }
        }
        catch (ChannelException channelException) {
            throw new ProcessingException("Receiver channel for " + this.getInfo() + " not closed correctly.", this.getChannel(), channelException);
        }
        boolean bl = super.doPostFire();
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit " + " :" + bl);
        }
        return bl;
    }

    @Override
    protected void doWrapUp() throws TerminationException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.getInfo());
        }
        try {
            this.closeChannel(this.getChannel());
            if (logger.isInfoEnabled()) {
                logger.info(String.valueOf(this.getInfo()) + " - Closed :" + this.getChannel());
            }
        }
        catch (ChannelException channelException) {
            throw new TerminationException("Receiver channel for " + this.getInfo() + " not closed correctly.", this.getChannel(), channelException);
        }
        super.doWrapUp();
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    protected abstract IReceiverChannel createChannel() throws ChannelException;

    protected IMessageInterceptorChain createInterceptorChain() {
        MessageInterceptorChain messageInterceptorChain = new MessageInterceptorChain();
        messageInterceptorChain.add((IMessageInterceptor)new TextToMessageConverter(this));
        return messageInterceptorChain;
    }

    @Override
    protected ManagedMessage getMessage() throws ProcessingException {
        ManagedMessage managedMessage;
        block15: {
            if (logger.isTraceEnabled()) {
                logger.trace(this.getInfo());
            }
            managedMessage = null;
            if (!this.readAheadOK) {
                this.readAheadOK = true;
                try {
                    this.messageBuffer = this.getChannel().getMessage();
                }
                catch (NoMoreMessagesException noMoreMessagesException) {
                }
                catch (Exception exception) {
                    throw new ProcessingException(String.valueOf(this.getInfo()) + " - getMessage() generated exception while reading from channel", this.getChannel(), exception);
                }
            }
            if (this.messageBuffer != null) {
                Object object = null;
                try {
                    object = this.getChannel().getMessage();
                    if (this.isPassThrough()) {
                        managedMessage = XmlMessageHelper.getMessageFromXML((String)this.messageBuffer);
                    } else {
                        boolean bl = this.isEndOfSequence = object == null;
                        managedMessage = this.interceptorChain != null ? (ManagedMessage)this.interceptorChain.accept(this.messageBuffer) : (ManagedMessage)this.messageBuffer;
                    }
                }
                catch (NoMoreMessagesException noMoreMessagesException) {
                    this.messageBuffer = object;
                    break block15;
                }
                catch (Exception exception) {
                    try {
                        throw new ProcessingException(String.valueOf(this.getInfo()) + " - getMessage() generated exception", managedMessage, exception);
                    }
                    catch (Throwable throwable) {
                        this.messageBuffer = object;
                        throw throwable;
                    }
                }
                this.messageBuffer = object;
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit " + " - Received msg :" + managedMessage);
        }
        return managedMessage;
    }

    protected void closeChannel(IReceiverChannel iReceiverChannel) throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + iReceiverChannel);
        }
        if (iReceiverChannel != null && iReceiverChannel.isOpen()) {
            iReceiverChannel.close();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    @Override
    protected boolean mustWaitForTrigger() {
        return !this.getChannel().isOpen();
    }

    protected void openChannel(IReceiverChannel iReceiverChannel) throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " :" + iReceiverChannel);
        }
        if (iReceiverChannel != null && !iReceiverChannel.isOpen()) {
            iReceiverChannel.open();
            this.sequenceID = MessageFactory.getInstance().createSequenceID();
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getInfo()) + " - exit ");
        }
    }

    public boolean isPassThrough() {
        return this.passThrough;
    }

    public void setPassThrough(boolean bl) {
        this.passThrough = bl;
    }

    @Override
    public ManagedMessage createMessage() {
        return MessageFactory.getInstance().createMessageInSequence(this.sequenceID, new Long(this.sequencePosition++), this.isEndOfSequence, this.getStandardMessageHeaders());
    }
}

